/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.registry.GameRegistry;
import galacticgreg.GalacticGreg;
import galacticgreg.TileEntitySpaceOres;
import galacticgreg.WorldgenOreLayerSpace;
import galacticgreg.WorldgenOreSmallSpace;
import galacticgreg.api.AsteroidBlockComb;
import galacticgreg.api.BlockMetaComb;
import galacticgreg.api.Enums;
import galacticgreg.api.GTOreTypes;
import galacticgreg.api.ISpaceObjectGenerator;
import galacticgreg.api.ModDimensionDef;
import galacticgreg.api.SpecialBlockComb;
import galacticgreg.api.StructureInformation;
import galacticgreg.auxiliary.GTOreGroup;
import galacticgreg.dynconfig.DynamicDimensionConfig;
import galacticgreg.registry.GalacticGregRegistry;
import gregtech.api.util.GTLog;
import gregtech.api.world.GTWorldgen;
import gregtech.common.GTWorldgenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ChestGenHooks;

public class WorldGeneratorSpace
implements IWorldGenerator {
    public static boolean sAsteroids = true;
    private final EventBus eventBus = new EventBus();
    private World worldObj;
    private int chunkX;
    private int chunkZ;
    private final int mSize = 100;
    private long mProfilingStart;
    private long mProfilingEnd;

    public WorldGeneratorSpace() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)Integer.MAX_VALUE);
    }

    public void generate(Random pRandom, int pX, int pZ, World pWorld, IChunkProvider pChunkGenerator, IChunkProvider pChunkProvider) {
        String tBiome = pWorld.func_72807_a((int)((pX *= 16) + 8), (int)((pZ *= 16) + 8)).field_76791_y;
        pRandom = new Random(pRandom.nextInt());
        if (tBiome == null) {
            tBiome = BiomeGenBase.field_76772_c.field_76791_y;
        }
        GalacticGreg.Logger.trace("Triggered generate: [ChunkGenerator %s] [Biome %s]", pChunkGenerator.toString(), tBiome);
        ModDimensionDef tDimDef = GalacticGregRegistry.getDimensionTypeByChunkGenerator(pChunkGenerator);
        if (tDimDef == null) {
            GalacticGreg.Logger.trace("Ignoring ChunkGenerator type %s as there is no definition for it in the registry", pChunkGenerator.toString());
            return;
        }
        GalacticGreg.Logger.trace("Selected DimDef: [%s]", tDimDef.getDimIdentifier());
        if (tDimDef.getDimensionType() != Enums.DimensionType.Planet) {
            if (tDimDef.getRandomAsteroidMaterial() == null) {
                GalacticGreg.Logger.error("Dimension [%s] is set to Asteroids, but no asteroid material is specified! Nothing will generate", tDimDef.getDimensionName());
            } else {
                this.Generate_Asteroids(tDimDef, pRandom, pWorld, pX, pZ);
            }
        } else if (tDimDef.getDimensionType() != Enums.DimensionType.Asteroid) {
            this.Generate_OreVeins(tDimDef, pRandom, pWorld, pX, pZ, "", pChunkGenerator, pChunkProvider);
        }
        Chunk tChunk = pWorld.func_72938_d(pX, pZ);
        if (tChunk != null) {
            tChunk.field_76643_l = true;
        }
    }

    private void Generate_Asteroids(ModDimensionDef pDimensionDef, Random pRandom, World pWorld, int pX, int pZ) {
        GalacticGreg.Logger.trace("Running asteroid-gen in Dim %s", pDimensionDef.getDimIdentifier());
        DynamicDimensionConfig.AsteroidConfig tAConf = DynamicDimensionConfig.getAsteroidConfig(pDimensionDef);
        if (tAConf == null) {
            GalacticGreg.Logger.error("Dimension %s is set to asteroid, but no config object can be found. Skipping!", pDimensionDef.getDimIdentifier());
            return;
        }
        GalacticGreg.Logger.trace("Asteroid probability: %d", tAConf.Probability);
        if (tAConf.Probability <= 1 || pRandom.nextInt(tAConf.Probability) == 0) {
            int tZ;
            int tY;
            int tX;
            GalacticGreg.Logger.trace("Generating asteroid NOW", new Object[0]);
            if (GalacticGreg.GalacticConfig.ProfileOreGen) {
                this.mProfilingStart = System.currentTimeMillis();
            }
            if (pWorld.func_147439_a(tX = pX + pRandom.nextInt(16), tY = 50 + pRandom.nextInt(150), tZ = pZ + pRandom.nextInt(16)).isAir((IBlockAccess)pWorld, tX, tY, tZ)) {
                int tCustomAsteroidOffset = -1;
                boolean tGraniteMeta = false;
                GTOreGroup tOreGroup = WorldgenOreLayerSpace.getRandomOreGroup(pDimensionDef, pRandom, true);
                AsteroidBlockComb tABComb = pDimensionDef.getRandomAsteroidMaterial();
                if (tABComb == null) {
                    return;
                }
                Block tFinalAsteroidBlock = tABComb.getBlock();
                int tFinalAsteroidBlockMeta = tABComb.getMeta();
                int tFinalOreOffset = tABComb.getOreMaterial().getOffset();
                int tFinalUpdateMode = tABComb.getOreMaterial().getUpdateMode();
                GalacticGreg.Logger.debug("Asteroid will be build with: Block: [%s] OreType: [%s]", Block.field_149771_c.func_148750_c((Object)tABComb.getBlock()), tABComb.getOreMaterial().toString());
                ISpaceObjectGenerator aGen = pDimensionDef.getRandomSOGenerator(Enums.SpaceObjectType.OreAsteroid);
                if (aGen == null) {
                    GalacticGreg.Logger.ot_error("GalacticGreg.Generate_Asteroids.NoSOGenFound", "No SpaceObjectGenerator has been registered for type ORE_ASTEROID in Dimension %s. Nothing will generate", pDimensionDef.getDimensionName());
                    return;
                }
                aGen.reset();
                aGen.setCenterPoint(tX, tY, tZ);
                aGen.randomize(tAConf.MinSize, tAConf.MaxSize);
                aGen.calculate();
                Vec3 tChestPosition = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                boolean tDoLootChest = false;
                int tNumLootItems = 0;
                if (tAConf.LootChestChance > 0) {
                    GalacticGreg.Logger.trace("Random loot chest enabled, flipping the coin", new Object[0]);
                    int tChance = pRandom.nextInt(100);
                    if (tAConf.LootChestChance >= tChance) {
                        GalacticGreg.Logger.debug("We got a match. Preparing to generate the loot chest", new Object[0]);
                        tNumLootItems = tAConf.RandomizeNumLootItems ? pRandom.nextInt(tAConf.NumLootItems - 1) + 1 : tAConf.NumLootItems;
                        GalacticGreg.Logger.debug(String.format("Loot chest random item count will be: %d", tNumLootItems), new Object[0]);
                        GalacticGreg.Logger.trace("Starting lookup for valid asteroid-block for the chest", new Object[0]);
                        for (int x = 0; x < 64; ++x) {
                            int tRndBlock = pRandom.nextInt(aGen.getStructure().size());
                            StructureInformation tChestSI = aGen.getStructure().get(tRndBlock);
                            if (tChestSI.getBlockPosition() == Enums.TargetBlockPosition.AsteroidShell) continue;
                            GalacticGreg.Logger.debug(String.format("Chest position found [x:%d y:%d z:%d]", tChestSI.getX(), tChestSI.getY(), tChestSI.getZ()), new Object[0]);
                            tChestPosition = Vec3.func_72443_a((double)tChestSI.getX(), (double)tChestSI.getY(), (double)tChestSI.getZ());
                            tDoLootChest = true;
                            break;
                        }
                    }
                }
                GalacticGreg.Logger.trace("Now generating Space-Structure", new Object[0]);
                for (StructureInformation si : aGen.getStructure()) {
                    if (!pWorld.func_147437_c(si.getX(), si.getY(), si.getZ())) continue;
                    if (tDoLootChest && (int)tChestPosition.field_72450_a == si.getX() && (int)tChestPosition.field_72448_b == si.getY() && (int)tChestPosition.field_72449_c == si.getZ()) {
                        GalacticGreg.Logger.trace("Now generating LootChest and contents", new Object[0]);
                        WeightedRandomChestContent[] tRandomLoot = ChestGenHooks.getItems((String)DynamicDimensionConfig.getLootChestTable(tAConf), (Random)pRandom);
                        BlockMetaComb tTargetChestType = GalacticGreg.GalacticConfig.CustomLootChest;
                        if (tTargetChestType.getMeta() > 0) {
                            pWorld.func_147465_d(si.getX(), si.getY(), si.getZ(), tTargetChestType.getBlock(), tTargetChestType.getMeta(), 2);
                        } else {
                            pWorld.func_147449_b(si.getX(), si.getY(), si.getZ(), tTargetChestType.getBlock());
                        }
                        IInventory entityChestInventory = (IInventory)pWorld.func_147438_o(si.getX(), si.getY(), si.getZ());
                        if (entityChestInventory != null) {
                            if (!pWorld.field_72995_K) {
                                WeightedRandomChestContent.func_76293_a((Random)pRandom, (WeightedRandomChestContent[])tRandomLoot, (IInventory)entityChestInventory, (int)tNumLootItems);
                                GalacticGreg.Logger.trace("Loot chest successfully generated", new Object[0]);
                            }
                        } else {
                            GalacticGreg.Logger.warn("Could not create lootchest at X[%d] Y[%d] Z[%d]. getTileEntity() returned null", si.getX(), si.getY(), si.getZ());
                        }
                        tDoLootChest = false;
                        GalacticGreg.Logger.debug("Generated LootChest at X[%d] Y[%d] Z[%d]", si.getX(), si.getY(), si.getZ());
                        continue;
                    }
                    boolean tPlacedOreBlock = false;
                    if (tOreGroup != null) {
                        int ranOre = pRandom.nextInt(100);
                        int tFinalOreMeta = 0;
                        if (ranOre < tAConf.OreChance) {
                            if (pRandom.nextBoolean()) {
                                if (tOreGroup.SporadicBetweenMeta > 0) {
                                    tFinalOreMeta = tOreGroup.SporadicBetweenMeta;
                                }
                            } else if (tOreGroup.SporadicAroundMeta > 0) {
                                tFinalOreMeta = tOreGroup.SporadicAroundMeta;
                            }
                        } else if (ranOre < tAConf.OreChance + tAConf.OrePrimaryOffset) {
                            if (pRandom.nextBoolean()) {
                                if (tOreGroup.PrimaryMeta > 0) {
                                    tFinalOreMeta = tOreGroup.PrimaryMeta;
                                }
                            } else if (tOreGroup.SecondaryMeta > 0) {
                                tFinalOreMeta = tOreGroup.SecondaryMeta;
                            }
                        }
                        if (tFinalOreMeta > 0) {
                            if (tAConf.HiddenOres && si.getBlockPosition() == Enums.TargetBlockPosition.AsteroidShell) {
                                GalacticGreg.Logger.trace("Skipping ore-placement event (HiddenOres=true; TargetBlockPosition=AsteroidShell)", new Object[0]);
                            } else {
                                tPlacedOreBlock = TileEntitySpaceOres.setOuterSpaceOreBlock(pDimensionDef, pWorld, si.getX(), si.getY(), si.getZ(), tOreGroup.SecondaryMeta, true, tFinalOreOffset);
                            }
                        }
                    }
                    if (tPlacedOreBlock) continue;
                    boolean tFlag = this.doGenerateSpecialBlocks(pDimensionDef, pRandom, pWorld, tAConf, si.getX(), si.getY(), si.getZ(), si.getBlockPosition());
                    if (tFlag) {
                        tFlag = this.doGenerateSmallOreBlock(pDimensionDef, pRandom, pWorld, tAConf, si.getX(), si.getY(), si.getZ(), tFinalOreOffset);
                    }
                    if (!tFlag) continue;
                    pWorld.func_147465_d(si.getX(), si.getY(), si.getZ(), tFinalAsteroidBlock, tFinalAsteroidBlockMeta, tFinalUpdateMode);
                }
            }
            if (GalacticGreg.GalacticConfig.ProfileOreGen) {
                try {
                    this.mProfilingEnd = System.currentTimeMillis();
                    long tTotalTime = this.mProfilingEnd - this.mProfilingStart;
                    GalacticGreg.Profiler.AddTimeToList(pDimensionDef, tTotalTime);
                    GalacticGreg.Logger.debug("Done with Asteroid-Worldgen in DimensionType %s. Generation took %d ms", pDimensionDef.getDimensionName(), tTotalTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        GalacticGreg.Logger.trace("Leaving asteroid-gen for Dim %s", pDimensionDef.getDimIdentifier());
    }

    private boolean doGenerateSpecialBlocks(ModDimensionDef pDimensionDef, Random pRandom, World pWorld, DynamicDimensionConfig.AsteroidConfig tAConf, int eX, int eY, int eZ, Enums.TargetBlockPosition pBlockPosition) {
        SpecialBlockComb bmc;
        boolean tFlag = true;
        if (tAConf.SpecialBlockChance > 0 && pRandom.nextInt(100) < tAConf.SpecialBlockChance && (bmc = pDimensionDef.getRandomSpecialAsteroidBlock()) != null) {
            boolean tIsAllowed = false;
            switch (bmc.getBlockPosition()) {
                case AsteroidCore: {
                    if (pBlockPosition != Enums.TargetBlockPosition.AsteroidCore) break;
                    tIsAllowed = true;
                    break;
                }
                case AsteroidCoreAndShell: {
                    if (pBlockPosition != Enums.TargetBlockPosition.AsteroidCore && pBlockPosition != Enums.TargetBlockPosition.AsteroidShell) break;
                    tIsAllowed = true;
                    break;
                }
                case AsteroidShell: {
                    if (pBlockPosition != Enums.TargetBlockPosition.AsteroidShell) break;
                    tIsAllowed = true;
                    break;
                }
                case AsteroidInnerCore: {
                    if (pBlockPosition != Enums.TargetBlockPosition.AsteroidInnerCore) break;
                    tIsAllowed = true;
                    break;
                }
            }
            if (tIsAllowed) {
                pWorld.func_147465_d(eX, eY, eZ, bmc.getBlock(), bmc.getMeta(), 2);
                tFlag = false;
            }
        }
        return tFlag;
    }

    private boolean doGenerateSmallOreBlock(ModDimensionDef pDimDef, Random pRandom, World pWorld, DynamicDimensionConfig.AsteroidConfig pAConf, int pX, int pY, int pZ, int pTargetBlockOffset) {
        boolean tFlag = true;
        if (pAConf.SmallOreChance > 0 && pRandom.nextInt(100) < pAConf.SmallOreChance) {
            boolean continueSearch = true;
            int tFoundOreMeta = -1;
            for (int i = 0; i < 256 && continueSearch; ++i) {
                int tRandomWeight = pRandom.nextInt(WorldgenOreLayerSpace.sWeight);
                for (GTWorldgen tWorldGen : GalacticGreg.smallOreWorldgenList) {
                    if (!(tWorldGen instanceof WorldgenOreSmallSpace) || !((WorldgenOreSmallSpace)tWorldGen).isEnabledForDim(pDimDef) || pAConf.ObeyHeightLimits && !((WorldgenOreSmallSpace)tWorldGen).isAllowedForHeight(pY) || (tRandomWeight -= ((WorldgenOreSmallSpace)tWorldGen).mAmount) > 0) continue;
                    tFoundOreMeta = ((WorldgenOreSmallSpace)tWorldGen).mMeta;
                    continueSearch = false;
                }
            }
            if (tFoundOreMeta > -1) {
                int tCustomOffset = GTOreTypes.SmallOres.getOffset() + pTargetBlockOffset;
                TileEntitySpaceOres.setOuterSpaceOreBlock(pDimDef, pWorld, pX, pY, pZ, tFoundOreMeta, true, tCustomOffset);
                tFlag = false;
            }
        }
        return tFlag;
    }

    private void Generate_OreVeins(ModDimensionDef pDimensionDef, Random pRandom, World pWorld, int pX, int pZ, String pBiome, IChunkProvider pChunkGenerator, IChunkProvider pChunkProvider) {
        GalacticGreg.Logger.trace("Running orevein-gen in Dim %s", pDimensionDef.getDimIdentifier());
        if (GTWorldgenerator.isOreChunk(pX / 16, pZ / 16)) {
            if (WorldgenOreLayerSpace.sWeight > 0 && !GalacticGreg.oreVeinWorldgenList.isEmpty()) {
                boolean temp = true;
                block4: for (int i = 0; i < 256 && temp; ++i) {
                    int tRandomWeight = pRandom.nextInt(WorldgenOreLayerSpace.sWeight);
                    for (GTWorldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                        if (tWorldGen instanceof WorldgenOreLayerSpace) {
                            tRandomWeight -= ((WorldgenOreLayerSpace)tWorldGen).mWeight;
                        }
                        if (tRandomWeight > 0) continue;
                        try {
                            if (!tWorldGen.executeWorldgen(pWorld, pRandom, pBiome, Integer.MIN_VALUE, pX, pZ, pChunkGenerator, pChunkProvider)) continue block4;
                            temp = false;
                        }
                        catch (Throwable e) {
                            e.printStackTrace(GTLog.err);
                        }
                        continue block4;
                    }
                }
            }
            int i = 0;
            int tX = pX - 16;
            while (i < 3) {
                int j = 0;
                int tZ = pZ - 16;
                while (j < 3) {
                    for (GTWorldgen tWorldGen : GalacticGreg.smallOreWorldgenList) {
                        try {
                            tWorldGen.executeWorldgen(pWorld, pRandom, "", Integer.MIN_VALUE, tX, tZ, pChunkGenerator, pChunkProvider);
                        }
                        catch (Throwable e) {
                            e.printStackTrace(GTLog.err);
                        }
                    }
                    ++j;
                    tZ += 16;
                }
                ++i;
                tX += 16;
            }
        }
        GalacticGreg.Logger.trace("Leaving orevein-gen for Dim %s", pDimensionDef.getDimIdentifier());
    }
}

