/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IMicroMaterialRender;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.multipart.microblock.IMicroBlock;
import com.rwtema.extrautils.multipart.microblock.ItemMicroBlock;
import com.rwtema.extrautils.multipart.microblock.PartMicroBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class PartConnecting
extends PartMicroBlock
implements JIconHitEffects,
IMicroMaterialRender,
JNormalOcclusion,
IMicroBlock {
    public MicroMaterialRegistry.IMicroMaterial mat = null;
    public int connectionMask = 0;
    int material;

    public PartConnecting() {
    }

    public PartConnecting(int material) {
        this.material = material;
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    @Override
    public void harvest(MovingObjectPosition hit, EntityPlayer player) {
        super.harvest(hit, player);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.material);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.material = packet.readInt();
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.material = MicroMaterialRegistry.materialID((String)tag.func_74779_i("mat"));
    }

    @Override
    public abstract String getType();

    public abstract Cuboid6 getBounds();

    @Override
    public abstract Iterable<Cuboid6> getCollisionBoxes();

    @Override
    public ItemStack getItemDrop() {
        ItemStack item = new ItemStack((Item)ItemMicroBlock.instance, 1, this.getMetadata());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
        item.func_77982_d(tag);
        return item;
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItemDrop());
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItemDrop();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    @Override
    public MicroMaterialRegistry.IMicroMaterial getMaterial() {
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        return this.mat;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int side) {
        if (this.mat != null) {
            return this.mat.getBreakingIcon(side);
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    @Override
    public Cuboid6 getRenderBounds() {
        return this.getBounds();
    }

    @Override
    public int getLightValue() {
        return MicroMaterialRegistry.getMaterial((int)this.material).getLightValue();
    }

    @Override
    public void onNeighborChanged() {
        this.reloadShape();
    }

    @Override
    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItemDrop(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    @Override
    public void onPartChanged(TMultiPart part) {
        this.reloadShape();
    }

    @Override
    public Iterable<IndexedCuboid6> getSubParts() {
        IndexedCuboid6 box = new IndexedCuboid6((Object)0, new Cuboid6(0.5, 0.5, 0.5, 0.5, 0.5, 0.5));
        this.overEthereal = true;
        for (Cuboid6 cuboid6 : this.getCollisionBoxes()) {
            box.enclose((Cuboid6)new IndexedCuboid6((Object)0, cuboid6));
        }
        this.overEthereal = false;
        box.max.y = 1.0;
        return Arrays.asList(box);
    }

    @Override
    public void onWorldJoin() {
        this.reloadShape();
        super.onWorldJoin();
    }

    public abstract boolean shouldConnect(int var1, int var2, int var3, int var4);

    @Override
    public abstract void reloadShape();

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract boolean renderStatic(Vector3 var1, int var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Vector3 pos, int pass) {
        this.renderStatic(pos, pass);
    }

    @Override
    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return this.getMaterial().getStrength(player);
    }
}

