/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import java.util.Random;

public class MathUtils {
    static final Random rand = new Random();

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static double getChanceOfXOverYRuns(double x, double y) {
        return 1.0 - Math.pow(1.0 - x, y);
    }

    public static long randLong(long min, long max) {
        return MathUtils.nextLong(rand, max - min + 1L) + min;
    }

    private static long nextLong(Random rng, long n) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static double randDouble(double min, double max) {
        return MathUtils.nextDouble(rand, max - min + 1.0) + min;
    }

    private static double nextDouble(Random rng, double n) {
        double val;
        double bits;
        while ((bits = (double)(rng.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0) < 0.0) {
        }
        return val;
    }

    public static float randFloat(float min, float max) {
        return MathUtils.nextFloat(rand, max - min + 1.0f) + min;
    }

    private static float nextFloat(Random rng, float n) {
        float val;
        float bits;
        while ((bits = (float)(rng.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0f) < 0.0f) {
        }
        return val;
    }

    public static double findPercentage(double current, double max) {
        return (double)Math.round(current / max * 100.0 * 100.0) / 100.0;
    }

    public static int findPercentageOfInt(long input, float percentage) {
        return (int)((float)input * (percentage / 100.0f));
    }

    public static double decimalRounding(double d) {
        return (double)Math.round(d * 2.0) / 2.0;
    }

    public static double decimalRoundingToWholes(double d) {
        return 5L * Math.round(d / 5.0);
    }

    public static int roundToClosestInt(double d) {
        return (int)((double)Math.round(d * 2.0) / 2.0);
    }

    public static int roundToClosestMultiple(double number, int multiple) {
        int result = multiple;
        if (number % (double)multiple == 0.0) {
            return (int)number;
        }
        if (number % (double)multiple != 0.0) {
            int division = (int)(number / (double)multiple + 1.0);
            result = division * multiple;
        }
        return result;
    }

    public static long roundToClosestLong(double d) {
        return (long)((double)Math.round(d * 2.0) / 2.0);
    }

    public static boolean divideXintoY(int x, int y) {
        return x % y == 0;
    }

    public static boolean isNumberEven(int x) {
        return x % 2 == 0;
    }

    public static float celsiusToKelvin(int i) {
        double f = (float)i + 273.15f;
        return (int)MathUtils.decimalRoundingToWholes(f);
    }

    public static int getHexNumberFromInt(int input) {
        String result = Integer.toHexString(input);
        int resultINT = Integer.getInteger(result);
        return resultINT;
    }

    public static int generateRandomHexValue(int min, int max) {
        return MathUtils.getHexNumberFromInt(MathUtils.randInt(min, max));
    }

    public static long[] simplifyNumbersToSmallestForm(long[] inputArray) {
        long GCD = MathUtils.gcd(inputArray);
        long[] outputArray = new long[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            outputArray[i] = GCD != 0L ? inputArray[i] / GCD : inputArray[i];
        }
        if (outputArray.length > 0) {
            return outputArray;
        }
        return new long[0];
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static long gcd(long[] input) {
        long result = input[0];
        for (int i = 1; i < input.length; ++i) {
            result = MathUtils.gcd(result, input[i]);
        }
        return result;
    }

    public static final int returnLargestNumber(int a, int b) {
        if (a > b) {
            return a;
        }
        if (a == b) {
            return a;
        }
        return b;
    }
}

