/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network;

import cofh.core.network.PacketBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, PacketBase> {
    public static final PacketHandler instance = new PacketHandler();
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private final LinkedList<Class<? extends PacketBase>> packets = new LinkedList();
    private boolean isPostInitialised = false;

    public boolean registerPacket(Class<? extends PacketBase> clazz) {
        if (this.packets.size() > 256) {
            return false;
        }
        if (this.packets.contains(clazz)) {
            return false;
        }
        if (this.isPostInitialised) {
            return false;
        }
        this.packets.add(clazz);
        return true;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, PacketBase packetBase, List<Object> list) throws Exception {
        ByteBuf byteBuf = Unpooled.buffer();
        Class<?> clazz = packetBase.getClass();
        if (!this.packets.contains(packetBase.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + packetBase.getClass().getCanonicalName());
        }
        byte by = (byte)this.packets.indexOf(clazz);
        byteBuf.writeByte((int)by);
        packetBase.encodeInto(channelHandlerContext, byteBuf);
        FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(byteBuf.copy(), (String)channelHandlerContext.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        list.add(fMLProxyPacket);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, FMLProxyPacket fMLProxyPacket, List<Object> list) throws Exception {
        ByteBuf byteBuf = fMLProxyPacket.payload();
        byte by = byteBuf.readByte();
        Class<? extends PacketBase> clazz = this.packets.get(by);
        if (clazz == null) {
            throw new NullPointerException("No packet registered for discriminator: " + by);
        }
        PacketBase packetBase = clazz.newInstance();
        packetBase.decodeInto(channelHandlerContext, byteBuf.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer entityPlayer = this.getClientPlayer();
                packetBase.handleClientSide(entityPlayer);
                break;
            }
            case SERVER: {
                INetHandler iNetHandler = (INetHandler)channelHandlerContext.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP entityPlayerMP = ((NetHandlerPlayServer)iNetHandler).field_147369_b;
                packetBase.handleServerSide((EntityPlayer)entityPlayerMP);
                break;
            }
        }
    }

    public void initialize() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("CoFH", new ChannelHandler[]{this});
    }

    public void postInit() {
        if (this.isPostInitialised) {
            return;
        }
        this.isPostInitialised = true;
        Collections.sort(this.packets, new Comparator<Class<? extends PacketBase>>(){

            @Override
            public int compare(Class<? extends PacketBase> clazz, Class<? extends PacketBase> clazz2) {
                int n = String.CASE_INSENSITIVE_ORDER.compare(clazz.getCanonicalName(), clazz2.getCanonicalName());
                if (n == 0) {
                    n = clazz.getCanonicalName().compareTo(clazz2.getCanonicalName());
                }
                return n;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void sendToAll(PacketBase packetBase) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendTo(PacketBase packetBase, EntityPlayerMP entityPlayerMP) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayerMP);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendTo(PacketBase packetBase, EntityPlayer entityPlayer) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayer);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendToAllAround(PacketBase packetBase, NetworkRegistry.TargetPoint targetPoint) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)targetPoint);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendToAllAround(PacketBase packetBase, TileEntity tileEntity) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(tileEntity.func_145831_w().field_73011_w.field_76574_g, (double)tileEntity.field_145851_c, (double)tileEntity.field_145848_d, (double)tileEntity.field_145849_e, 192.0));
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendToAllAround(PacketBase packetBase, World world, int n, int n2, int n3) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)n, (double)n2, (double)n3, 192.0));
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendToDimension(PacketBase packetBase, int n) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)n);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)packetBase);
    }

    public static void sendToServer(PacketBase packetBase) {
        PacketHandler.instance.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketHandler.instance.channels.get(Side.CLIENT).writeAndFlush((Object)packetBase);
    }

    public static Packet toMCPacket(PacketBase packetBase) {
        return PacketHandler.instance.channels.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packetBase);
    }
}

