/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import net.minecraft.item.ItemStack;

public class SpacePlantCrop
extends BasicCrop {
    public int tier() {
        return 13;
    }

    public String name() {
        return "Space Plant";
    }

    public int stat(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 8;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public String[] attributes() {
        return new String[]{"Alien", "Space", "Radiation", "Transform"};
    }

    public int maxSize() {
        return 4;
    }

    public int growthDuration(ICropTile crop) {
        return ConfigValues.debug ? 1 : 5000;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= this.maxSize();
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (crop.getSize() >= this.maxSize()) {
            return false;
        }
        if (ConfigValues.debug) {
            return true;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            if (ConfigValues.isGalacticCraftLoaded) {
                return crop.isBlockBelow(GCBlocks.blockMoon);
            }
            return true;
        }
        return true;
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(CppItems.Modifier, 1, 0);
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block from the moon below to fully mature.");
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(CppItems.Modifier, 1, 0);
    }
}

