/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.TC;

import com.github.bartimaeusnek.croploadcore.OreDict;
import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicThaumcraftCrop;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CinderpearlCrop
extends BasicThaumcraftCrop {
    public CinderpearlCrop() {
        OreDict.BSget((String)"cropCinderpearl", (CropCard)this);
    }

    public String name() {
        return "Cinderpearl";
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek and mitchej123";
    }

    public String[] attributes() {
        return new String[]{"Magic", "Blaze", "Nether"};
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (!super.canGrow(crop)) {
            return false;
        }
        if (ConfigValues.debug) {
            return true;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            return crop.isBlockBelow("blockBlaze") || !OreDictionary.doesOreNameExist((String)"blockBlaze");
        }
        return true;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return crop.getSize() <= 1 ? 2250 : 1750;
    }

    public ItemStack getGain(ICropTile crop) {
        return CCropUtility.getCopiedOreStack("crop" + this.name());
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block of Blaze below to fully mature.");
    }

    @Override
    public ItemStack getDisplayItem() {
        return OreDict.ISget((String)("crop" + this.name()));
    }
}

