/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.api;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.client.PacketReqData;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.SwingUI;

public enum TabPanelRegistrar implements ChangeListener
{
    INSTANCE;

    private HashMap<String, JTabbedPane> sections = new HashMap();
    private HashMap<SelectedTab, ITabPanel> lookup = new HashMap();

    public JTabbedPane registerSection(String name) {
        JTabbedPane pane = new JTabbedPane();
        pane.addChangeListener(this);
        this.sections.put(name, pane);
        SwingUI.instance().getTabbedPane().addTab(name, pane);
        return pane;
    }

    public ITabPanel registerTab(ITabPanel panel, String name) {
        this.lookup.put(panel.getSelectedTab(), panel);
        SwingUI.instance().getTabbedPane().addTab(name, (JPanel)((Object)panel));
        return panel;
    }

    public ITabPanel registerTab(ITabPanel panel, String name, String section) {
        this.lookup.put(panel.getSelectedTab(), panel);
        this.sections.get(section).addTab(name, (JPanel)((Object)panel));
        return panel;
    }

    public ITabPanel getTab(SelectedTab refname) {
        return this.lookup.get((Object)refname);
    }

    public JPanel getTabAsPanel(SelectedTab refname) {
        return (JPanel)((Object)this.lookup.get((Object)refname));
    }

    public void refreshAll() {
        for (ITabPanel panel : this.lookup.values()) {
            if (!panel.refreshOnString()) continue;
            panel.refresh();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component source = ((JTabbedPane)e.getSource()).getSelectedComponent();
        if (source instanceof ITabPanel) {
            ITabPanel panel = (ITabPanel)((Object)source);
            PacketManager.sendToServer(new PacketReqData(Message.SWING_TAB_CHANGED, new SerialInt(panel.getSelectedTab().ordinal())));
        }
    }
}

