/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.gtnewhorizons.gtnhintergalactic.recipe.SpacePumpingRecipes;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ParallelHelper;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public abstract class TileEntityModulePump
extends TileEntityModuleBase {
    public static final long ENERGY_CONSUMPTION = (int)GTValues.VP[9];
    Parameters.Group.ParameterIn[] parallelSettings;
    Parameters.Group.ParameterIn[] gasTypeSettings;
    Parameters.Group.ParameterIn[] planetTypeSettings;
    Parameters.Group.ParameterIn batchSetting;
    private static final INameFunction<TileEntityModulePump> PLANET_TYPE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.0") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntityModulePump> PLANET_TYPE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)100.0, (double)100.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModulePump> GAS_TYPE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.1") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntityModulePump> GAS_TYPE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)100.0, (double)100.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModulePump> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.2") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntityModulePump> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getParallels(), (double[])new double[0]);
    private static final INameFunction<TileEntityModulePump> BATCH_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.3");
    private static final IStatusFunction<TileEntityModulePump> BATCH_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)32.0, (double)128.0, (double[])new double[0]);
    protected boolean hasMeOutputHatch = false;
    protected static Textures.BlockIcons.CustomIcon engraving;

    public TileEntityModulePump(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier);
    }

    public TileEntityModulePump(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName, tTier, tModuleTier, tMinMotorTier);
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        if (ENERGY_CONSUMPTION * (long)this.getParallelRecipes() * (long)this.getParallels() > this.getEUVar()) {
            return CheckRecipeResultRegistry.insufficientPower((long)(ENERGY_CONSUMPTION * (long)this.getParallelRecipes() * (long)this.getParallels()));
        }
        ArrayList outputs = new ArrayList();
        int usedEUt = 0;
        int maxBatchSize = (int)Math.min(Math.max(this.batchSetting.get(), 1.0), 128.0);
        for (int i = 0; i < this.getParallelRecipes(); ++i) {
            FluidStack fluid = SpacePumpingRecipes.RECIPES.get(Pair.of((Object)((int)this.planetTypeSettings[i].get()), (Object)((int)this.gasTypeSettings[i].get())));
            if (fluid == null) continue;
            int batchSize = (int)Math.min(Math.max(this.batchSetting.get(), 1.0), 128.0);
            MTEHatchOutput targetOutput = null;
            if (!this.hasMeOutputHatch && !this.eSafeVoid) {
                for (MTEHatchOutput output : this.mOutputHatches) {
                    if (output.mFluid == null || output.mFluid.getFluid() == null || output.getLockedFluidName() == null || !output.getLockedFluidName().equals(fluid.getFluid().getName()) || !output.mFluid.getFluid().equals(fluid.getFluid())) continue;
                    targetOutput = output;
                    break;
                }
            }
            int parallels = Math.min((int)this.parallelSettings[i].get(), this.getParallels());
            if (targetOutput != null) {
                int outputSpace = targetOutput.getCapacity() - targetOutput.getFluidAmount();
                if (outputSpace < fluid.amount) continue;
                parallels = Math.min(parallels, outputSpace / fluid.amount);
                batchSize = Math.min(batchSize, outputSpace / (fluid.amount * parallels));
                maxBatchSize = Math.max(maxBatchSize, batchSize);
            }
            if (parallels <= 0 || batchSize <= 0) continue;
            fluid = fluid.copy();
            long fluidLong = (long)fluid.amount * (long)parallels * (long)batchSize;
            usedEUt += (int)(ENERGY_CONSUMPTION * (long)parallels);
            ParallelHelper.addFluidsLong(outputs, (FluidStack)fluid, (long)fluidLong);
        }
        this.lEUt = -usedEUt;
        this.mOutputFluids = outputs.toArray(new FluidStack[0]);
        this.eAmpereFlow = 1L;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20 * maxBatchSize;
        return !outputs.isEmpty() ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean state = super.checkMachine_EM(aBaseMetaTileEntity, aStack);
        this.hasMeOutputHatch = false;
        if (state) {
            for (MTEHatchOutput output : this.mOutputHatches) {
                if (!(output instanceof MTEHatchOutputME)) continue;
                this.hasMeOutputHatch = true;
                break;
            }
        }
        return state;
    }

    protected abstract int getParallels();

    protected abstract int getParallelRecipes();

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        int parallels = this.getParallelRecipes();
        this.planetTypeSettings = new Parameters.Group.ParameterIn[parallels];
        this.gasTypeSettings = new Parameters.Group.ParameterIn[parallels];
        this.parallelSettings = new Parameters.Group.ParameterIn[parallels];
        for (int i = 0; i < this.getParallelRecipes(); ++i) {
            this.planetTypeSettings[i] = this.parametrization.getGroup(i * 2, false).makeInParameter(0, 1.0, PLANET_TYPE_SETTING_NAME, PLANET_TYPE_STATUS);
            this.gasTypeSettings[i] = this.parametrization.getGroup(i * 2, false).makeInParameter(1, 1.0, GAS_TYPE_SETTING_NAME, GAS_TYPE_STATUS);
            this.parallelSettings[i] = this.parametrization.getGroup(i * 2 + 1, false).makeInParameter(0, (double)this.getParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
        }
        this.batchSetting = this.parametrization.getGroup(9, false).makeInParameter(1, 1.0, BATCH_SETTING_NAME, BATCH_STATUS);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.config")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
        int i = 0;
        while (i < this.getParallelRecipes()) {
            int fluidIndex = i++;
            ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> {
                String fluidName = this.getPumpedFluid(fluidIndex);
                if (fluidName != null) {
                    return " - " + fluidName;
                }
                return "";
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getPumpedFluid(fluidIndex) != null))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.planetTypeSettings[fluidIndex].get(), val -> this.parametrization.trySetParameters(this.planetTypeSettings[fluidIndex].id % 10, this.planetTypeSettings[fluidIndex].id / 10, this.planetTypeSettings[fluidIndex].get())))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.planetTypeSettings[fluidIndex].get(), val -> this.parametrization.trySetParameters(this.gasTypeSettings[fluidIndex].id % 10, this.gasTypeSettings[fluidIndex].id / 10, this.gasTypeSettings[fluidIndex].get())));
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TTRenderedExtendedFacingTexture((IIconContainer)(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF))};
        }
        if (facing.getRotation(ForgeDirection.UP) == side || facing.getRotation(ForgeDirection.DOWN) == side) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TTRenderedExtendedFacingTexture((IIconContainer)engraving)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096)};
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        engraving = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_SIDE_PUMP_MODULE");
        super.registerIcons(aBlockIconRegister);
    }

    private String getPumpedFluid(int index) {
        if (index < 0 || index >= this.getParallelRecipes()) {
            return null;
        }
        FluidStack fluid = SpacePumpingRecipes.RECIPES.get(Pair.of((Object)((int)this.planetTypeSettings[index].get()), (Object)((int)this.gasTypeSettings[index].get())));
        if (fluid == null) {
            return null;
        }
        return fluid.getLocalizedName();
    }

    public static class TileEntityModulePumpT3
    extends TileEntityModulePump {
        protected static final int MODULE_VOLTAGE_TIER = 13;
        protected static final int MODULE_TIER = 3;
        protected static final int MINIMUM_MOTOR_TIER = 4;
        protected static final int MAX_PARALLELS = 64;
        protected static final int MAX_PARALLEL_RECIPES = 4;

        public TileEntityModulePumpT3(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 13, 3, 4);
        }

        public TileEntityModulePumpT3(String aName) {
            super(aName, 13, 3, 4);
        }

        @Override
        protected int getParallels() {
            return 64;
        }

        @Override
        protected int getParallelRecipes() {
            return 4;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModulePumpT3(this.mName);
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t3.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t3.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t2.desc6")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT4")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }

    public static class TileEntityModulePumpT2
    extends TileEntityModulePump {
        protected static final int MODULE_VOLTAGE_TIER = 10;
        protected static final int MODULE_TIER = 2;
        protected static final int MINIMUM_MOTOR_TIER = 3;
        protected static final int MAX_PARALLELS = 4;
        protected static final int MAX_PARALLEL_RECIPES = 4;

        public TileEntityModulePumpT2(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 10, 2, 3);
        }

        public TileEntityModulePumpT2(String aName) {
            super(aName, 10, 2, 3);
        }

        @Override
        protected int getParallels() {
            return 4;
        }

        @Override
        protected int getParallelRecipes() {
            return 4;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModulePumpT2(this.mName);
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t2.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t2.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t2.desc6")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT3")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }

    public static class TileEntityModulePumpT1
    extends TileEntityModulePump {
        protected static final int MODULE_VOLTAGE_TIER = 9;
        protected static final int MODULE_TIER = 1;
        protected static final int MINIMUM_MOTOR_TIER = 2;
        protected static final int MAX_PARALLELS = 4;
        protected static final int MAX_PARALLEL_RECIPES = 1;

        public TileEntityModulePumpT1(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 9, 1, 2);
        }

        public TileEntityModulePumpT1(String aName) {
            super(aName, 9, 1, 2);
        }

        @Override
        protected int getParallels() {
            return 4;
        }

        @Override
        protected int getParallelRecipes() {
            return 1;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModulePumpT1(this.mName);
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t1.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t1.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT2")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }
}

