/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.botany.Botany;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.api.IDesignMaterial;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class GlassType
implements IDesignMaterial {
    protected static Map<Integer, GlassType> types = new LinkedHashMap<Integer, GlassType>();
    protected String name;
    protected int color;
    protected int id;

    private GlassType(int id, String name, int color) {
        this.id = id;
        this.name = name;
        this.color = color;
    }

    public static int getIndex(IDesignMaterial id) {
        for (Map.Entry<Integer, GlassType> entry : types.entrySet()) {
            if (entry.getValue() != id) continue;
            return entry.getKey();
        }
        return 0;
    }

    public static IDesignMaterial get(int id) {
        return types.get(id);
    }

    public static IDesignMaterial get(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry<Integer, GlassType> entry : types.entrySet()) {
            if (!stack.func_77969_a(entry.getValue().getStack())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        if (this.id < 128) {
            return new ItemStack((Block)Blocks.field_150399_cn, 1, this.id);
        }
        return TileEntityMetadata.getItemStack(Botany.stained, this.id - 128);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    static {
        for (StandardColor standardColor : StandardColor.values()) {
            types.put(standardColor.ordinal(), new GlassType(standardColor.ordinal(), standardColor.name, standardColor.color));
        }
        for (Enum enum_ : EnumFlowerColor.values()) {
            types.put(128 + enum_.ordinal(), new GlassType(128 + enum_.ordinal(), ((EnumFlowerColor)enum_).getName(), ((EnumFlowerColor)enum_).getColor(false)));
        }
    }

    private static enum StandardColor {
        White("White", new Color(0xFFFFFF)),
        Orange("Orange", new Color(14188339)),
        Magenta("Magenta", new Color(11685080)),
        LightBlue("Light Blue", new Color(6724056)),
        Yellow("Yellow", new Color(0xE5E533)),
        Lime("Lime", new Color(8375321)),
        Pink("Pink", new Color(15892389)),
        Gray("Gray", new Color(0x4C4C4C)),
        LightGray("Light Gray", new Color(0x999999)),
        Cyan("Cyan", new Color(5013401)),
        Purple("Purple", new Color(8339378)),
        Blue("Blue", new Color(3361970)),
        Brown("Brown", new Color(6704179)),
        Green("Green", new Color(6717235)),
        Red("Red", new Color(0x993333)),
        Black("Black", new Color(0x191919));

        private final String name;
        private final int color;

        private StandardColor(String name, Color color) {
            this.name = name;
            this.color = color.getRGB();
        }
    }
}

