/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageCoordinates;
import binnie.core.network.packet.PacketPayload;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MessageUpdate
extends MessageCoordinates {
    public PacketPayload payload;

    public MessageUpdate(MessageBinnie message) {
        super(message);
    }

    public MessageUpdate(int id, INetworkedEntity tile) {
        super(id, ((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e);
        this.payload = new PacketPayload();
        tile.writeToPacket(this.payload);
    }

    @Override
    public void writeData(ByteBuf data) throws IOException {
        super.writeData(data);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.intPayload.size());
        data.writeInt(this.payload.floatPayload.size());
        data.writeInt(this.payload.stringPayload.size());
        Iterator<Object> iterator = this.payload.intPayload.iterator();
        while (iterator.hasNext()) {
            int intData = iterator.next();
            data.writeInt(intData);
        }
        iterator = this.payload.floatPayload.iterator();
        while (iterator.hasNext()) {
            float floatData = ((Float)iterator.next()).floatValue();
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.stringPayload) {
            byte[] bytes = stringData.getBytes(StandardCharsets.UTF_8);
            data.writeShort(bytes.length);
            data.writeBytes(bytes);
        }
    }

    @Override
    public void readData(ByteBuf data) throws IOException {
        int i;
        super.readData(data);
        this.payload = new PacketPayload();
        this.payload.intPayload.clear();
        this.payload.floatPayload.clear();
        this.payload.stringPayload.clear();
        int intLength = data.readInt();
        int floatLength = data.readInt();
        int stringLength = data.readInt();
        for (i = 0; i < intLength; ++i) {
            this.payload.addInteger(data.readInt());
        }
        for (i = 0; i < floatLength; ++i) {
            this.payload.addFloat(data.readFloat());
        }
        for (i = 0; i < stringLength; ++i) {
            short length = data.readShort();
            byte[] string = data.readBytes((int)length).array();
            this.payload.addString(new String(string, StandardCharsets.UTF_8));
        }
    }

    public TileEntity getTarget(World world) {
        return world.func_147438_o(this.posX, this.posY, this.posZ);
    }
}

