/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.MinecraftTooltip;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public class ControlEnergyBar
extends Control
implements ITooltip {
    public static boolean isError;
    private final Position direction;

    public ControlEnergyBar(IWidget parent, int x, int y, int width, int height, Position direction) {
        super(parent, x, y, width, height);
        this.direction = direction;
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
    }

    public IPoweredMachine getClientPower() {
        TileEntityMachine machine;
        IInventory inventory = ((Window)Window.get(this)).getInventory();
        TileEntityMachine tileEntityMachine = machine = inventory instanceof TileEntityMachine ? (TileEntityMachine)inventory : null;
        if (machine == null) {
            return null;
        }
        return machine.getMachine().getInterface(IPoweredMachine.class);
    }

    public float getPercentage() {
        float percentage = 100.0f * this.getStoredEnergy() / this.getMaxEnergy();
        if (percentage > 100.0f) {
            percentage = 100.0f;
        }
        return percentage;
    }

    private float getStoredEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getStoredEnergy();
    }

    private float getMaxEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getMaxEnergy();
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        tooltip.add(I18N.localise("binniecore.gui.tooltip.chargedPower", (int)this.getPercentage()));
        tooltip.add(I18N.localise("binniecore.gui.tooltip.powerInfo", Float.valueOf(this.getStoredEnergy()), Float.valueOf(this.getMaxEnergy())));
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        tooltip.add(I18N.localise("binniecore.gui.tooltip.powerBar"));
        tooltip.add(I18N.localise("binniecore.gui.tooltip.currentPower", Float.valueOf(this.getStoredEnergy()), (int)this.getPercentage()));
        tooltip.add(I18N.localise("binniecore.gui.tooltip.capacityPower", Float.valueOf(this.getMaxEnergy())));
        IProcess process = Machine.getInterface(IProcess.class, ((Window)Window.get(this)).getInventory());
        if (process != null) {
            tooltip.add(I18N.localise("binniecore.gui.tooltip.usagePower", (int)process.getEnergyPerTick()));
        }
    }

    @Override
    public void onRenderBackground() {
        CraftGUI.render.texture((Object)CraftGUITexture.EnergyBarBack, this.getArea());
        float percentage = this.getPercentage() / 100.0f;
        CraftGUI.render.color(this.getColourFromPercentage(percentage));
        IArea area = this.getArea();
        switch (this.direction) {
            case TOP: 
            case BOTTOM: {
                float height = area.size().y() * percentage;
                area.setSize(new IPoint(area.size().x(), height));
                break;
            }
            case LEFT: 
            case RIGHT: {
                float width = area.size().x() * percentage;
                area.setSize(new IPoint(width, area.size().y()));
            }
        }
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            int c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.HELP);
            CraftGUI.render.gradientRect(this.getArea().inset(1), c, c);
        } else if (isError) {
            int c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR);
            CraftGUI.render.gradientRect(this.getArea().inset(1), c, c);
        }
        CraftGUI.render.texture((Object)CraftGUITexture.EnergyBarGlow, area);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        CraftGUI.render.texture((Object)CraftGUITexture.EnergyBarGlass, this.getArea());
    }

    @Override
    public void onRenderForeground() {
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            IArea area = this.getArea();
            CraftGUI.render.color(MinecraftTooltip.getOutline(Tooltip.Type.HELP));
            CraftGUI.render.texture((Object)CraftGUITexture.Outline, area.outset(1));
        } else if (isError) {
            IArea area = this.getArea();
            CraftGUI.render.color(MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR));
            CraftGUI.render.texture((Object)CraftGUITexture.Outline, area.outset(1));
        }
    }

    public int getColourFromPercentage(float percentage) {
        int color;
        if ((double)percentage > 0.5) {
            int r = (int)((1.0 - 2.0 * ((double)percentage - 0.5)) * 255.0);
            color = (r << 16) + 65280;
        } else {
            int g = (int)(255.0f * (2.0f * percentage));
            color = 0xFF0000 + (g << 8);
        }
        return color;
    }
}

