/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import de.katzenpapst.amunra.item.ItemShuttle;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.world.ShuttleDockHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityShuttleDock
extends TileEntityAdvanced
implements IFuelable,
IFuelDock,
ICargoEntity,
IMultiBlock,
IInventory,
IPacketReceiver {
    protected boolean hasShuttleDocked;
    protected int actionCooldown;
    protected ItemStack[] containingItems = new ItemStack[1];
    protected IDockable dockedEntity;

    protected void dropItemsAtExit(List<ItemStack> cargo) {
        Vector3 pos = this.getExitPosition();
        for (ItemStack item : cargo) {
            EntityItem itemEntity = new EntityItem(this.field_145850_b, pos.x, pos.y, pos.z, item);
            this.field_145850_b.func_72838_d((Entity)itemEntity);
        }
    }

    public void performDockOperation(int op, EntityPlayerMP player) {
        if (op >= DockOperation.values().length) {
            return;
        }
        this.performDockOperation(DockOperation.values()[op], player);
    }

    public void performDockOperation(DockOperation op, EntityPlayerMP player) {
        if (this.actionCooldown > 0) {
            return;
        }
        this.actionCooldown = 20;
        switch (op) {
            case DEPLOY_SHUTTLE: {
                if (this.dockedEntity != null) {
                    return;
                }
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || stack.field_77994_a == 0 || !(stack.func_77973_b() instanceof ItemShuttle) || this.isObstructed()) {
                    return;
                }
                ItemShuttle shuttleItem = (ItemShuttle)stack.func_77973_b();
                Vector3 pos = this.getShuttlePosition();
                EntityShuttle shuttleEntity = shuttleItem.spawnRocketEntity(stack, this.field_145850_b, pos.x, pos.y, pos.z);
                this.dockEntity((IDockable)shuttleEntity);
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    stack = null;
                }
                this.func_70299_a(0, stack);
                this.hasShuttleDocked = true;
                break;
            }
            case GET_SHUTTLE: {
                if (this.dockedEntity == null) {
                    return;
                }
                ItemStack stack = this.func_70301_a(0);
                if (stack != null) {
                    return;
                }
                EntityShuttle shuttleEntity = (EntityShuttle)this.dockedEntity;
                stack = shuttleEntity.getItemRepresentation();
                List<ItemStack> cargo = shuttleEntity.getCargoContents();
                this.dropItemsAtExit(cargo);
                this.func_70299_a(0, stack);
                shuttleEntity.func_70106_y();
                this.dockedEntity = null;
                this.hasShuttleDocked = false;
                break;
            }
            case MOUNT_SHUTTLE: {
                if (this.dockedEntity == null) {
                    return;
                }
                EntityShuttle shuttleEntity = (EntityShuttle)this.dockedEntity;
                if (shuttleEntity.field_70153_n != null) {
                    return;
                }
                player.func_70078_a((Entity)shuttleEntity);
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_CLOSE_GUI, new Object[0]), player);
                break;
            }
            default: {
                return;
            }
        }
        this.updateAvailabilityInWorldData();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void performDockOperationClient(DockOperation op) {
        int opInt = op.ordinal();
        Object[] payload = new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, opInt};
        AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_DOCK_OPERATION, payload));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.containingItems = this.readStandardItemsFromNBT(compound);
        this.hasShuttleDocked = compound.func_74767_n("hasShuttle");
        this.actionCooldown = compound.func_74762_e("actionCooldown");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeStandardItemsToNBT(compound);
        compound.func_74757_a("hasShuttle", this.hasShuttleDocked);
        compound.func_74768_a("actionCooldown", this.actionCooldown);
    }

    public ItemStack[] readStandardItemsFromNBT(NBTTagCompound nbt) {
        NBTTagList itemTag = nbt.func_150295_c("Items", 10);
        int length = this.containingItems.length;
        ItemStack[] result = new ItemStack[length];
        for (int i = 0; i < itemTag.func_74745_c(); ++i) {
            NBTTagCompound stackNbt = itemTag.func_150305_b(i);
            int slotNr = stackNbt.func_74771_c("Slot") & 0xFF;
            if (slotNr >= length) continue;
            result[slotNr] = ItemStack.func_77949_a((NBTTagCompound)stackNbt);
        }
        return result;
    }

    public boolean hasShuttle() {
        return this.hasShuttleDocked;
    }

    public void writeStandardItemsToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        int length = this.containingItems.length;
        for (int i = 0; i < length; ++i) {
            if (this.containingItems[i] == null) continue;
            NBTTagCompound stackNbt = new NBTTagCompound();
            stackNbt.func_74774_a("Slot", (byte)i);
            this.containingItems[i].func_77955_b(stackNbt);
            list.func_74742_a((NBTBase)stackNbt);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Vector3 getShuttlePosition() {
        switch (this.getRotationMeta()) {
            case 0: {
                return new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e - 1.5);
            }
            case 2: {
                return new Vector3((double)this.field_145851_c - 1.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
            }
            case 1: {
                return new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 2.5);
            }
            case 3: {
                return new Vector3((double)this.field_145851_c + 2.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
            }
        }
        return null;
    }

    public float getExitRotation() {
        switch (this.getRotationMeta()) {
            case 0: {
                return 0.0f;
            }
            case 2: {
                return 270.0f;
            }
            case 1: {
                return 180.0f;
            }
            case 3: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public Vector3 getExitPosition() {
        switch (this.getRotationMeta()) {
            case 0: {
                return new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 1.5);
            }
            case 2: {
                return new Vector3((double)this.field_145851_c + 1.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
            }
            case 1: {
                return new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e - 0.5);
            }
            case 3: {
                return new Vector3((double)this.field_145851_c - 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
            }
        }
        return null;
    }

    protected void repositionEntity() {
        Vector3 pos = this.getShuttlePosition();
        ((Entity)this.dockedEntity).func_70107_b(pos.x, pos.y, pos.z);
    }

    protected void dockNearbyShuttle() {
        Vector3 expectedPosition = this.getShuttlePosition();
        List list = this.field_145850_b.func_72872_a(EntityShuttle.class, AxisAlignedBB.func_72330_a((double)(expectedPosition.x - 0.5), (double)(expectedPosition.y - 0.5), (double)(expectedPosition.z - 0.5), (double)(expectedPosition.x + 0.5), (double)(expectedPosition.y + 0.5), (double)(expectedPosition.z + 0.5)));
        for (EntityShuttle fuelable : list) {
            if (fuelable.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal()) continue;
            this.dockEntity((IDockable)fuelable);
            break;
        }
        if (!list.isEmpty()) {
            this.updateAvailabilityInWorldData();
        }
    }

    public void onChunkUnload() {
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.actionCooldown > 0) {
                --this.actionCooldown;
            }
            if (this.dockedEntity != null) {
                EntityShuttle shuttle = (EntityShuttle)this.dockedEntity;
                if (shuttle.field_70128_L) {
                    this.dockedEntity = null;
                } else if (shuttle.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                    shuttle.setPad(null);
                    this.dockedEntity = null;
                    this.updateAvailabilityInWorldData();
                } else if (this.ticks % 40 == 0) {
                    this.repositionEntity();
                }
            }
            if (this.dockedEntity == null) {
                this.dockNearbyShuttle();
            }
            if (this.dockedEntity == null && this.hasShuttleDocked) {
                this.hasShuttleDocked = false;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (this.dockedEntity != null && !this.hasShuttleDocked) {
                this.hasShuttleDocked = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.ticks % 35 == 0) {
                this.updateAvailabilityInWorldData();
            }
        }
    }

    protected void updateAvailabilityInWorldData() {
        boolean curAvailability = this.isAvailable();
        boolean wasAvailableLastCheck = ShuttleDockHandler.getStoredAvailability(this);
        if (wasAvailableLastCheck != curAvailability) {
            ShuttleDockHandler.setStoredAvailability(this, curAvailability);
        }
    }

    public int getRotationMeta(int meta) {
        return (meta & 0xC) >> 2;
    }

    public int getRotationMeta() {
        return (this.func_145832_p() & 0xC) >> 2;
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addCargo(stack, doAdd);
        }
        return ICargoEntity.EnumCargoLoadingState.NOTARGET;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeCargo(doRemove);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.NOTARGET, null);
    }

    protected void checkTileAt(Set<ILandingPadAttachable> connectedTiles, int x, int y, int z) {
        ILandingPadAttachable landingPad;
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof ILandingPadAttachable && (landingPad = (ILandingPadAttachable)tile).canAttachToLandingPad((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            connectedTiles.add(landingPad);
        }
    }

    public HashSet<ILandingPadAttachable> getConnectedTiles() {
        HashSet<ILandingPadAttachable> connectedTiles = new HashSet<ILandingPadAttachable>();
        this.checkTileAt(connectedTiles, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        this.checkTileAt(connectedTiles, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        switch (this.getRotationMeta()) {
            case 0: 
            case 2: {
                this.checkTileAt(connectedTiles, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                this.checkTileAt(connectedTiles, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                this.checkTileAt(connectedTiles, this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e);
                this.checkTileAt(connectedTiles, this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e);
                break;
            }
            case 1: 
            case 3: {
                this.checkTileAt(connectedTiles, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                this.checkTileAt(connectedTiles, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                this.checkTileAt(connectedTiles, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1);
                this.checkTileAt(connectedTiles, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1);
            }
        }
        return connectedTiles;
    }

    public boolean isBlockAttachable(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ILandingPadAttachable) {
            ILandingPadAttachable landingPad = (ILandingPadAttachable)tile;
            return landingPad.canAttachToLandingPad(world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return false;
    }

    public IDockable getDockedEntity() {
        return this.dockedEntity;
    }

    public void dockEntity(IDockable entity) {
        if (entity == this.dockedEntity) {
            return;
        }
        if (entity instanceof EntityShuttle) {
            EntityShuttle shuttle = (EntityShuttle)entity;
            this.dockedEntity = entity;
            shuttle.setPad(this);
            this.repositionEntity();
        } else if (entity == null) {
            this.dockedEntity = null;
        }
        this.updateAvailabilityInWorldData();
    }

    public int addFuel(FluidStack fluid, boolean doFill) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addFuel(fluid, doFill);
        }
        return 0;
    }

    public FluidStack removeFuel(int amount) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeFuel(amount);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        switch (this.getRotationMeta()) {
            case 0: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
            }
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }

    public double getPacketRange() {
        return 30.0;
    }

    public int getPacketCooldown() {
        return 50;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)AmunRa.instance, 7, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void onCreate(BlockVec3 placedPosition) {
        ShuttleDockHandler.addDock(this);
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        if (placedPosition.y + 1 > buildHeight) {
            return;
        }
        BlockVec3 vecStrut = new BlockVec3(placedPosition.x, placedPosition.y + 1, placedPosition.z);
        ARBlocks.metaBlockFake.makeFakeBlock(this.field_145850_b, vecStrut, new BlockVec3(this.field_145851_c, this.field_145848_d, this.field_145849_e), ARBlocks.fakeBlockSealable);
    }

    public void onDestroy(TileEntity callingBlock) {
        ShuttleDockHandler.removeDock(this);
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (b == ARBlocks.metaBlockFake) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
        if (callingBlock != this) {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.shuttleDock.name");
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack resultStack;
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            resultStack = this.containingItems[index];
            this.containingItems[index] = null;
        } else {
            resultStack = this.containingItems[index].func_77979_a(count);
            if (this.containingItems[index].field_77994_a == 0) {
                this.containingItems[index] = null;
            }
        }
        return resultStack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack result = this.containingItems[index];
            this.containingItems[index] = null;
            return result;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof ItemShuttle;
    }

    protected boolean areBlocksWithin(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.field_145850_b.func_147437_c(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isObstructed() {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        int minY = this.field_145848_d - 2;
        int maxY = this.field_145848_d + 3;
        switch (this.getRotationMeta()) {
            case 0: {
                minX = this.field_145851_c - 1;
                maxX = this.field_145851_c + 1;
                minZ = this.field_145849_e - 3;
                maxZ = this.field_145849_e - 1;
                break;
            }
            case 2: {
                minX = this.field_145851_c - 3;
                maxX = this.field_145851_c - 1;
                minZ = this.field_145849_e - 1;
                maxZ = this.field_145849_e + 1;
                break;
            }
            case 1: {
                minX = this.field_145851_c - 1;
                maxX = this.field_145851_c + 1;
                minZ = this.field_145849_e + 1;
                maxZ = this.field_145849_e + 3;
                break;
            }
            case 3: {
                minX = this.field_145851_c + 1;
                maxX = this.field_145851_c + 3;
                minZ = this.field_145849_e - 1;
                maxZ = this.field_145849_e + 1;
                break;
            }
            default: {
                return false;
            }
        }
        return this.areBlocksWithin(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean isAvailable() {
        if (this.dockedEntity != null || this.hasShuttleDocked) {
            return false;
        }
        return !this.isObstructed();
    }

    public static enum DockOperation {
        DEPLOY_SHUTTLE,
        GET_SHUTTLE,
        MOUNT_SHUTTLE;

    }
}

