/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.gui.misc.GuiPlayerInfoWrapper;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.Ranks;

public class MessageUpdateTabName
extends MessageToClient {
    private String name;
    private IChatComponent displayComponent;
    private boolean afk;

    public MessageUpdateTabName() {
    }

    public MessageUpdateTabName(ForgePlayer player) {
        EntityPlayerMP playerMP = player.getPlayer();
        this.name = playerMP.func_70005_c_();
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(player);
        this.afk = data.afkTime >= ServerUtilitiesConfig.afk.getNotificationTimer();
        this.displayComponent = Ranks.isActive() ? data.getNameForChat(playerMP) : new ChatComponentText(playerMP.getDisplayName());
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeString(this.name);
        data.writeTextComponent(this.displayComponent);
        data.writeBoolean(this.afk);
    }

    @Override
    public void readData(DataIn data) {
        this.name = data.readString();
        this.displayComponent = data.readTextComponent();
        this.afk = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B()) {
            return;
        }
        NetHandlerPlayClient handler = mc.func_147114_u();
        Map infoMap = handler.field_147310_i;
        List infoList = handler.field_147303_b;
        GuiPlayerInfo info = (GuiPlayerInfo)infoMap.get(this.name);
        if (info == null) {
            return;
        }
        String displayName = this.displayComponent.func_150254_d().replaceAll("[<>]", "");
        if (this.afk) {
            displayName = EnumChatFormatting.GRAY + "[AFK] " + EnumChatFormatting.RESET + displayName;
        }
        if (info instanceof GuiPlayerInfoWrapper) {
            GuiPlayerInfoWrapper wrapper = (GuiPlayerInfoWrapper)info;
            wrapper.displayName = displayName;
        } else {
            infoMap.remove(this.name);
            infoList.remove(info);
            GuiPlayerInfoWrapper newInfo = new GuiPlayerInfoWrapper(info, displayName);
            infoMap.put(this.name, newInfo);
            infoList.add(newInfo);
        }
    }
}

