/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.util.compression.ICompress;

public class LegacyCompressor
implements ICompress {
    private ZipOutputStream output;

    @Override
    public void createOutputStream(File file) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));
        if (ServerUtilitiesConfig.backups.compression_level == 0) {
            zos.setMethod(0);
        } else {
            zos.setLevel(ServerUtilitiesConfig.backups.compression_level);
        }
        this.output = zos;
    }

    @Override
    public void addFileToArchive(File file, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        this.output.putNextEntry(entry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)this.output);
        }
        this.output.closeEntry();
    }

    @Override
    public void close() throws Exception {
        if (this.output != null) {
            this.output.close();
        }
    }
}

