/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.SimpleGuiConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.util.StatCollector;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.GuiSidebarButtonConfig;
import serverutils.client.gui.SidebarButtonManager;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.gui.misc.GuiLoading;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ItemIcon;
import serverutils.lib.util.SidedUtils;
import serverutils.lib.util.misc.MouseButton;
import serverutils.net.MessageCommandsRequest;

public class GuiClientConfig
extends GuiButtonListBase {
    public GuiClientConfig() {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button.serverutilities.settings", (Object[])new Object[0]));
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"player_config", (Object[])new Object[0]), GuiIcons.SETTINGS_RED){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiLoading().openGui();
                ClientUtils.execClientCommand("/my_settings");
            }

            @Override
            public WidgetType getWidgetType() {
                return SidedUtils.isModLoadedOnServer("serverutilities") ? super.getWidgetType() : WidgetType.DISABLED;
            }
        });
        panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"sidebar_button", (Object[])new Object[0]), Icon.getIcon("serverutilities:textures/gui/teams.png")){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiSidebarButtonConfig().openGui();
            }
        });
        panel.add(new SimpleTextButton(panel, StatCollector.func_74838_a((String)"serverutilities_client"), Icon.getIcon("serverutilities:textures/logo_small.png")){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                try {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomConfig(this.getTitle()));
                }
                catch (ConfigException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        panel.add(new SimpleTextButton(panel, StatCollector.func_74838_a((String)"serverutilities.command_overview"), ItemIcon.getItemIcon(Items.field_151111_aL)){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiLoading().openGui();
                new MessageCommandsRequest().sendToServer();
            }

            @Override
            public WidgetType getWidgetType() {
                return SidedUtils.isModLoadedOnServer("serverutilities") ? super.getWidgetType() : WidgetType.DISABLED;
            }
        });
    }

    @Override
    public void onClosed() {
        super.onClosed();
        SidebarButtonManager.INSTANCE.saveConfig();
    }

    private static class GuiCustomConfig
    extends SimpleGuiConfig {
        public GuiCustomConfig(String title) throws ConfigException {
            super(Minecraft.func_71410_x().field_71462_r, "serverutilities", title, new Class[]{ServerUtilitiesClientConfig.class});
        }
    }
}

