/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.client.render.ShapeRenderDispatch;
import gcewing.architecture.client.render.target.RenderTargetWorld;
import gcewing.architecture.common.block.BlockShape;
import gcewing.architecture.common.item.ArchitectureItemBlock;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.IOrientationHandler;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vec3i;
import gcewing.architecture.compat.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import org.lwjgl.opengl.GL11;

public class PreviewRenderer {
    public TileShape shapeTile = new TileShape();
    static final Vector3 hitVec = new Vector3(0.0, 0.0, 0.0);

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent e) {
        if (!e.isCanceled()) {
            EntityPlayer player = e.player;
            World world = player.func_130014_f_();
            ItemStack stack = player.func_70694_bm();
            if (stack == null || !(stack.func_77973_b() instanceof ArchitectureItemBlock)) {
                return;
            }
            MovingObjectPosition target = e.target;
            BlockPos pos = new BlockPos(target.field_72311_b, target.field_72312_c, target.field_72309_d);
            EnumFacing sideHitEnum = EnumFacing.field_82609_l[target.field_72310_e];
            BlockPos offset = pos.offset(sideHitEnum);
            if (target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !world.func_147437_c(offset.x, offset.y, offset.z)) {
                return;
            }
            float hitX = (float)target.field_72307_f.field_72450_a;
            float hitY = (float)target.field_72307_f.field_72448_b;
            float hitZ = (float)target.field_72307_f.field_72449_c;
            Tessellator tess = Tessellator.field_78398_a;
            RenderTargetWorld renderTarget = new RenderTargetWorld((IBlockAccess)world, offset, tess, null);
            ShapeRenderDispatch shapeDispatcher = ArchitectureCraftClient.shapeRenderDispatch;
            BlockShape blockShape = ArchitectureCraft.content.blockShape;
            IOrientationHandler oh = blockShape.getOrientationHandler();
            IBlockState state = oh.onBlockPlaced((Block)blockShape, world, offset, sideHitEnum, hitX, hitY, hitZ, blockShape.getDefaultState(), (EntityLivingBase)player);
            this.shapeTile.field_145851_c = offset.x;
            this.shapeTile.field_145848_d = offset.y;
            this.shapeTile.field_145849_e = offset.z;
            this.shapeTile.func_145834_a(world);
            this.shapeTile.baseBlockState = null;
            this.shapeTile.readFromItemStack(stack);
            this.simulatePlacement(player, (IBlockAccess)world, this.shapeTile, target);
            Trans3 translation = Trans3.blockCenter(offset).t(this.shapeTile.localToGlobalTransformation(Vector3.zero, state));
            double tX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)e.partialTicks;
            double tY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)e.partialTicks;
            double tZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)e.partialTicks;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-tX), (double)(-tY), (double)(-tZ));
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
            tess.func_78382_b();
            shapeDispatcher.renderShapeTE(this.shapeTile, renderTarget, translation, true, false);
            tess.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    private void simulatePlacement(EntityPlayer player, IBlockAccess world, TileShape te, MovingObjectPosition hitPos) {
        EnumFacing face = EnumFacing.field_82609_l[hitPos.field_72310_e];
        Vec3i d = Vector3.getDirectionVec(face);
        hitVec.set(hitPos.field_72307_f.field_72450_a - (double)hitPos.field_72311_b - (double)d.getX() - 0.5, hitPos.field_72307_f.field_72448_b - (double)hitPos.field_72312_c - (double)d.getY() - 0.5, hitPos.field_72307_f.field_72449_c - (double)hitPos.field_72309_d - (double)d.getZ() - 0.5);
        BlockPos npos = new BlockPos(hitPos.field_72311_b, hitPos.field_72312_c, hitPos.field_72309_d).offset(face);
        IBlockState nstate = BlockCompatUtils.getWorldBlockState(world, npos);
        TileEntity nte = world.func_147438_o(npos.x, npos.y, npos.z);
        te.shape.orientOnPlacement(player, te, npos, nstate, nte, face, hitVec);
    }
}

