/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public enum JsonNBT {
    END,
    BYTE,
    SHORT,
    INT,
    LONG,
    FLOAT,
    DOUBLE,
    BYTEARRAY,
    STRING,
    LIST,
    COMPOUND,
    INTARRAY;


    public static NBTTagCompound jsonToCompound(JsonObject data) {
        NBTTagCompound toReturn = new NBTTagCompound();
        for (Map.Entry entry : data.entrySet()) {
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            JsonNBT type = JsonNBT.getType(obj.get("type").getAsString());
            JsonNBT.setCompoundEntry(toReturn, (String)entry.getKey(), type, obj.get("value"));
        }
        return toReturn;
    }

    public static NBTTagList jsonToList(JsonObject data) {
        NBTTagList toReturn = new NBTTagList();
        JsonNBT type = JsonNBT.valueOf(data.get("type").getAsString());
        for (JsonElement e : data.get("value").getAsJsonArray()) {
            JsonNBT.append(toReturn, type, e);
        }
        return toReturn;
    }

    public static JsonNBT getType(String type) {
        return JsonNBT.valueOf(type);
    }

    public static void setCompoundEntry(NBTTagCompound nbt, String name, JsonNBT type, JsonElement data) {
        switch (type) {
            case END: {
                return;
            }
            case BYTE: {
                nbt.func_74774_a(name, data.getAsByte());
                return;
            }
            case SHORT: {
                nbt.func_74777_a(name, data.getAsShort());
                return;
            }
            case INT: {
                nbt.func_74768_a(name, data.getAsInt());
                return;
            }
            case LONG: {
                nbt.func_74772_a(name, data.getAsLong());
                return;
            }
            case FLOAT: {
                nbt.func_74776_a(name, data.getAsFloat());
                return;
            }
            case DOUBLE: {
                nbt.func_74780_a(name, data.getAsDouble());
                return;
            }
            case BYTEARRAY: {
                nbt.func_74773_a(name, JsonNBT.jsonToByteArray(data.getAsJsonObject()));
                return;
            }
            case STRING: {
                nbt.func_74778_a(name, data.getAsString());
                return;
            }
            case LIST: {
                nbt.func_74782_a(name, (NBTBase)JsonNBT.jsonToList(data.getAsJsonObject()));
                return;
            }
            case COMPOUND: {
                nbt.func_74782_a(name, (NBTBase)JsonNBT.jsonToCompound(data.getAsJsonObject()));
                return;
            }
            case INTARRAY: {
                nbt.func_74782_a(name, (NBTBase)new NBTTagIntArray(JsonNBT.jsonToIntArray(data.getAsJsonObject())));
                return;
            }
        }
    }

    public static void append(NBTTagList nbt, JsonNBT type, JsonElement data) {
        switch (type) {
            case END: {
                return;
            }
            case BYTE: {
                nbt.func_74742_a((NBTBase)new NBTTagByte(data.getAsByte()));
                return;
            }
            case SHORT: {
                nbt.func_74742_a((NBTBase)new NBTTagShort(data.getAsShort()));
                return;
            }
            case INT: {
                nbt.func_74742_a((NBTBase)new NBTTagInt(data.getAsInt()));
                return;
            }
            case LONG: {
                nbt.func_74742_a((NBTBase)new NBTTagLong(data.getAsLong()));
                return;
            }
            case FLOAT: {
                nbt.func_74742_a((NBTBase)new NBTTagFloat(data.getAsFloat()));
                return;
            }
            case DOUBLE: {
                nbt.func_74742_a((NBTBase)new NBTTagDouble(data.getAsDouble()));
                return;
            }
            case BYTEARRAY: {
                nbt.func_74742_a((NBTBase)new NBTTagByteArray(JsonNBT.jsonToByteArray(data.getAsJsonObject())));
                return;
            }
            case STRING: {
                nbt.func_74742_a((NBTBase)new NBTTagString(data.getAsString()));
                return;
            }
            case LIST: {
                nbt.func_74742_a((NBTBase)JsonNBT.jsonToList(data.getAsJsonObject()));
                return;
            }
            case COMPOUND: {
                nbt.func_74742_a((NBTBase)JsonNBT.jsonToCompound(data.getAsJsonObject()));
                return;
            }
            case INTARRAY: {
                nbt.func_74742_a((NBTBase)new NBTTagIntArray(JsonNBT.jsonToIntArray(data.getAsJsonObject())));
                return;
            }
        }
    }

    public static byte[] jsonToByteArray(JsonObject data) {
        JsonArray arr = data.getAsJsonArray();
        byte[] bytes = new byte[arr.size()];
        int i = 0;
        for (JsonElement e : arr) {
            bytes[i] = e.getAsByte();
            ++i;
        }
        return bytes;
    }

    public static int[] jsonToIntArray(JsonObject data) {
        JsonArray arr = data.getAsJsonArray();
        int[] ints = new int[arr.size()];
        int i = 0;
        for (JsonElement e : arr) {
            ints[i] = e.getAsInt();
            ++i;
        }
        return ints;
    }
}

