/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;

public abstract class SyncedWidget
extends Widget
implements ISyncedWidget {
    private boolean needsUpdate;
    private boolean syncsToServer = true;
    private boolean syncsToClient = true;

    @Override
    public void readJson(JsonObject json, String type) {
        super.readJson(json, type);
        this.syncsToServer = JsonHelper.getBoolean(json, true, "syncToClient", "handlesServer");
        this.syncsToClient = JsonHelper.getBoolean(json, true, "syncToServer", "handlesClient");
    }

    public boolean syncsToClient() {
        return this.syncsToClient;
    }

    public boolean syncsToServer() {
        return this.syncsToServer;
    }

    public SyncedWidget setSynced(boolean syncsToClient, boolean syncsToServer) {
        this.syncsToClient = syncsToClient;
        this.syncsToServer = syncsToServer;
        return this;
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }
}

