/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.network;

import com.kuba6000.mobsinfo.MobsInfo;
import com.kuba6000.mobsinfo.api.MobOverride;
import com.kuba6000.mobsinfo.config.Config;
import com.kuba6000.mobsinfo.loader.MobRecipeLoader;
import com.kuba6000.mobsinfo.loader.VillagerTradesLoader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;

public class LoadConfigPacket
implements IMessage {
    public static final LoadConfigPacket instance = new LoadConfigPacket();
    public final HashSet<String> mobsToLoad = new HashSet();
    public final HashMap<String, MobOverride> mobsOverrides = new HashMap();
    public final HashSet<Integer> villagersToLoad = new HashSet();

    public void fromBytes(ByteBuf buf) {
        int i;
        if (!buf.readBoolean()) {
            this.mobsToLoad.clear();
        } else {
            Config.Compatibility.enableMobHandlerInfernal = buf.readBoolean();
            Config.MobHandler.hiddenMode = buf.readBoolean();
            this.mobsToLoad.clear();
            int mobssize = buf.readInt();
            for (i = 0; i < mobssize; ++i) {
                byte[] sbytes = new byte[buf.readInt()];
                buf.readBytes(sbytes);
                this.mobsToLoad.add(new String(sbytes, StandardCharsets.UTF_8));
            }
            int overridessize = buf.readInt();
            for (int i2 = 0; i2 < overridessize; ++i2) {
                byte[] sbytes = new byte[buf.readInt()];
                buf.readBytes(sbytes);
                this.mobsOverrides.put(new String(sbytes, StandardCharsets.UTF_8), MobOverride.readFromByteBuf(buf));
            }
        }
        if (!buf.readBoolean()) {
            this.villagersToLoad.clear();
        } else {
            int villagerSize = buf.readInt();
            this.villagersToLoad.clear();
            for (i = 0; i < villagerSize; ++i) {
                this.villagersToLoad.add(buf.readInt());
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        if (!Config.MobHandler.mobHandlerEnabled) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeBoolean(Config.Compatibility.enableMobHandlerInfernal);
            buf.writeBoolean(Config.MobHandler.hiddenMode);
            buf.writeInt(this.mobsToLoad.size());
            this.mobsToLoad.forEach(s -> {
                byte[] sbytes = s.getBytes(StandardCharsets.UTF_8);
                buf.writeInt(sbytes.length);
                buf.writeBytes(sbytes);
            });
            buf.writeInt(this.mobsOverrides.size());
            this.mobsOverrides.forEach((k, v) -> {
                byte[] sbytes = k.getBytes(StandardCharsets.UTF_8);
                buf.writeInt(sbytes.length);
                buf.writeBytes(sbytes);
                v.writeToByteBuf(buf);
            });
        }
        if (!Config.VillagerTradesHandler.enabled) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.villagersToLoad.size());
            this.villagersToLoad.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
        }
    }

    public static class Handler
    implements IMessageHandler<LoadConfigPacket, IMessage> {
        public IMessage onMessage(LoadConfigPacket message, MessageContext ctx) {
            MobsInfo.info("Received Mobs-Info config, parsing");
            MobRecipeLoader.processMobRecipeMap(message.mobsToLoad, message.mobsOverrides);
            VillagerTradesLoader.processVillagerTrades(message.villagersToLoad);
            return null;
        }
    }
}

