/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import fox.spiteful.forbidden.Config;
import fox.spiteful.forbidden.enchantments.DarkEnchantments;
import fox.spiteful.forbidden.items.ForbiddenItems;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import thaumcraft.api.entities.ITaintedMob;

public class ForbiddenMagic
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        MobDrop drop;
        if (recipe.entity instanceof ITaintedMob) {
            drop = new MobDrop(new ItemStack(ForbiddenItems.resource, 1, 3), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(50.0), new IChanceModifier.DropsOnlyWithWeaknessII()));
            drops.add(drop);
        }
        if (Config.silverfishEmeralds && recipe.entity instanceof EntitySilverfish) {
            drop = new MobDrop(new ItemStack(ForbiddenItems.resource, 1, 0), MobDrop.DropType.Normal, 286, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(2.86), new IChanceModifier.OrBiome(BiomeGenBase.field_76770_e, 10.0)));
            drops.add(drop);
        }
        if (Config.greedyEnch && (recipe.entity instanceof EntityVillager || recipe.entity instanceof IMob)) {
            if (recipe.entity instanceof EntityVillager) {
                drop = new MobDrop(new ItemStack(Items.field_151166_bC, 1), MobDrop.DropType.Normal, 0, null, null, false, false);
                drop.variableChance = true;
                drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(100.0), new IChanceModifier.DropsOnlyWithEnchant(DarkEnchantments.greedy)));
            } else {
                drop = new MobDrop(new ItemStack(ForbiddenItems.resource, 1, 0), MobDrop.DropType.Normal, 0, null, null, false, false);
                drop.variableChance = true;
                drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(8.57), new IChanceModifier.DropsOnlyWithEnchant(DarkEnchantments.greedy)));
            }
            drops.add(drop);
        }
        if (recipe.entity.getClass() == EntitySkeleton.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, ((EntitySkeleton)recipe.entity).func_82202_m()), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(15.38), new IChanceModifier.DropsOnlyUsing(ForbiddenItems.skullAxe)));
            drops.add(drop);
        }
        if (recipe.entity.getClass() == EntityZombie.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, 2), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(11.54), new IChanceModifier.DropsOnlyUsing(ForbiddenItems.skullAxe)));
            drops.add(drop);
        }
        if (recipe.entity.getClass() == EntityCreeper.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, 4), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(11.54), new IChanceModifier.DropsOnlyUsing(ForbiddenItems.skullAxe)));
            drops.add(drop);
        }
        drop = new MobDrop(new ItemStack(ForbiddenItems.deadlyShards, 1, 5), MobDrop.DropType.Normal, (int)(MobDrop.getChanceBasedOnFromTo(1, 3) * 10000.0 * 0.1333333), null, null, false, false);
        drop.clampChance();
        drop.variableChance = true;
        drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance((double)drop.chance / 100.0), new IChanceModifier.DropsOnlyInDimension(-1), new NonPlayerEntity()));
        drop.chance = 0;
        drops.add(drop);
        if (recipe.entity instanceof IMob) {
            MobDrop drop3;
            MobDrop drop2 = new MobDrop(new ItemStack(ForbiddenItems.deadlyShards, 1, 0), MobDrop.DropType.Normal, 328, null, null, false, false);
            drops.add(drop2);
            if (recipe.entity instanceof IBossDisplayData) {
                drop3 = new MobDrop(new ItemStack(ForbiddenItems.deadlyShards, 2, 3), MobDrop.DropType.Normal, 10000, null, null, false, false);
                drops.add(drop3);
            }
            drop3 = new MobDrop(new ItemStack(ForbiddenItems.deadlyShards, 1, 6), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop3.variableChance = true;
            drop3.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(0.0), new IChanceModifier.EachLevelOfGives(Enchantment.field_77335_o, 5.0), new EachLevelOfGivesFocus()));
            drops.add(drop3);
        }
    }

    private static class NonPlayerEntity
    implements IChanceModifier {
        private NonPlayerEntity() {
        }

        @Override
        public String getDescription() {
            return Translations.FORBIDDEN_MAGIC_NON_PLAYER.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (chance == 0.0) {
                return 0.0;
            }
            if (!(attacker instanceof EntityPlayer)) {
                return chance;
            }
            return 0.0;
        }
    }

    private static class EachLevelOfGivesFocus
    extends IChanceModifier.EachLevelOfGives {
        protected EachLevelOfGivesFocus() {
        }

        @Override
        public String getDescription() {
            return Translations.EACH_LEVEL_OF_GIVES.get("treasure focus on wand", "5.0%");
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return chance;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
        }
    }
}

