/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.mixin.optimization.threadedtextureloader.ITextureMap;
import makamys.coretweaks.optimization.TextureLoaderThread;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ThreadedTextureLoader {
    List<TextureLoaderThread> threads = new ArrayList<TextureLoaderThread>();
    protected LinkedBlockingQueue<ResourceLoadJob> queue = new LinkedBlockingQueue();
    protected ConcurrentHashMap<ResourceLocation, Failable<IResource, IOException>> resMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<IResource, Failable<BufferedImage, IOException>> map = new ConcurrentHashMap();
    protected IResource lastStreamedResource;
    public static final List<ResourceLoadJob> waitingOn = new ArrayList<ResourceLoadJob>(1);
    private boolean hooked;

    public ThreadedTextureLoader(int numThreads) {
        this.initThreads(numThreads);
        CoreTweaks.LOGGER.info("Initialized threaded texture loader with " + numThreads + " threads.");
    }

    private void initThreads(int numThreads) {
        for (int i = 0; i < numThreads; ++i) {
            this.threads.add(new TextureLoaderThread(this, i));
        }
        for (TextureLoaderThread t : this.threads) {
            t.start();
        }
    }

    public void setLastStreamedResource(IResource res) {
        this.lastStreamedResource = res;
    }

    public void addSpriteLoadJobs(Map mapRegisteredSprites, ITextureMap itx) {
        Iterator iterator = itx.mapRegisteredSprites().entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                ResourceLocation resLoc = new ResourceLocation((String)entry.getKey());
                resLoc = itx.callCompleteResourceLocation(resLoc, 0);
                this.resMap.clear();
                if (this.map.containsKey(resLoc)) continue;
                this.queue.add(new ResourceLoadJob(resLoc));
            }
            catch (Exception exception) {}
        }
    }

    public BufferedImage fetchLastStreamedResource() throws IOException {
        return this.fetchFromMap(this.map, this.lastStreamedResource).getOrThrow();
    }

    public IResource fetchResource(ResourceLocation loc) throws IOException {
        return this.fetchFromMap(this.resMap, loc).getOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> V fetchFromMap(Map<K, V> map, K key) {
        while (true) {
            List<ResourceLoadJob> list = waitingOn;
            synchronized (list) {
                if (map.containsKey(key)) {
                    break;
                }
                waitingOn.add(ResourceLoadJob.of(key));
                if (waitingOn.size() > 1) {
                    throw new IllegalStateException();
                }
                this.queue.add(ResourceLoadJob.of(key));
                try {
                    waitingOn.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        waitingOn.clear();
        return map.get(key);
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre pre) {
        boolean bl = this.hooked = !this.skipFirst();
        if (this.hooked) {
            this.addSpriteLoadJobs(((ITextureMap)pre.map).mapRegisteredSprites(), (ITextureMap)pre.map);
        }
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post post) {
        this.hooked = false;
        this.resMap.clear();
        this.map.clear();
        this.queue.clear();
        this.lastStreamedResource = null;
        waitingOn.clear();
    }

    private boolean skipFirst() {
        try {
            Field skipFirstField = TextureMap.class.getDeclaredField("skipFirst");
            skipFirstField.setAccessible(true);
            return (Boolean)skipFirstField.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isHooked() {
        return this.hooked;
    }

    static class Failable<T, E extends Exception> {
        private Optional<T> thing = null;
        private E exception = null;

        public Failable(T thing) {
            this.thing = Optional.ofNullable(thing);
        }

        public Failable(E e) {
            this.exception = e;
        }

        public T get() {
            if (this.thing == null) {
                throw new NoSuchElementException();
            }
            return this.thing.orElse(null);
        }

        public T getOrThrow() throws E {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.get();
        }

        public boolean present() {
            return this.thing != null;
        }

        public boolean failed() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public static <T, E extends Exception> Failable<T, E> of(T thing) {
            return new Failable<T, T>(thing);
        }

        public static <T, E extends Exception> Failable<T, E> failed(E e) {
            return new Failable<T, E>(e);
        }
    }

    static class ResourceLoadJob {
        Optional<IResource> resource = Optional.empty();
        Optional<ResourceLocation> resourceLocation = Optional.empty();

        public ResourceLoadJob(IResource res) {
            this.resource = Optional.of(res);
        }

        public ResourceLoadJob(ResourceLocation resLoc) {
            this.resourceLocation = Optional.of(resLoc);
        }

        public static ResourceLoadJob of(Object object) {
            if (object instanceof IResource) {
                return new ResourceLoadJob((IResource)object);
            }
            if (object instanceof ResourceLocation) {
                return new ResourceLoadJob((ResourceLocation)object);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceLoadJob) {
                ResourceLoadJob o = (ResourceLoadJob)obj;
                return Objects.equals(this.resource, o.resource) && Objects.equals(this.resourceLocation, o.resourceLocation);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.resourceLocation);
        }
    }
}

