/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fluid;

import com.cleanroommc.modularui.utils.fluid.IFluidTankLong;
import com.google.common.primitives.Ints;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTankLongDelegate
implements IFluidTankLong {
    IFluidTank delegate;

    public FluidTankLongDelegate(IFluidTank tank) {
        this.delegate = tank;
    }

    @Override
    public long drainLong(long maxDrain, boolean doDrain) {
        FluidStack fluid = this.delegate.drain(Ints.saturatedCast((long)maxDrain), doDrain);
        return fluid.amount;
    }

    @Override
    public long fillLong(Fluid fluid, long amount, boolean doFill) {
        FluidStack fluidStack = new FluidStack(fluid, Ints.saturatedCast((long)amount));
        return this.delegate.fill(fluidStack, doFill);
    }

    @Override
    public long getCapacityLong() {
        return this.delegate.getCapacity();
    }

    @Override
    public long getFluidAmountLong() {
        return this.delegate.getFluidAmount();
    }

    @Override
    public Fluid getRealFluid() {
        FluidStack fluid = this.delegate.getFluid();
        if (fluid == null) {
            return null;
        }
        return fluid.getFluid();
    }

    @Override
    public void setFluid(Fluid fluid, long amount) {
        this.delegate.drain(Integer.MAX_VALUE, true);
        this.delegate.fill(new FluidStack(fluid, Ints.saturatedCast((long)amount)), true);
    }

    @Override
    public IFluidTankLong copy() {
        return new FluidTankLongDelegate((IFluidTank)new FluidTank(this.delegate.getFluid(), this.delegate.getCapacity()));
    }

    @Override
    public IFluidTankLong readFromNBT(NBTTagCompound fluidTag) {
        this.delegate.drain(Integer.MAX_VALUE, true);
        this.delegate.fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag), true);
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound fluidTag) {
        if (this.delegate.getFluid() == null) {
            return fluidTag;
        }
        this.delegate.getFluid().writeToNBT(fluidTag);
        return fluidTag;
    }
}

