/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.MultiBlock;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.BigDoor;
import net.malisis.doors.door.block.CollisionHelperBlock;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.movement.CarriageDoorMovement;
import net.malisis.doors.door.multiBlock.MultiBlueprint;
import net.malisis.doors.door.sound.CarriageDoorSound;
import net.malisis.doors.door.tileentity.IBluePrint;
import net.malisis.doors.door.tileentity.IMultiBlock;
import net.malisis.doors.door.tileentity.MultiTile;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3i;

public class BigDoorTileEntity
extends MultiTile
implements IMultiBlock,
IBluePrint {
    private boolean delete = false;
    private boolean processed = true;
    private ForgeDirection direction = ForgeDirection.NORTH;
    private final Block defaultBorderBlock = Blocks.field_150417_aV;
    private BlockState frameState = new BlockState(this.defaultBorderBlock);
    private Boolean changingState = false;
    private final int[][][] openPrint = new int[][][]{new int[][]{{10, -1, -1, 9}, {Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 7}}, new int[][]{{10, -1, -1, 9}, {5, Integer.MIN_VALUE, Integer.MIN_VALUE, 7}}, new int[][]{{10, -1, -1, 9}, {5, Integer.MIN_VALUE, Integer.MIN_VALUE, 7}}, new int[][]{{10, -1, -1, 9}, {5, Integer.MIN_VALUE, Integer.MIN_VALUE, 7}}, new int[][]{{-1, -1, -1, -1}, {0, 0, 0, 0}}};
    private final int[][][] closedPrint = new int[][][]{new int[][]{{Integer.MIN_VALUE, -1, -1, Integer.MIN_VALUE}, {Integer.MAX_VALUE, 0, 0, 0}}, new int[][]{{Integer.MIN_VALUE, -1, -1, Integer.MIN_VALUE}, {0, 0, 0, 0}}, new int[][]{{Integer.MIN_VALUE, -1, -1, Integer.MIN_VALUE}, {0, 0, 0, 0}}, new int[][]{{Integer.MIN_VALUE, -1, -1, Integer.MIN_VALUE}, {0, 0, 0, 0}}, new int[][]{{Integer.MIN_VALUE, -1, -1, Integer.MIN_VALUE}, {0, 0, 0, 0}}};
    Map<Integer, int[]> metaMap = new HashMap<Integer, int[]>(){
        {
            this.put(0, new int[]{1, 2, 3});
            this.put(1, new int[]{2, 3, 0});
            this.put(2, new int[]{3, 0, 1});
            this.put(3, new int[]{0, 1, 2});
            this.put(4, new int[]{5, 6, 7});
            this.put(5, new int[]{6, 7, 4});
            this.put(6, new int[]{7, 4, 5});
            this.put(7, new int[]{4, 5, 6});
            this.put(8, new int[]{9, 10, 11});
            this.put(9, new int[]{10, 11, 8});
            this.put(10, new int[]{11, 8, 9});
            this.put(11, new int[]{8, 9, 10});
        }
    };
    private final MultiBlueprint closedBlueprint = new MultiBlueprint(this.closedPrint, this.metaMap, new Vector3i(1, 0, 0));
    private final MultiBlueprint openBlueprint = new MultiBlueprint(this.openPrint, this.metaMap, new Vector3i(1, 0, 0));
    private BigDoor.Type type;

    public BigDoorTileEntity() {
        this.type = BigDoor.Type.DEFAULT;
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(CarriageDoorMovement.class));
        descriptor.setSound(DoorRegistry.getSound(CarriageDoorSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(20);
        this.setDescriptor(descriptor);
    }

    public BigDoorTileEntity(BigDoor.Type type) {
        this.type = type;
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(CarriageDoorMovement.class));
        descriptor.setSound(DoorRegistry.getSound(CarriageDoorSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(20);
        this.setDescriptor(descriptor);
    }

    public BlockState getFrameState() {
        return this.frameState;
    }

    @Override
    public void setFrameState(BlockState state) {
        if (state != null) {
            this.frameState = state;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public void setFrameState(Block block) {
        this.setFrameState(new BlockState(block));
    }

    @Override
    public boolean isTopBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    @Override
    public void setDoorState(DoorState newState) {
        this.onStateChange(newState);
        super.setDoorState(newState);
    }

    @Override
    public void func_145845_h() {
        if (!this.processed && this.func_145831_w() != null) {
            if (this.delete) {
                MalisisCore.log.info("Deleting " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                MalisisCore.log.info("Adding to chunk : " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, Door.dirToInt(this.direction), 2);
                this.processed = true;
            }
            return;
        }
        super.func_145845_h();
    }

    public ItemStack getDroppedItemStack() {
        ItemStack itemStack = new ItemStack(this.func_145838_q());
        NBTTagCompound nbt = new NBTTagCompound();
        BlockState.toNBT(nbt, this.frameState);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("multiBlock")) {
            MultiBlock mb = new MultiBlock(tag);
            this.delete = !mb.isOrigin(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.direction = mb.getDirection();
            this.processed = false;
        }
        int typeInt = tag.func_74762_e("type");
        switch (typeInt) {
            case 0: 
            case 1: {
                this.type = BigDoor.Type.CARRIAGE;
                break;
            }
            case 2: {
                this.type = BigDoor.Type.MEDIEVAL;
            }
        }
        this.frameState = (BlockState)Objects.firstNonNull((Object)BlockState.fromNBT(tag), (Object)new BlockState(this.defaultBorderBlock));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.type.ordinal());
        BlockState.toNBT(nbt, this.frameState);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return ((BigDoor)this.func_145838_q()).getBoundingBox((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, BoundingBoxType.RENDER)[0].func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasRoomToOpenOrClose()) {
                this.openOrCloseDoor();
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("There's no room for the door to open or close!"));
            }
        }
        return true;
    }

    private boolean hasRoomToOpenOrClose() {
        boolean bl;
        int meta = this.func_145832_p() % 4;
        switch (this.state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CLOSED: {
                bl = this.doorsCanSwingOpen(meta);
                break;
            }
            case OPENED: 
            case OPENING: {
                bl = this.doorsCanClose(meta);
                break;
            }
            case CLOSING: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean doorsCanClose(int meta) {
        switch (meta) {
            case 0: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yRel, this.field_145849_e - 1) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yRel, this.field_145849_e - 2) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
            case 1: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + yRel, this.field_145849_e) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + yRel, this.field_145849_e) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
            case 2: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yRel, this.field_145849_e + 1) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yRel, this.field_145849_e + 2) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
            case 3: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + yRel, this.field_145849_e) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + yRel, this.field_145849_e) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    private boolean doorsCanSwingOpen(int meta) {
        switch (meta) {
            case 0: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + yRel, this.field_145849_e) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + yRel, this.field_145849_e - 3) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
            case 1: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yRel, this.field_145849_e - 1) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + 3, this.field_145848_d + yRel, this.field_145849_e - 1) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
            case 2: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + yRel, this.field_145849_e) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + yRel, this.field_145849_e + 3) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
            case 3: {
                for (int yRel = 0; yRel < 4; ++yRel) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yRel, this.field_145849_e + 1) != Blocks.field_150350_a) {
                        return false;
                    }
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + 3, this.field_145848_d + yRel, this.field_145849_e + 1) == Blocks.field_150350_a) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    @Override
    public void onCreate(int x, int y, int z, int meta) {
        this.func_70296_d();
        int buildHeight = this.field_145850_b.func_72800_K() - 6;
        if (y > buildHeight) {
            return;
        }
        this.setMainBlock(x, y, z);
        this.mainBlockSet = true;
        this.placeBluePrint(this.field_145850_b, x, y, z, meta, false);
    }

    @Override
    public void onDestroy(TileEntity callingBlock, int meta) {
        if (!this.changingState.booleanValue()) {
            int metaToUse = meta;
            if ((this.state == DoorState.OPENING || this.state == DoorState.CLOSING || this.state == DoorState.OPENED) && metaToUse < 4) {
                metaToUse += 4;
            } else if (this.state == DoorState.CLOSED && metaToUse > 3) {
                metaToUse -= 4;
            }
            this.changingState = true;
            this.removeBluePrint(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, metaToUse, callingBlock);
            this.changingState = false;
        }
    }

    public void onStateChange(DoorState newState) {
        if (this.state == newState) {
            return;
        }
        if (this.func_145831_w() == null) {
            return;
        }
        int meta = this.func_145832_p();
        if (newState == DoorState.OPENING) {
            this.changingState = true;
            if (meta < 4) {
                meta = (meta + 4) % 8;
            }
            this.placeBluePrint(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, true);
            this.changingState = false;
        } else if (newState == DoorState.CLOSED) {
            this.changingState = true;
            if (meta > 3) {
                meta -= 4;
            }
            this.placeBluePrint(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, true);
            this.changingState = false;
        }
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound packetData = pkt.func_148857_g();
        this.setFrameState(BlockState.fromNBT(packetData));
    }

    @Override
    public void placeBluePrint(World world, int x, int y, int z, int meta, boolean removeBlockInWay) {
        MultiBlueprint print = meta < 4 ? this.closedBlueprint : this.openBlueprint;
        switch (meta) {
            case 0: 
            case 4: {
                this.bluePrintPlacerHelper(world, x, y, z, print, removeBlockInWay);
                break;
            }
            case 1: 
            case 5: {
                print.rotate(MultiBlueprint.RotationDegrees.ROT90);
                this.bluePrintPlacerHelper(world, x, y, z, print, removeBlockInWay);
                print.rotate(MultiBlueprint.RotationDegrees.ROT270);
                break;
            }
            case 2: 
            case 6: {
                print.rotate(MultiBlueprint.RotationDegrees.ROT180);
                this.bluePrintPlacerHelper(world, x, y, z, print, removeBlockInWay);
                print.rotate(MultiBlueprint.RotationDegrees.ROT180);
                break;
            }
            case 3: 
            case 7: {
                print.rotate(MultiBlueprint.RotationDegrees.ROT270);
                this.bluePrintPlacerHelper(world, x, y, z, print, removeBlockInWay);
                print.rotate(MultiBlueprint.RotationDegrees.ROT90);
            }
        }
    }

    private void bluePrintPlacerHelper(World world, int x, int y, int z, MultiBlueprint print, boolean removeBlockInWay) {
        int mainBlockRelativeX = print.startingLocation.x;
        int mainBlockRelativeY = print.startingLocation.y;
        int mainBlockRelativeZ = print.startingLocation.z;
        for (int j = 0; j < print.bluePrint.length; ++j) {
            for (int i = 0; i < print.bluePrint[0].length; ++i) {
                for (int k = 0; k < print.bluePrint[0][0].length; ++k) {
                    if ((i != mainBlockRelativeX || j != mainBlockRelativeY || k != mainBlockRelativeZ) && print.bluePrint[j][i][k] > -1) {
                        switch (this.type) {
                            case CARRIAGE: {
                                ((CollisionHelperBlock)MalisisDoors.Blocks.collisionHelperBlockCarriage).makeCollisionHelperBlock(world, x - mainBlockRelativeX + i, y - mainBlockRelativeY + j, z + mainBlockRelativeZ - k, print.bluePrint[j][i][k], this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p());
                                break;
                            }
                            case MEDIEVAL: {
                                ((CollisionHelperBlock)MalisisDoors.Blocks.collisionHelperBlockMedieval).makeCollisionHelperBlock(world, x - mainBlockRelativeX + i, y - mainBlockRelativeY + j, z + mainBlockRelativeZ - k, print.bluePrint[j][i][k], this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p());
                            }
                        }
                        continue;
                    }
                    if (print.bluePrint[j][i][k] != Integer.MIN_VALUE || !removeBlockInWay) continue;
                    world.func_147468_f(x - mainBlockRelativeX + i, y - mainBlockRelativeY + j, z + mainBlockRelativeZ - k);
                }
            }
        }
    }

    @Override
    public void removeBluePrint(World world, int x, int y, int z, int meta, TileEntity callingBlock) {
        MultiBlueprint print = meta < 4 ? this.closedBlueprint : this.openBlueprint;
        switch (meta) {
            case 0: 
            case 4: {
                this.bluePrintRemovalHelper(world, x, y, z, print, callingBlock);
                break;
            }
            case 1: 
            case 5: {
                print.rotate(MultiBlueprint.RotationDegrees.ROT90);
                this.bluePrintRemovalHelper(world, x, y, z, print, callingBlock);
                print.rotate(MultiBlueprint.RotationDegrees.ROT270);
                break;
            }
            case 2: 
            case 6: {
                print.rotate(MultiBlueprint.RotationDegrees.ROT180);
                this.bluePrintRemovalHelper(world, x, y, z, print, callingBlock);
                print.rotate(MultiBlueprint.RotationDegrees.ROT180);
                break;
            }
            case 3: 
            case 7: {
                print.rotate(MultiBlueprint.RotationDegrees.ROT270);
                this.bluePrintRemovalHelper(world, x, y, z, print, callingBlock);
                print.rotate(MultiBlueprint.RotationDegrees.ROT90);
            }
        }
    }

    private void bluePrintRemovalHelper(World world, int x, int y, int z, MultiBlueprint print, TileEntity callingBlock) {
        BigDoor blockToDrop = this.type == BigDoor.Type.CARRIAGE ? MalisisDoors.Blocks.carriageDoor : MalisisDoors.Blocks.medievalDoor;
        int mainBlockRelativeX = print.startingLocation.x;
        int mainBlockRelativeY = print.startingLocation.y;
        int mainBlockRelativeZ = print.startingLocation.z;
        for (int j = 0; j < print.bluePrint.length; ++j) {
            for (int i = 0; i < print.bluePrint[0].length; ++i) {
                for (int k = 0; k < print.bluePrint[0][0].length; ++k) {
                    if (print.bluePrint[j][i][k] == Integer.MAX_VALUE) {
                        ((MultiTile)callingBlock).dropMainBlockAtLocation(blockToDrop);
                    }
                    if (print.bluePrint[j][i][k] <= -1) continue;
                    world.func_147468_f(x - mainBlockRelativeX + i, y - mainBlockRelativeY + j, z + mainBlockRelativeZ - k);
                }
            }
        }
    }
}

