/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.BottomFace;
import net.malisis.core.renderer.element.face.NorthFace;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.element.face.TopFace;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.renderer.DoorRenderer;
import net.malisis.doors.door.tileentity.CustomDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;

public class CustomDoorRenderer
extends DoorRenderer {
    private Block frameBlock;
    private Block topMaterialBlock;
    private Block bottomMaterialBlock;
    private int frameMetadata;
    private int topMaterialMetadata;
    private int bottomMaterialMetadata;
    protected CustomDoorTileEntity tileEntity;
    private float width;
    private final Cube bottomR = new Cube();
    private final Cube bottomL = new Cube();
    private final Shape bottomH = new Shape(new NorthFace(), new SouthFace(), new TopFace(), new BottomFace());
    private final Shape bMat = new Shape(new SouthFace(), new TopFace(), new NorthFace());
    private final Cube topR = new Cube();
    private final Cube topL = new Cube();
    private final Shape topH = new Shape(new NorthFace(), new SouthFace(), new TopFace(), new BottomFace());
    private final Shape tMat = new Shape(this.bMat);
    private final Shape frame = new Shape();
    private final Shape bottom = new Shape();
    private final Shape top = new Shape();
    private static final String[] gnames = new String[]{"frame", "material"};

    @Override
    protected void initialize() {
        this.width = 0.125f;
        this.bottomR.reset();
        this.bottomR.setSize(this.width, 1.0f, 0.1875f);
        this.bottomL.copy(this.bottomR);
        this.bottomL.translate(1.0f - this.width, 0.0f, 0.0f);
        this.bottomH.reset();
        this.bottomH.setSize(1.0f - 2.0f * this.width, this.width, 0.1875f);
        this.bottomH.translate(this.width, 0.0f, 0.0f);
        this.frame.takeShapes(this.bottomR, this.bottomL, this.bottomH);
        this.frame.scale(1.0f, 1.0f, 0.995f);
        this.frame.applyMatrix();
        this.bMat.reset();
        this.bMat.setSize(1.0f - 2.0f * this.width, 1.0f - this.width, 0.112500004f).translate(this.width, this.width, 0.0375f);
        this.bMat.applyMatrix();
        this.bottom.takeFaces(gnames, this.frame, this.bMat);
        this.bottom.interpolateUV();
        this.bottom.storeState();
        this.topR.copy(this.bottomR);
        this.topL.copy(this.bottomL);
        this.topH.copy(this.bottomH);
        this.topH.translate(0.0f, 1.0f - this.width, 0.0f);
        this.frame.takeShapes(this.topR, this.topL, this.topH);
        this.frame.scale(1.0f, 1.0f, 0.995f);
        this.frame.applyMatrix();
        this.tMat.copy(this.bMat);
        this.tMat.translate(0.0f, -this.width, 0.0f);
        this.tMat.applyMatrix();
        this.top.takeFaces(gnames, this.frame, this.tMat);
        this.top.translate(0.0f, 1.0f, 0.0f);
        this.top.interpolateUV();
        this.top.storeState();
        if (this.model != null) {
            this.model.reset();
        } else {
            this.model = new MalisisModel();
        }
        this.model.addShape("bottom", this.bottom);
        this.model.addShape("top", this.top);
        this.model.storeState();
        if (this.rp != null) {
            this.rp.init();
        } else {
            this.initParams();
        }
    }

    @Override
    public void render() {
        this.initialize();
        if (this.renderType == RenderType.ITEM_INVENTORY) {
            if (this.itemStack.field_77990_d == null) {
                return;
            }
            this.renderInventory();
            return;
        }
        super.render();
    }

    @Override
    protected void setTileEntity() {
        super.setTileEntity();
        this.tileEntity = (CustomDoorTileEntity)((DoorRenderer)this).tileEntity;
    }

    private void setInfos(CustomDoorTileEntity te) {
        this.frameBlock = te.getFrame();
        this.topMaterialBlock = te.getTopMaterial();
        this.bottomMaterialBlock = te.getBottomMaterial();
        this.frameMetadata = te.getFrameMetadata();
        this.topMaterialMetadata = te.getTopMaterialMetadata();
        this.bottomMaterialMetadata = te.getBottomMaterialMetadata();
    }

    private void setInfos(NBTTagCompound nbt) {
        this.frameBlock = Block.func_149729_e((int)nbt.func_74762_e("frame"));
        this.topMaterialBlock = Block.func_149729_e((int)nbt.func_74762_e("topMaterial"));
        this.bottomMaterialBlock = Block.func_149729_e((int)nbt.func_74762_e("bottomMaterial"));
        this.frameMetadata = nbt.func_74762_e("frameMetadata");
        this.topMaterialMetadata = nbt.func_74762_e("topMaterialMetadata");
        this.bottomMaterialMetadata = nbt.func_74762_e("bottomMaterialMetadata");
    }

    @Override
    protected void setup() {
        this.model.resetState();
        if (this.renderType == RenderType.TESR_WORLD) {
            this.setInfos(this.tileEntity);
        } else {
            this.setInfos(this.itemStack.field_77990_d);
        }
        if (this.frameBlock == null) {
            return;
        }
        this.setupParams(true);
        this.setupParams(false);
        if (this.renderType == RenderType.TESR_WORLD) {
            super.setup();
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.INVENTORY) {
            this.model.rotate(45.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.model.scale(0.9f, 0.8f, 1.0f, 0.0f, 0.0f, 0.0f);
            this.model.translate(0.0f, -1.0f, 0.0f);
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.ENTITY) {
            this.model.translate(-0.5f, -0.5f, -0.25f);
            this.model.scale(0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f);
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void setupParams(boolean topBlock) {
        this.rp.alpha.reset();
        Shape s = this.model.getShape(topBlock ? "top" : "bottom");
        this.rp.icon.set(this.frameBlock.func_149691_a(2, this.frameMetadata));
        this.rp.colorMultiplier.set(this.getColor(this.frameBlock));
        s.setParameters("frame", this.rp, true);
        Block block = topBlock ? this.topMaterialBlock : this.bottomMaterialBlock;
        int meta = topBlock ? this.topMaterialMetadata : this.bottomMaterialMetadata;
        this.rp.icon.set(block.func_149691_a(2, meta));
        this.rp.colorMultiplier.set(this.getColor(block));
        s.setParameters("material", this.rp, true);
        this.rp.icon.reset();
        this.rp.colorMultiplier.reset();
    }

    private int getColor(Block block) {
        if (block == Blocks.field_150349_c) {
            return 0xFFFFFF;
        }
        return this.renderType == RenderType.TESR_WORLD ? block.func_149720_d(this.world, this.x, this.y, this.z) : block.func_149635_D();
    }

    private void renderInventory() {
        this.func_147499_a(TextureMap.field_110575_b);
        this.enableBlending();
        this.setup();
        this.model.render((MalisisRenderer)this, this.rp);
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }
}

