/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.handler;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.reference.Names;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigurationHandler
implements IResourceManagerReloadListener {
    public static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    public static Configuration configuration;
    public static final String CONFIG_NAME_DEFAULT = "InGameInfo.xml";
    public static final boolean SHOW_HUD_DEFAULT = true;
    public static final boolean REPLACE_DEBUG_DEFAULT = false;
    public static final boolean SHOW_IN_CHAT_DEFAULT = true;
    public static final boolean SHOW_ON_PLAYER_LIST_DEFAULT = true;
    public static final int DEFAULT_SCALE = 10;
    public static final int FILE_INTERVAL_DEFAULT = 5;
    public static String configName;
    public static boolean showHUD;
    public static boolean replaceDebug;
    public static boolean showInChat;
    public static boolean showOnPlayerList;
    public static float Scale;
    public static int fileInterval;
    public static Property propConfigName;
    public static Property propShowHUD;
    public static Property propReplaceDebug;
    public static Property propShowInChat;
    public static Property propShowOnPlayerList;
    public static Property propscale;
    public static Property propFileInterval;
    public static final Map<Alignment, Property> propAlignments;

    private ConfigurationHandler() {
    }

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        propConfigName = configuration.get("general", "filename", CONFIG_NAME_DEFAULT, "The configuration that should be loaded on startup.");
        propConfigName.setLanguageKey(Names.Config.LANG_PREFIX + "." + "filename");
        propConfigName.setRequiresMcRestart(true);
        configName = propConfigName.getString();
        propShowHUD = configuration.get("general", "ShowHUD", true, "If this is true, it will render the info overlay");
        propShowHUD.setLanguageKey(Names.Config.LANG_PREFIX + "." + "ShowHUD");
        propShowHUD.setRequiresMcRestart(false);
        showHUD = propShowHUD.getBoolean(true);
        propReplaceDebug = configuration.get("general", "replaceDebug", false, "Replace the debug overlay (F3) with the InGameInfoXML overlay.");
        propReplaceDebug.setLanguageKey(Names.Config.LANG_PREFIX + "." + "replaceDebug");
        replaceDebug = propReplaceDebug.getBoolean(false);
        propShowInChat = configuration.get("general", "showInChat", true, "Display the overlay in chat.");
        propShowInChat.setLanguageKey(Names.Config.LANG_PREFIX + "." + "showInChat");
        showInChat = propShowInChat.getBoolean(true);
        propShowOnPlayerList = configuration.get("general", "showOnPlayerList", true, "Display the overlay on the player list.");
        propShowOnPlayerList.setLanguageKey(Names.Config.LANG_PREFIX + "." + "showOnPlayerList");
        showOnPlayerList = propShowOnPlayerList.getBoolean(true);
        propscale = configuration.get("general", "scale(new)", 10, "The overlay will be scaled by this amount.(use this one, the other is deprecated)", 1, 20);
        propscale.setLanguageKey(Names.Config.LANG_PREFIX + "." + "scale(new)");
        Scale = propscale.getInt(10);
        propFileInterval = configuration.get("general", "fileInterval", 5, "The interval between file reads for the 'file' tag (in seconds).", 1, 60);
        propFileInterval.setLanguageKey(Names.Config.LANG_PREFIX + "." + "fileInterval");
        fileInterval = propFileInterval.getInt(5);
        for (Alignment alignment : Alignment.values()) {
            Property property = configuration.get("alignment", alignment.toString().toLowerCase(), alignment.getDefaultXY(), String.format("Offsets for %s (X<space>Y).", new Object[]{alignment}));
            property.setLanguageKey(Names.Config.LANG_PREFIX + "." + alignment.toString().toLowerCase());
            property.setValidationPattern(Pattern.compile("-?\\d+ -?\\d+"));
            propAlignments.put(alignment, property);
            alignment.setXY(property.getString());
        }
        ConfigurationHandler.save();
    }

    public static void reload() {
        ConfigurationHandler.loadConfiguration();
        ConfigurationHandler.save();
    }

    public static void saveHUDsettingToFile() {
        propShowHUD = configuration.get("general", "ShowHUD", true, "If this is true, it will render the info overlay");
        propShowHUD.set(showHUD);
        ConfigurationHandler.save();
    }

    public static void save() {
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setConfigName(String name) {
        propConfigName.set(name);
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        InGameInfoCore.INSTANCE.setConfigFileWithLocale();
        InGameInfoCore.INSTANCE.reloadConfig();
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("InGameInfoXML")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    static {
        configName = CONFIG_NAME_DEFAULT;
        showHUD = true;
        replaceDebug = false;
        showInChat = true;
        showOnPlayerList = true;
        Scale = 10.0f;
        fileInterval = 5;
        propConfigName = null;
        propShowHUD = null;
        propReplaceDebug = null;
        propShowInChat = null;
        propShowOnPlayerList = null;
        propscale = null;
        propFileInterval = null;
        propAlignments = new HashMap<Alignment, Property>();
    }
}

