/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.kuba6000.mobsinfo.api.LoaderReference;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.Automagy;
import com.kuba6000.mobsinfo.loader.extras.Avaritia;
import com.kuba6000.mobsinfo.loader.extras.BloodArsenal;
import com.kuba6000.mobsinfo.loader.extras.BloodMagic;
import com.kuba6000.mobsinfo.loader.extras.Botania;
import com.kuba6000.mobsinfo.loader.extras.ChocoCraft;
import com.kuba6000.mobsinfo.loader.extras.CoFHCore;
import com.kuba6000.mobsinfo.loader.extras.DQRespect;
import com.kuba6000.mobsinfo.loader.extras.DraconicEvolution;
import com.kuba6000.mobsinfo.loader.extras.EditMobDrops;
import com.kuba6000.mobsinfo.loader.extras.ElectroMagicTools;
import com.kuba6000.mobsinfo.loader.extras.EtFuturum;
import com.kuba6000.mobsinfo.loader.extras.ExtraUtilities;
import com.kuba6000.mobsinfo.loader.extras.ForbiddenMagic;
import com.kuba6000.mobsinfo.loader.extras.GregtechPlusPlus;
import com.kuba6000.mobsinfo.loader.extras.HardcoreEnderExpansion;
import com.kuba6000.mobsinfo.loader.extras.HarvestCraft;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.LycanitesMobs;
import com.kuba6000.mobsinfo.loader.extras.MineTweaker;
import com.kuba6000.mobsinfo.loader.extras.Minecraft;
import com.kuba6000.mobsinfo.loader.extras.OpenBlocks;
import com.kuba6000.mobsinfo.loader.extras.Thaumcraft;
import com.kuba6000.mobsinfo.loader.extras.ThaumicBases;
import com.kuba6000.mobsinfo.loader.extras.ThaumicHorizons;
import com.kuba6000.mobsinfo.loader.extras.ThaumicTinkerer;
import com.kuba6000.mobsinfo.loader.extras.TinkersConstruct;
import com.kuba6000.mobsinfo.loader.extras.WirelessCraftingTerminal;
import com.kuba6000.mobsinfo.loader.extras.Witchery;
import com.kuba6000.mobsinfo.loader.extras.WitchingGadgets;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtraLoader {
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Extra Loader]");
    private static boolean initialized = false;
    private static final List<IExtraLoader> loaders = new ArrayList<IExtraLoader>();

    private static void init() {
        initialized = true;
        loaders.add(new Minecraft());
        if (LoaderReference.DraconicEvolution) {
            loaders.add(new DraconicEvolution());
        }
        if (LoaderReference.TinkersConstruct) {
            loaders.add(new TinkersConstruct());
        }
        if (LoaderReference.Witchery) {
            loaders.add(new Witchery());
        }
        if (LoaderReference.ThaumicHorizons) {
            loaders.add(new ThaumicHorizons());
        }
        if (LoaderReference.ThaumicBases) {
            loaders.add(new ThaumicBases());
        }
        if (LoaderReference.WirelessCraftingTerminal) {
            loaders.add(new WirelessCraftingTerminal());
        }
        if (LoaderReference.CoFHCore) {
            loaders.add(new CoFHCore());
        }
        if (LoaderReference.HardcoreEnderExpansion) {
            loaders.add(new HardcoreEnderExpansion());
        }
        if (LoaderReference.Botania) {
            loaders.add(new Botania());
        }
        if (LoaderReference.HarvestCraft) {
            loaders.add(new HarvestCraft());
        }
        if (LoaderReference.OpenBlocks) {
            loaders.add(new OpenBlocks());
        }
        if (LoaderReference.BloodArsenal) {
            loaders.add(new BloodArsenal());
        }
        if (LoaderReference.BloodMagic) {
            loaders.add(new BloodMagic());
        }
        if (LoaderReference.Avaritia) {
            loaders.add(new Avaritia());
        }
        if (LoaderReference.ThaumicTinkerer) {
            loaders.add(new ThaumicTinkerer());
        }
        if (LoaderReference.ForbiddenMagic) {
            loaders.add(new ForbiddenMagic());
        }
        if (LoaderReference.ElectroMagicTools) {
            loaders.add(new ElectroMagicTools());
        }
        if (LoaderReference.WitchingGadgets) {
            loaders.add(new WitchingGadgets());
        }
        if (LoaderReference.Thaumcraft) {
            loaders.add(new Thaumcraft());
        }
        if (LoaderReference.Automagy) {
            loaders.add(new Automagy());
        }
        if (LoaderReference.GTPlusPlus) {
            loaders.add(new GregtechPlusPlus());
        }
        if (LoaderReference.DQRespect) {
            loaders.add(new DQRespect());
        }
        if (LoaderReference.ChocoCraft) {
            loaders.add(new ChocoCraft());
        }
        if (LoaderReference.ExtraUtilities) {
            loaders.add(new ExtraUtilities());
        }
        if (LoaderReference.EtFuturumRequiem) {
            loaders.add(new EtFuturum());
        }
        if (LoaderReference.LycanitesMobs) {
            loaders.add(new LycanitesMobs());
        }
        if (LoaderReference.EditMobDrops) {
            loaders.add(new EditMobDrops());
        }
        if (LoaderReference.MineTweaker) {
            loaders.add(new MineTweaker());
        }
    }

    public static void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        if (!initialized) {
            ExtraLoader.init();
        }
        for (IExtraLoader loader : loaders) {
            try {
                loader.process(k, drops, recipe);
            }
            catch (Exception ex) {
                LOG.error("There was an error while loading " + loader.getClass().getSimpleName() + " modifications on " + k);
                ex.printStackTrace();
            }
        }
    }
}

