/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderRandom
extends FruitProviderNone {
    private final Map<ItemStack, Float> products = new HashMap<ItemStack, Float>();
    private int colour = 0xFFFFFF;

    public FruitProviderRandom(String key, IFruitFamily family, ItemStack product, float modifier) {
        super(key, family);
        this.products.put(product, Float.valueOf(modifier));
    }

    public FruitProviderRandom setColour(int colour) {
        this.colour = colour;
        return this;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
        return this.colour;
    }

    @Override
    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        ArrayList<ItemStack> product = new ArrayList<ItemStack>();
        float modeYieldMod = TreeManager.treeRoot.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
        for (Map.Entry<ItemStack, Float> entry : this.products.entrySet()) {
            if (!(world.field_73012_v.nextFloat() <= genome.getYield() * modeYieldMod * entry.getValue().floatValue())) continue;
            product.add(entry.getKey().func_77946_l());
        }
        return product.toArray(new ItemStack[product.size()]);
    }

    @Override
    public ItemStack[] getProducts() {
        Set<ItemStack> products = this.products.keySet();
        return products.toArray(new ItemStack[products.size()]);
    }

    @Override
    public ItemStack[] getSpecialty() {
        return new ItemStack[0];
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
        return true;
    }
}

