/*
 * Decompiled with CFR 0.152.
 */
package net.glease.structurecompat;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGridHost;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.items.storage.ItemViewCell;
import appeng.util.prioitylist.IPartitionList;
import com.gtnewhorizon.structurelib.util.InventoryIterable;
import com.gtnewhorizon.structurelib.util.InventoryUtility;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.glease.structurecompat.Compat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

@Compat(value={"appliedenergistics2"})
public class CompatAppliedEnergistics {
    public CompatAppliedEnergistics() {
        InventoryUtility.registerStackExtractor((String)"1000-ae2-wireless", (InventoryUtility.ItemStackExtractor)new MEInventoryStackExtractor(){

            @Override
            protected Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> fromItem(ItemStack source, EntityPlayerMP player) {
                long serial;
                if (!AEApi.instance().registries().wireless().isWirelessTerminal(source)) {
                    return null;
                }
                IWirelessTermHandler wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(source);
                if (wh == null) {
                    return null;
                }
                String key = wh.getEncryptionKey(source);
                try {
                    serial = Long.parseLong(key);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                ILocatable locatable = AEApi.instance().registries().locatable().getLocatableBy(serial);
                if (!(locatable instanceof IGridHost)) {
                    return null;
                }
                WirelessTerminalGuiObject guiObject = new WirelessTerminalGuiObject(wh, source, (EntityPlayer)player, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                if (!guiObject.rangeCheck()) {
                    return null;
                }
                IPartitionList filter = ItemViewCell.createFilter((ItemStack[])((ItemStack[])StreamSupport.stream(new InventoryIterable(guiObject.getViewCellStorage()).spliterator(), false).toArray(ItemStack[]::new)));
                IMEMonitor rawInventory = guiObject.getItemInventory();
                if (filter == null) {
                    return Pair.of((Object)guiObject, (Object)rawInventory);
                }
                return Pair.of((Object)guiObject, (Object)new ExtractionFilteredMEInventoryHandler((IMEMonitor<IAEItemStack>)rawInventory, (IPartitionList<IAEItemStack>)filter));
            }
        });
        InventoryUtility.registerStackExtractor((String)"1000-ae2-portable-cell", (InventoryUtility.ItemStackExtractor)new MEInventoryStackExtractor(){

            @Override
            protected Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> fromItem(ItemStack source, EntityPlayerMP player) {
                if (!AEApi.instance().definitions().items().portableCell().isSameAs(source)) {
                    return null;
                }
                IEnergySource energySource = (amt, mode, usePowerMultiplier) -> {
                    IAEItemPowerStorage item = (IAEItemPowerStorage)source.func_77973_b();
                    amt = usePowerMultiplier.multiply(amt);
                    if (mode == Actionable.SIMULATE) {
                        return usePowerMultiplier.divide(Math.min(amt, item.getAECurrentPower(source)));
                    }
                    return usePowerMultiplier.divide(item.extractAEPower(source, amt));
                };
                return Pair.of((Object)energySource, (Object)CompatAppliedEnergistics.getCellInventory(source));
            }
        });
    }

    private static IMEInventoryHandler<IAEItemStack> getCellInventory(ItemStack source) {
        return AEApi.instance().registries().cell().getCellInventory(source, null, StorageChannel.ITEMS);
    }

    private static class ExtractionFilteredMEInventoryHandler
    implements IMEInventoryHandler<IAEItemStack> {
        private final IMEMonitor<IAEItemStack> rawInventory;
        private final IPartitionList<IAEItemStack> filter;

        public ExtractionFilteredMEInventoryHandler(IMEMonitor<IAEItemStack> rawInventory, IPartitionList<IAEItemStack> filter) {
            this.rawInventory = rawInventory;
            this.filter = filter;
        }

        public AccessRestriction getAccess() {
            return this.rawInventory.getAccess();
        }

        public boolean isPrioritized(IAEItemStack input) {
            return this.rawInventory.isPrioritized((IAEStack)input);
        }

        public boolean canAccept(IAEItemStack input) {
            return this.rawInventory.canAccept((IAEStack)input);
        }

        public int getPriority() {
            return this.rawInventory.getPriority();
        }

        public int getSlot() {
            return this.rawInventory.getSlot();
        }

        public boolean validForPass(int i) {
            return this.rawInventory.validForPass(i);
        }

        public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
            return (IAEItemStack)this.rawInventory.injectItems((IAEStack)input, type, src);
        }

        public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
            if (!this.filter.isListed((IAEStack)request)) {
                return null;
            }
            return (IAEItemStack)this.rawInventory.extractItems((IAEStack)request, mode, src);
        }

        public IItemList<IAEItemStack> getAvailableItems(final IItemList<IAEItemStack> out) {
            return this.rawInventory.getAvailableItems((IItemList)new IItemList<IAEItemStack>(){

                public void addStorage(IAEItemStack option) {
                    if (filter.isListed((IAEStack)option)) {
                        out.addStorage((IAEStack)option);
                    }
                }

                public void addCrafting(IAEItemStack option) {
                    if (filter.isListed((IAEStack)option)) {
                        out.addCrafting((IAEStack)option);
                    }
                }

                public void addRequestable(IAEItemStack option) {
                    if (filter.isListed((IAEStack)option)) {
                        out.addRequestable((IAEStack)option);
                    }
                }

                public IAEItemStack getFirstItem() {
                    return (IAEItemStack)out.getFirstItem();
                }

                public int size() {
                    return out.size();
                }

                public Iterator<IAEItemStack> iterator() {
                    return out.iterator();
                }

                public void resetStatus() {
                    out.resetStatus();
                }

                public void add(IAEItemStack option) {
                    out.add((IAEStack)option);
                }

                public IAEItemStack findPrecise(IAEItemStack i) {
                    return (IAEItemStack)out.findPrecise((IAEStack)i);
                }

                public Collection<IAEItemStack> findFuzzy(IAEItemStack input, FuzzyMode fuzzy) {
                    return out.findFuzzy((IAEStack)input, fuzzy);
                }

                public boolean isEmpty() {
                    return out.isEmpty();
                }

                public void forEach(Consumer<? super IAEItemStack> action) {
                    out.forEach(action);
                }

                public Spliterator<IAEItemStack> spliterator() {
                    return out.spliterator();
                }
            });
        }

        public StorageChannel getChannel() {
            return this.rawInventory.getChannel();
        }
    }

    private static abstract class MEInventoryStackExtractor
    implements InventoryUtility.ItemStackExtractor {
        private MEInventoryStackExtractor() {
        }

        private static int extractFromMEInventory(IEnergySource source, IAEItemStack toExtract, boolean simulate, EntityPlayerMP player, IMEInventoryHandler<IAEItemStack> inv) {
            PlayerSource actionSource = new PlayerSource((EntityPlayer)player, null);
            IAEItemStack extracted = simulate ? (IAEItemStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, (BaseActionSource)actionSource) : AEApi.instance().storage().poweredExtraction(source, inv, toExtract, (BaseActionSource)actionSource);
            return Math.toIntExact(extracted == null ? 0L : extracted.getStackSize());
        }

        protected abstract Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> fromItem(ItemStack var1, EntityPlayerMP var2);

        public boolean isAPIImplemented(InventoryUtility.ItemStackExtractor.APIType type) {
            return type == InventoryUtility.ItemStackExtractor.APIType.EXTRACT_ONE_STACK || type == InventoryUtility.ItemStackExtractor.APIType.MAIN;
        }

        public int takeFromStack(Predicate<ItemStack> predicate, boolean simulate, int count, InventoryUtility.ItemStackCounter store, ItemStack source, ItemStack filter, EntityPlayerMP player) {
            if (source == null || source.field_77994_a <= 0) {
                return 0;
            }
            Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> pair = this.fromItem(source, player);
            if (pair == null) {
                return 0;
            }
            IEnergySource energy = (IEnergySource)pair.getLeft();
            IMEInventoryHandler cellInventory = (IMEInventoryHandler)pair.getRight();
            IItemList items = cellInventory.getAvailableItems(AEApi.instance().storage().createPrimitiveItemList());
            count = Math.min(count, (int)energy.extractAEPower((double)count, Actionable.SIMULATE, PowerMultiplier.ONE));
            int found = 0;
            for (IAEItemStack stackAE : items) {
                IAEItemStack toExtract;
                int extracted;
                ItemStack stack = stackAE.getItemStack();
                if (!predicate.test(stack) || (extracted = MEInventoryStackExtractor.extractFromMEInventory(energy, toExtract = (IAEItemStack)stackAE.copy().setStackSize((long)(Math.min(count, found + stack.field_77994_a) - found)), simulate, player, (IMEInventoryHandler<IAEItemStack>)cellInventory)) == 0) continue;
                store.add(stack, extracted);
                if ((found += extracted) < count) continue;
                return found;
            }
            return found;
        }

        public int getItem(ItemStack source, ItemStack toExtract, boolean simulate, EntityPlayerMP player) {
            if (source == null || source.field_77994_a <= 0) {
                return 0;
            }
            Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> pair = this.fromItem(source, player);
            if (pair == null) {
                return 0;
            }
            return MEInventoryStackExtractor.extractFromMEInventory((IEnergySource)pair.getLeft(), AEApi.instance().storage().createItemStack(toExtract), simulate, player, (IMEInventoryHandler<IAEItemStack>)((IMEInventoryHandler)pair.getRight()));
        }
    }
}

