/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import codechicken.nei.api.API;
import codechicken.nei.event.NEIConfigsLoadedEvent;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.fx.HighlighterHandler;
import com.gtnh.findit.fx.SlotHighlighter;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import com.gtnh.findit.service.itemfinder.ItemFindService;
import com.gtnh.findit.service.itemfinder.ItemFoundResponse;
import com.gtnh.findit.util.AbstractStackFinder;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientItemFindService
extends ItemFindService {
    private final SlotHighlighter slotHighlighter;
    private FindItemRequest request = null;
    private long expirationTime = 0L;

    public ClientItemFindService() {
        if (!FindIt.isExtraUtilitiesLoaded()) {
            API.addHashBind((String)"gui.findit.find_item", (int)20);
        }
        this.slotHighlighter = new SlotHighlighter();
        GuiContainerManager.addDrawHandler((IContainerDrawHandler)this.slotHighlighter);
        GuiContainerManager.addInputHandler((IContainerInputHandler)new ItemFindInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiListener());
        MinecraftForge.EVENT_BUS.register((Object)new NEIEventListener());
        FMLCommonHandler.instance().bus().register((Object)new TickListener());
    }

    public void handleResponse(EntityClientPlayerMP player, ItemFoundResponse response) {
        this.slotHighlighter.highlightSlots(null, new HashSet<Slot>(), -30938);
        this.request = response.getFoundStack() != null ? new FindItemRequest(response.getFoundStack()) : null;
        this.expirationTime = System.currentTimeMillis() + (long)(FindItConfig.ITEM_HIGHLIGHTING_DURATION * 1000);
    }

    public static ClientItemFindService getInstance() {
        return (ClientItemFindService)FindIt.getItemFindService();
    }

    private static class ItemFindInputHandler
    extends AbstractStackFinder {
        private ItemFindInputHandler() {
        }

        @Override
        protected String getKeyBindId() {
            return FindIt.isExtraUtilitiesLoaded() ? "gui.xu_ping" : "gui.findit.find_item";
        }

        @Override
        protected boolean findStack(ItemStack stack) {
            FindItNetwork.CHANNEL.sendToServer((IMessage)new FindItemRequest(stack));
            return true;
        }
    }

    public class GuiListener {
        @SubscribeEvent
        public void renderWorldLastEvent(RenderWorldLastEvent event) {
            HighlighterHandler.renderHilightedBlock(event);
        }
    }

    public static class NEIEventListener {
        @SubscribeEvent
        public void onNEIConfigsLoaded(NEIConfigsLoadedEvent event) {
            if (FindIt.isExtraUtilitiesLoaded()) {
                GuiContainerManager.inputHandlers.removeIf(inputHandler -> inputHandler.getClass().getName().equals("com.rwtema.extrautils.nei.ping.NEIPing"));
            }
        }
    }

    public class TickListener {
        @SubscribeEvent
        public void onClientPostTick(TickEvent.ClientTickEvent event) {
            if (ClientItemFindService.this.request == null || event.phase != TickEvent.Phase.END) {
                return;
            }
            if (Minecraft.func_71410_x().field_71441_e == null) {
                return;
            }
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (!(screen instanceof GuiContainer)) {
                return;
            }
            GuiContainer gui = (GuiContainer)screen;
            HashSet<Slot> highlightedSlots = new HashSet<Slot>();
            if (System.currentTimeMillis() > ClientItemFindService.this.expirationTime) {
                ClientItemFindService.this.request = null;
            }
            if (ClientItemFindService.this.request != null) {
                List slots = gui.field_147002_h.field_75151_b;
                for (Slot slot : slots) {
                    if (slot.field_75224_c instanceof InventoryPlayer || !ClientItemFindService.this.request.equals(slot.func_75211_c())) continue;
                    highlightedSlots.add(slot);
                    if (highlightedSlots.size() <= 256) continue;
                    break;
                }
            }
            ClientItemFindService.this.slotHighlighter.highlightSlots(gui, highlightedSlots, -30938);
        }
    }
}

