/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.inventory.IApiaryInventory;
import java.util.ArrayList;
import java.util.Collection;
import magicbees.bees.BeeManager;
import magicbees.main.utils.ItemStackUtils;
import magicbees.tileentity.TileEntityMagicApiary;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MagicApiaryInventory
implements IApiaryInventory {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_FRAME_START = 2;
    public static final int SLOT_FRAME_COUNT = 3;
    public static final int SLOT_PRODUCTS_START = 5;
    public static final int SLOT_PRODUCTS_COUNT = 7;
    private final TileEntityMagicApiary magicApiary;
    private final ItemStack[] items;

    public MagicApiaryInventory(TileEntityMagicApiary magicApiary) {
        this.magicApiary = magicApiary;
        this.items = new ItemStack[12];
    }

    public ItemStack getQueen() {
        return this.magicApiary.func_70301_a(0);
    }

    public ItemStack getDrone() {
        return this.magicApiary.func_70301_a(1);
    }

    public void setQueen(ItemStack itemstack) {
        this.magicApiary.func_70299_a(0, itemstack);
    }

    public void setDrone(ItemStack itemstack) {
        this.magicApiary.func_70299_a(1, itemstack);
    }

    public boolean addProduct(ItemStack product, boolean all) {
        int countAdded = ItemStackUtils.addItemToInventory((IInventory)this.magicApiary, product, 5, 7);
        if (all) {
            return countAdded == product.field_77994_a;
        }
        return countAdded > 0;
    }

    public int getSizeInventory() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int i) {
        return this.items[i];
    }

    public void setInventorySlotContents(int i, ItemStack itemStack) {
        this.items[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.getInventoryStackLimit()) {
            itemStack.field_77994_a = this.getInventoryStackLimit();
        }
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (side == 0 || side == 1) {
            return new int[]{0, 1};
        }
        int[] slots = new int[7];
        int slot = 5;
        for (int i = 0; i < 7; ++i) {
            slots[i] = slot++;
        }
        return slots;
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int side) {
        if (slot == 0 && BeeManager.beeRoot.isMember(itemStack) && !BeeManager.beeRoot.isDrone(itemStack)) {
            return true;
        }
        if (slot == 1 && BeeManager.beeRoot.isDrone(itemStack)) {
            return true;
        }
        return slot == 1 && BeeManager.beeRoot.isDrone(itemStack);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return slot >= 2 && slot <= 4;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public Collection<IHiveFrame> getFrames() {
        ArrayList<IHiveFrame> hiveFrames = new ArrayList<IHiveFrame>(3);
        for (int i = 2; i < 5; ++i) {
            Item itemInSlot;
            ItemStack stackInSlot = this.magicApiary.func_70301_a(i);
            if (stackInSlot == null || !((itemInSlot = stackInSlot.func_77973_b()) instanceof IHiveFrame)) continue;
            hiveFrames.add((IHiveFrame)itemInSlot);
        }
        return hiveFrames;
    }

    public void wearOutFrames(IBeeHousing beeHousing, int amount) {
        IBeekeepingMode beekeepingMode = BeeManager.beeRoot.getBeekeepingMode(this.magicApiary.func_145831_w());
        int wear = Math.round((float)amount * beekeepingMode.getWearModifier());
        for (int i = 2; i < 5; ++i) {
            Item hiveFrameItem;
            ItemStack hiveFrameStack = this.magicApiary.func_70301_a(i);
            if (hiveFrameStack == null || !((hiveFrameItem = hiveFrameStack.func_77973_b()) instanceof IHiveFrame)) continue;
            IHiveFrame hiveFrame = (IHiveFrame)hiveFrameItem;
            ItemStack queenStack = this.magicApiary.getBeeInventory().getQueen();
            IBee queen = BeeManager.beeRoot.getMember(queenStack);
            ItemStack usedFrame = hiveFrame.frameUsed((IBeeHousing)this.magicApiary, hiveFrameStack, queen, wear);
            this.magicApiary.func_70299_a(i, usedFrame);
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList itemsNBT = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack itemStack = this.items[i];
            if (itemStack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            itemStack.func_77955_b(item);
            itemsNBT.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Items", (NBTBase)itemsNBT);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList items = compound.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.getSizeInventory()) continue;
            this.setInventorySlotContents(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }
}

