/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.render;

import com.gtnewhorizons.gtnhintergalactic.GTNHIntergalactic;
import com.gtnewhorizons.gtnhintergalactic.block.BlockSpaceElevatorCable;
import com.gtnewhorizons.gtnhintergalactic.config.Config;
import com.gtnewhorizons.gtnhintergalactic.tile.TileEntitySpaceElevatorCable;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderSpaceElevatorCable
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private static final ResourceLocation climberTexture = new ResourceLocation("gtnhintergalactic", "textures/models/climber.png");
    private static IModelCustom modelCustom;
    private static final int CLIMBER_OFFSET = 50;
    private static final int MIN_CLIMBER_HEIGHT = 100;
    private static final float LONG_DISTANCE;
    private static final float SHORT_DISTANCE = 0.18518518f;
    private static final double CABLE_HEIGHT = 512.0;
    private static final float[] edgeX;
    private static final float[] edgeZ;

    public RenderSpaceElevatorCable() {
        modelCustom = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("gtnhintergalactic", "models/climber.obj"));
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!Config.isCableRenderingEnabled) {
            return;
        }
        if (!(tile instanceof TileEntitySpaceElevatorCable)) {
            return;
        }
        TileEntitySpaceElevatorCable cableTile = (TileEntitySpaceElevatorCable)tile;
        if (!cableTile.shouldRender()) {
            return;
        }
        GL11.glPushMatrix();
        this.renderCable(x, y, z);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5 + (double)cableTile.getClimberHeight() + (double)(50 + cableTile.field_145848_d < 100 ? 100 : 50)), (double)(z + 0.5));
        GL11.glRotated((double)cableTile.getClimberRotation(), (double)0.0, (double)1.0, (double)0.0);
        this.renderClimber();
        GL11.glPopMatrix();
    }

    private void renderClimber() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147499_a(climberTexture);
        GL11.glScaled((double)4.0, (double)4.0, (double)4.0);
        modelCustom.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
    }

    private void renderCable(double x, double y, double z) {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderFullHelix(tessellator, x, y, z);
        GL11.glDisable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glPushMatrix();
        IIcon side = BlockSpaceElevatorCable.textures[0];
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySpaceElevatorCable && !((TileEntitySpaceElevatorCable)te).shouldRender()) {
            GL11.glPushMatrix();
            IIcon side = BlockSpaceElevatorCable.textures[0];
            float minU = side.func_94209_e();
            float maxU = side.func_94212_f();
            float minV = side.func_94206_g();
            float maxV = side.func_94210_h();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78374_a((double)x, (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)minU, (double)maxV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)minU, (double)maxV);
            GL11.glPopMatrix();
            return true;
        }
        return false;
    }

    private void motorGlow(Tessellator tes, double x, double y, double z, double minU, double maxU, double minV, double maxV) {
        tes.func_78374_a(x + 0.5 - (double)2.51f, y - 22.0, z + 0.5 + 0.5, minU, maxV);
        tes.func_78374_a(x + 0.5 - (double)2.51f, y + 0.5 + 0.5, z + 0.5 + 0.5, minU, minV);
        tes.func_78374_a(x + 0.5 - (double)2.51f, y + 0.5 + 0.5, z + 0.5 - 0.5, maxU, minV);
        tes.func_78374_a(x + 0.5 - (double)2.51f, y - 22.0, z + 0.5 - 0.5, maxU, maxV);
        tes.func_78374_a(x + 0.5 + (double)2.51f, y - 22.0, z + 0.5 - 0.5, minU, maxV);
        tes.func_78374_a(x + 0.5 + (double)2.51f, y + 0.5 + 0.5, z + 0.5 - 0.5, minU, minV);
        tes.func_78374_a(x + 0.5 + (double)2.51f, y + 0.5 + 0.5, z + 0.5 + 0.5, maxU, minV);
        tes.func_78374_a(x + 0.5 + (double)2.51f, y - 22.0, z + 0.5 + 0.5, maxU, maxV);
        tes.func_78374_a(x + 0.5 + 0.5, y - 22.0, z + 0.5 + (double)2.51f, minU, maxV);
        tes.func_78374_a(x + 0.5 + 0.5, y + 0.5 + 0.5, z + 0.5 + (double)2.51f, minU, minV);
        tes.func_78374_a(x + 0.5 - 0.5, y + 0.5 + 0.5, z + 0.5 + (double)2.51f, maxU, minV);
        tes.func_78374_a(x + 0.5 - 0.5, y - 22.0, z + 0.5 + (double)2.51f, maxU, maxV);
        tes.func_78374_a(x + 0.5 - 0.5, y - 22.0, z + 0.5 - (double)2.51f, minU, maxV);
        tes.func_78374_a(x + 0.5 - 0.5, y + 0.5 + 0.5, z + 0.5 - (double)2.51f, minU, minV);
        tes.func_78374_a(x + 0.5 + 0.5, y + 0.5 + 0.5, z + 0.5 - (double)2.51f, maxU, minV);
        tes.func_78374_a(x + 0.5 + 0.5, y - 22.0, z + 0.5 - (double)2.51f, maxU, maxV);
    }

    private void clockwiseHelixPart(Tessellator tes, double x, double y, double z, int offset, double side, double width, double minU, double maxU, double minV, double maxV) {
        double sectionHeight = 8.0 * side;
        int sections = (int)Math.ceil(512.0 / sectionHeight);
        for (int i = 0; i < 8 * sections; ++i) {
            int j = (i + offset) % 8;
            int k = (i + 1 + offset) % 8;
            if (i % 4 == 0) {
                IIcon cableLight = BlockSpaceElevatorCable.textures[2 + i / 4 % 80];
                GTNHIntergalactic.instance.markTextureUsed(cableLight);
                double lightMinU = cableLight.func_94209_e();
                double lightMaxU = cableLight.func_94212_f();
                double lightMinV = cableLight.func_94206_g();
                double lightMaxV = cableLight.func_94210_h();
                tes.func_78374_a(x + 0.5 + (double)edgeX[k], y + side * (double)i + side, z + 0.5 + (double)edgeZ[k], lightMinU, lightMaxV);
                tes.func_78374_a(x + 0.5 + (double)edgeX[k], y + side * (double)i + (side + width), z + 0.5 + (double)edgeZ[k], lightMinU, lightMinV);
                tes.func_78374_a(x + 0.5 + (double)edgeX[j], y + side * (double)i + width, z + 0.5 + (double)edgeZ[j], lightMaxU, lightMinV);
                tes.func_78374_a(x + 0.5 + (double)edgeX[j], y + side * (double)i, z + 0.5 + (double)edgeZ[j], lightMaxU, lightMaxV);
            } else {
                tes.func_78374_a(x + 0.5 + (double)edgeX[k], y + side * (double)i + side, z + 0.5 + (double)edgeZ[k], minU, maxV);
                tes.func_78374_a(x + 0.5 + (double)edgeX[k], y + side * (double)i + (side + width), z + 0.5 + (double)edgeZ[k], minU, minV);
                tes.func_78374_a(x + 0.5 + (double)edgeX[j], y + side * (double)i + width, z + 0.5 + (double)edgeZ[j], maxU, minV);
                tes.func_78374_a(x + 0.5 + (double)edgeX[j], y + side * (double)i, z + 0.5 + (double)edgeZ[j], maxU, maxV);
            }
            tes.func_78374_a(x + 0.5 + (double)edgeX[j], y + side * (double)i, z + 0.5 + (double)edgeZ[j], maxU, maxV);
            tes.func_78374_a(x + 0.5 + (double)edgeX[j], y + side * (double)i + width, z + 0.5 + (double)edgeZ[j], maxU, minV);
            tes.func_78374_a(x + 0.5 + (double)edgeX[k], y + side * (double)i + (side + width), z + 0.5 + (double)edgeZ[k], minU, minV);
            tes.func_78374_a(x + 0.5 + (double)edgeX[k], y + side * (double)i + side, z + 0.5 + (double)edgeZ[k], minU, maxV);
        }
    }

    private void renderFullHelix(Tessellator tes, double x, double y, double z) {
        this.func_147499_a(TextureMap.field_110575_b);
        IIcon cablePart = BlockSpaceElevatorCable.textures[0];
        IIcon motorGlow = BlockSpaceElevatorCable.motorGlow;
        double minU = cablePart.func_94209_e();
        double maxU = cablePart.func_94212_f();
        double minV = cablePart.func_94206_g();
        double maxV = cablePart.func_94210_h();
        double motorGlowMinU = motorGlow.func_94209_e();
        double motorGlowMaxU = motorGlow.func_94212_f();
        double motorGlowMinV = motorGlow.func_94206_g();
        double motorGlowMaxV = motorGlow.func_94210_h();
        tes.func_78382_b();
        this.clockwiseHelixPart(tes, x, y - 23.0, z, 0, 0.37037037037037035, 0.75, minU, maxU, minV, maxV);
        tes.func_78381_a();
        tes.func_78382_b();
        this.clockwiseHelixPart(tes, x, y - 23.0, z, 2, 0.37037037037037035, 0.75, minU, maxU, minV, maxV);
        tes.func_78381_a();
        tes.func_78382_b();
        this.clockwiseHelixPart(tes, x, y - 23.0, z, 4, 0.37037037037037035, 0.75, minU, maxU, minV, maxV);
        tes.func_78381_a();
        tes.func_78382_b();
        this.clockwiseHelixPart(tes, x, y - 23.0, z, 6, 0.37037037037037035, 0.75, minU, maxU, minV, maxV);
        tes.func_78381_a();
        tes.func_78382_b();
        this.motorGlow(tes, x, y, z, motorGlowMinU, motorGlowMaxU, motorGlowMinV, motorGlowMaxV);
        tes.func_78381_a();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockSpaceElevatorCable.getRenderID();
    }

    static {
        LONG_DISTANCE = (float)(1.0 + Math.sqrt(2.0)) / 5.4f;
        edgeX = new float[]{LONG_DISTANCE, LONG_DISTANCE, 0.18518518f, -0.18518518f, -LONG_DISTANCE, -LONG_DISTANCE, -0.18518518f, 0.18518518f};
        edgeZ = new float[]{0.18518518f, -0.18518518f, -LONG_DISTANCE, -LONG_DISTANCE, -0.18518518f, 0.18518518f, LONG_DISTANCE, LONG_DISTANCE};
    }
}

