/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network.old;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import travellersgear.TravellersGear;
import travellersgear.api.TravellersGearAPI;
import travellersgear.client.ToolDisplayInfo;
import travellersgear.common.network.old.AbstractPacket;

public class PacketPlayerInventorySync
extends AbstractPacket {
    int playerid;
    int[] targetedSlots;
    ItemStack[] items;

    public PacketPlayerInventorySync() {
    }

    public PacketPlayerInventorySync(EntityPlayer player) {
        int i;
        this.playerid = player.func_145782_y();
        NBTTagList list = TravellersGearAPI.getDisplayTools(player);
        this.targetedSlots = new int[list.func_74745_c()];
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.targetedSlots[i] = ToolDisplayInfo.readFromNBT((NBTTagCompound)list.func_150305_b((int)i)).slot;
        }
        this.items = new ItemStack[this.targetedSlots.length];
        for (i = 0; i < this.items.length; ++i) {
            this.items[i] = player.field_71071_by.field_70462_a[this.targetedSlots[i]];
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int i;
        buffer.writeInt(this.playerid);
        buffer.writeInt(this.targetedSlots.length);
        for (i = 0; i < this.targetedSlots.length; ++i) {
            buffer.writeInt(this.targetedSlots[i]);
        }
        for (i = 0; i < this.targetedSlots.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.items[i]);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int i;
        this.playerid = buffer.readInt();
        int l = buffer.readInt();
        this.targetedSlots = new int[l];
        for (i = 0; i < l; ++i) {
            this.targetedSlots[i] = buffer.readInt();
        }
        this.items = new ItemStack[l];
        for (i = 0; i < l; ++i) {
            this.items[i] = ByteBufUtils.readItemStack((ByteBuf)buffer);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer p) {
        World world = TravellersGear.proxy.getClientWorld();
        if (world == null) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        for (int i = 0; i < this.targetedSlots.length; ++i) {
            ((EntityPlayer)player).field_71071_by.field_70462_a[this.targetedSlots[i]] = this.items[i];
        }
    }

    @Override
    public void handleServerSide(EntityPlayer p) {
    }
}

