/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import com.sinthoras.visualprospecting.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.integration.vp.VPIntegration;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.io.Bits;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.shadow.it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import serverutils.shadow.it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;

public class MessageJourneyMapUpdate
extends MessageToClient {
    public int minX;
    public int maxX;
    public int minZ;
    public int maxZ;
    public Short2ObjectMap<ClientClaimedChunks.Team> teams;

    public MessageJourneyMapUpdate() {
    }

    public MessageJourneyMapUpdate(int mix, int mx, int miz, int mz, EntityPlayer player) {
        this.minX = Utils.coordBlockToChunk((int)mix);
        this.maxX = Utils.coordBlockToChunk((int)mx);
        this.minZ = Utils.coordBlockToChunk((int)miz);
        this.maxZ = Utils.coordBlockToChunk((int)mz);
        ForgePlayer p = Universe.get().getPlayer((ICommandSender)player);
        this.teams = new Short2ObjectOpenHashMap<ClientClaimedChunks.Team>();
        boolean canSeeChunkInfo = PermissionAPI.hasPermission(player, "serverutilities.other_player.claims.see_info");
        boolean canSeeOtherJourneymap = PermissionAPI.hasPermission(player, "serverutilities.journeymap.other");
        for (int chunkX = this.minX; chunkX <= this.maxX; ++chunkX) {
            for (int chunkZ = this.minZ; chunkZ <= this.maxZ; ++chunkZ) {
                ForgeTeam chunkTeam;
                ClaimedChunk chunk = ClaimedChunks.instance.getChunk(new ChunkDimPos(chunkX, chunkZ, player.field_71093_bK));
                if (chunk == null || !(chunkTeam = chunk.getTeam()).isValid() || !canSeeOtherJourneymap && !p.team.equalsTeam(chunkTeam)) continue;
                ClientClaimedChunks.Team team = (ClientClaimedChunks.Team)this.teams.get(chunkTeam.getUID());
                boolean member = chunkTeam.isMember(p);
                int flags = 0;
                if (team == null) {
                    team = new ClientClaimedChunks.Team(chunkTeam.getUID());
                    team.color = chunkTeam.getColor();
                    team.nameComponent = chunkTeam.getTitle();
                    team.isAlly = chunkTeam.isAlly(p);
                    team.isMember = member;
                    this.teams.put(chunkTeam.getUID(), team);
                }
                if ((canSeeChunkInfo || member) && chunk.isLoaded()) {
                    flags = Bits.setFlag(flags, 1, true);
                }
                team.chunkPos.put(chunk.getPos(), new ClientClaimedChunks.ChunkData(team, flags));
            }
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.teams.values(), ClientClaimedChunks.Team.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.teams = new Short2ObjectOpenHashMap<ClientClaimedChunks.Team>();
        for (ClientClaimedChunks.Team team : data.readCollection(ClientClaimedChunks.Team.DESERIALIZER)) {
            this.teams.put(team.uid, team);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        VPIntegration.updateMap(this);
    }
}

