/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import serverutils.command.CmdEditNBT;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.BlockUtils;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageEditNBTResponse
extends MessageToServer {
    private NBTTagCompound info;
    private NBTTagCompound mainNbt;

    public MessageEditNBTResponse() {
    }

    public MessageEditNBTResponse(NBTTagCompound i, NBTTagCompound nbt) {
        this.info = i;
        this.mainNbt = nbt;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeNBT(this.info);
        data.writeNBT(this.mainNbt);
    }

    @Override
    public void readData(DataIn data) {
        this.info = data.readNBT();
        this.mainNbt = data.readNBT();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (CmdEditNBT.EDITING.get(player.func_146103_bH().getId()).equals((Object)this.info)) {
            CmdEditNBT.EDITING.remove(player.func_146103_bH().getId());
            switch (this.info.func_74779_i("type")) {
                case "player": {
                    ForgePlayer player1 = Universe.get().getPlayer(this.info.func_74779_i("id"));
                    if (player1 == null) break;
                    player1.setPlayerNBT(this.mainNbt);
                    break;
                }
                case "block": {
                    TileEntity tile;
                    int x = this.info.func_74762_e("x");
                    int y = this.info.func_74762_e("y");
                    int z = this.info.func_74762_e("z");
                    if (!player.field_70170_p.func_72863_F().func_73149_a(x << 4, z << 4) || (tile = player.field_70170_p.func_147438_o(x, y, z)) == null) break;
                    this.mainNbt.func_74768_a("x", x);
                    this.mainNbt.func_74768_a("y", y);
                    this.mainNbt.func_74768_a("z", z);
                    this.mainNbt.func_74778_a("id", this.info.func_74779_i("id"));
                    tile.func_145839_a(this.mainNbt);
                    tile.func_70296_d();
                    BlockUtils.notifyBlockUpdate(tile.func_145831_w(), x, y, z, null);
                    break;
                }
                case "entity": {
                    Entity entity = player.field_70170_p.func_73045_a(this.info.func_74762_e("id"));
                    if (entity == null) break;
                    entity.func_70020_e(this.mainNbt);
                    if (!entity.func_70089_S()) break;
                    player.field_70170_p.func_72866_a(entity, true);
                    break;
                }
                case "item": {
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)this.mainNbt);
                    player.func_70062_b(0, stack);
                }
            }
        }
    }
}

