/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.math;

import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.MathUtils;

public final class ChunkDimPos {
    public final int posX;
    public final int posZ;
    public final int dim;

    public ChunkDimPos(int x, int z, int d) {
        this.posX = x;
        this.posZ = z;
        this.dim = d;
    }

    public ChunkDimPos(ChunkCoordIntPair pos, int d) {
        this(pos.field_77276_a, pos.field_77275_b, d);
    }

    public ChunkDimPos(int posx, int posy, int posz, int d) {
        this(MathUtils.chunk(posx), MathUtils.chunk(posz), d);
    }

    public ChunkDimPos(Entity entity) {
        this(MathUtils.chunk(entity.field_70165_t), MathUtils.chunk(entity.field_70161_v), entity.field_70170_p.field_73011_w.field_76574_g);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ChunkDimPos) {
            return this.equalsChunkDimPos((ChunkDimPos)o);
        }
        return false;
    }

    public boolean equalsChunkDimPos(ChunkDimPos p) {
        return p == this || p.dim == this.dim && p.posX == this.posX && p.posZ == this.posZ;
    }

    public String toString() {
        return "[" + this.dim + '@' + this.posX + ',' + this.posZ + ']';
    }

    public int hashCode() {
        return 31 * (31 * this.posX + this.posZ) + this.dim;
    }

    public ChunkCoordIntPair getChunkPos() {
        return new ChunkCoordIntPair(this.posX, this.posZ);
    }

    public int getBlockX() {
        return (this.posX << 4) + 8;
    }

    public int getBlockZ() {
        return (this.posZ << 4) + 8;
    }

    public BlockDimPos getBlockPos(int y) {
        return new BlockDimPos(this.getBlockX(), y, this.getBlockZ(), this.dim);
    }
}

