/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import serverutils.client.EnumSidebarLocation;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.SidebarButtonGroup;
import serverutils.lib.OtherMods;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.misc.GuiLoading;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.ChainedBooleanSupplier;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.SidedUtils;

public class SidebarButton
implements Comparable<SidebarButton> {
    public static final BooleanSupplier NEI_NOT_LOADED = () -> !OtherMods.isNEILoaded();
    public final ResourceLocation id;
    public final SidebarButtonGroup group;
    private Icon icon = Icon.EMPTY;
    private int x = 0;
    private boolean defaultConfig = true;
    private boolean configValue = true;
    private final List<String> clickEvents = new ArrayList<String>();
    private final List<String> shiftClickEvents = new ArrayList<String>();
    private final boolean loadingScreen;
    private ChainedBooleanSupplier visible = ChainedBooleanSupplier.TRUE;
    private Supplier<String> customTextHandler = null;
    private Consumer<List<String>> tooltipHandler = null;

    public SidebarButton(ResourceLocation _id, SidebarButtonGroup g, JsonObject json) {
        this.group = g;
        this.id = _id;
        if (json.has("icon")) {
            this.icon = Icon.getIcon(json.get("icon"));
        }
        if (this.icon.isEmpty()) {
            this.icon = GuiIcons.ACCEPT_GRAY;
        }
        if (json.has("click")) {
            for (JsonElement e : JsonUtils.toArray(json.get("click"))) {
                if (e.isJsonPrimitive()) {
                    this.clickEvents.add(e.getAsString());
                    continue;
                }
                this.clickEvents.add(GuiHelper.clickEventToString(JsonUtils.deserializeClickEvent(e)));
            }
        }
        if (json.has("shift_click")) {
            for (JsonElement e : JsonUtils.toArray(json.get("shift_click"))) {
                if (e.isJsonPrimitive()) {
                    this.shiftClickEvents.add(e.getAsString());
                    continue;
                }
                this.shiftClickEvents.add(GuiHelper.clickEventToString(JsonUtils.deserializeClickEvent(e)));
            }
        }
        if (json.has("config")) {
            this.defaultConfig = this.configValue = json.get("config").getAsBoolean();
        }
        if (json.has("x")) {
            this.x = json.get("x").getAsInt();
        }
        if (json.has("requires_op") && json.get("requires_op").getAsBoolean()) {
            this.addVisibilityCondition(ClientUtils.IS_CLIENT_OP);
        }
        if (json.has("hide_with_nei") && json.get("hide_with_nei").getAsBoolean()) {
            this.addVisibilityCondition(NEI_NOT_LOADED);
        }
        if (json.has("hide_if_server_disabled") && json.get("hide_if_server_disabled").getAsBoolean()) {
            this.addVisibilityCondition(() -> SidedUtils.isButtonEnabledOnServer(this.id));
        }
        if (json.has("required_server_mods")) {
            LinkedHashSet<String> requiredServerMods = new LinkedHashSet<String>();
            for (JsonElement e : JsonUtils.toArray(json.get("required_server_mods"))) {
                requiredServerMods.add(e.getAsString());
            }
            this.addVisibilityCondition(() -> SidedUtils.areAllModsLoadedOnServer(requiredServerMods));
        }
        this.loadingScreen = json.has("loading_screen") && json.get("loading_screen").getAsBoolean();
    }

    public void addVisibilityCondition(BooleanSupplier supplier) {
        this.visible = this.visible.and(supplier);
    }

    public String getLangKey() {
        return "sidebar_button." + this.id.func_110624_b() + '.' + this.id.func_110623_a();
    }

    public String getTooltipLangKey() {
        return this.getLangKey() + ".tooltip";
    }

    public String toString() {
        return this.id.toString();
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof SidebarButton)) return false;
        SidebarButton button = (SidebarButton)o;
        if (!this.id.equals((Object)button.id)) return false;
        return true;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public boolean getDefaultConfig() {
        return this.defaultConfig;
    }

    public void onClicked(boolean shift) {
        if (this.loadingScreen) {
            new GuiLoading(I18n.func_135052_a((String)this.getLangKey(), (Object[])new Object[0])).openGui();
        }
        for (String event : shift && !this.shiftClickEvents.isEmpty() ? this.shiftClickEvents : this.clickEvents) {
            GuiHelper.BLANK_GUI.handleClick(event);
        }
    }

    public boolean isActuallyVisible() {
        return this.configValue && ServerUtilitiesClientConfig.sidebar_buttons != EnumSidebarLocation.DISABLED && this.isVisible();
    }

    public boolean isVisible() {
        return this.visible.getAsBoolean();
    }

    public boolean getConfig() {
        return this.configValue;
    }

    public void setConfig(boolean value) {
        this.configValue = value;
    }

    @Nullable
    public Supplier<String> getCustomTextHandler() {
        return this.customTextHandler;
    }

    public void setCustomTextHandler(Supplier<String> text) {
        this.customTextHandler = text;
    }

    @Nullable
    public Consumer<List<String>> getTooltipHandler() {
        return this.tooltipHandler;
    }

    public void setTooltipHandler(Consumer<List<String>> text) {
        this.tooltipHandler = text;
    }

    @Override
    public int compareTo(SidebarButton button) {
        return this.getX() - button.getX();
    }
}

