/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.collections;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.objects.functions.consumer.ObjectLongConsumer;

public interface LongIterator
extends Iterator<Long> {
    public long nextLong();

    @Override
    @Deprecated
    default public Long next() {
        return this.nextLong();
    }

    default public void forEachRemaining(LongConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextLong());
        }
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Long> action) {
        Objects.requireNonNull(action);
        this.forEachRemaining(action::accept);
    }

    default public <E> void forEachRemaining(E input, ObjectLongConsumer<E> action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(input, this.nextLong());
        }
    }

    default public int skip(int amount) {
        int i;
        if (amount < 0) {
            throw new IllegalStateException("Negative Numbers are not allowed");
        }
        for (i = 0; i < amount && this.hasNext(); ++i) {
            this.nextLong();
        }
        return i;
    }
}

