/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.utils;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.RecursiveAction;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.functions.IntComparator;
import speiger.src.collections.ints.utils.IntCollections;
import speiger.src.collections.ints.utils.IntIterators;
import speiger.src.collections.utils.SanityChecks;

public class IntArrays {
    public static final int BASE_THRESHOLD = 16;
    public static final int PARALLEL_THRESHOLD = 8192;
    public static final int[] EMPTY_ARRAY = new int[0];

    public static Integer[] wrap(int[] a) {
        return IntArrays.wrap(a, 0, a.length);
    }

    public static Integer[] wrap(int[] a, int length) {
        return IntArrays.wrap(a, 0, length);
    }

    public static Integer[] wrap(int[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        Integer[] result = new Integer[length];
        for (int i = offset; i < length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static int[] unwrap(Integer[] a) {
        return IntArrays.unwrap(a, 0, a.length);
    }

    public static int[] unwrap(Integer[] a, int length) {
        return IntArrays.unwrap(a, 0, length);
    }

    public static int[] unwrap(Integer[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        int[] result = new int[length];
        for (int i = offset; i < length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static int[] pour(IntIterator iter) {
        return IntArrays.pour(iter, Integer.MAX_VALUE);
    }

    public static int[] pour(IntIterator iter, int max) {
        IntCollections.CollectionWrapper list = IntCollections.wrapper();
        IntIterators.pour(iter, list, max);
        return list.toIntArray(new int[list.size()]);
    }

    public static int shiftDown(int[] data, int size, int index, IntComparator comp) {
        int half = size >>> 1;
        int value = data[index];
        if (comp != null) {
            while (index < half) {
                int child = (index << 1) + 1;
                int childValue = data[child];
                int right = child + 1;
                if (right < size && comp.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (comp.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        } else {
            while (index < half) {
                int child = (index << 1) + 1;
                int childValue = data[child];
                int right = child + 1;
                if (right < size && Integer.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (Integer.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        }
        data[index] = value;
        return index;
    }

    public static int shiftUp(int[] data, int index, IntComparator comp) {
        int value = data[index];
        if (comp != null) {
            int parent;
            int parentValue;
            while (index > 0 && comp.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        } else {
            int parent;
            int parentValue;
            while (index > 0 && Integer.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        }
        data[index] = value;
        return index;
    }

    public static int[] heapify(int[] data, int size, IntComparator comp) {
        int i = (size >>> 1) - 1;
        while (i >= 0) {
            IntArrays.shiftDown(data, size, i--, comp);
        }
        return data;
    }

    public static int[] shuffle(int[] array) {
        return IntArrays.shuffle(array, SanityChecks.getRandom());
    }

    public static int[] shuffle(int[] array, int length) {
        return IntArrays.shuffle(array, 0, length, SanityChecks.getRandom());
    }

    public static int[] shuffle(int[] array, int offset, int length) {
        return IntArrays.shuffle(array, offset, length, SanityChecks.getRandom());
    }

    public static int[] shuffle(int[] array, Random random) {
        for (int i = array.length - 1; i >= 0; --i) {
            int p = random.nextInt(i + 1);
            int t = array[i];
            array[i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static int[] shuffle(int[] array, int length, Random random) {
        return IntArrays.shuffle(array, 0, length, random);
    }

    public static int[] shuffle(int[] array, int offset, int length, Random random) {
        for (int i = length - 1; i >= 0; --i) {
            int p = offset + random.nextInt(i + 1);
            int t = array[offset + i];
            array[offset + i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static int[] reverse(int[] array) {
        return IntArrays.reverse(array, 0, array.length);
    }

    public static int[] reverse(int[] array, int length) {
        return IntArrays.reverse(array, 0, length);
    }

    public static int[] reverse(int[] array, int offset, int length) {
        int i = offset;
        int mid = offset + length >> 1;
        int j = offset + length - 1;
        while (i < mid) {
            int temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
            --j;
        }
        return array;
    }

    public static int[] stableSort(int[] array, IntComparator comp) {
        IntArrays.stableSort(array, 0, array.length, comp);
        return array;
    }

    public static void stableSort(int[] array, int length, IntComparator comp) {
        IntArrays.stableSort(array, 0, length, comp);
    }

    public static void stableSort(int[] array, int from, int to, IntComparator comp) {
        IntArrays.mergeSort(array, null, from, to, comp);
    }

    public static int[] stableSort(int[] array) {
        IntArrays.stableSort(array, 0, array.length);
        return array;
    }

    public static void stableSort(int[] array, int length) {
        IntArrays.stableSort(array, 0, length);
    }

    public static void stableSort(int[] array, int from, int to) {
        IntArrays.mergeSort(array, null, from, to);
    }

    public static int[] unstableSort(int[] array, IntComparator comp) {
        IntArrays.unstableSort(array, 0, array.length, comp);
        return array;
    }

    public static void unstableSort(int[] array, int length, IntComparator comp) {
        IntArrays.unstableSort(array, 0, length, comp);
    }

    public static void unstableSort(int[] array, int from, int to, IntComparator comp) {
        IntArrays.quickSort(array, from, to, comp);
    }

    public static int[] unstableSort(int[] array) {
        IntArrays.unstableSort(array, 0, array.length);
        return array;
    }

    public static void unstableSort(int[] array, int length) {
        IntArrays.unstableSort(array, 0, length);
    }

    public static void unstableSort(int[] array, int from, int to) {
        IntArrays.quickSort(array, from, to);
    }

    public static int[] insertionSort(int[] array, IntComparator comp) {
        IntArrays.insertionSort(array, 0, array.length, comp);
        return array;
    }

    public static void insertionSort(int[] array, int length, IntComparator comp) {
        IntArrays.insertionSort(array, 0, length, comp);
    }

    public static void insertionSort(int[] array, int from, int to, IntComparator comp) {
        for (int i = from + 1; i < to; ++i) {
            int current = array[i];
            int j = i - 1;
            while (j >= from && comp.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static int[] insertionSort(int[] array) {
        IntArrays.insertionSort(array, 0, array.length);
        return array;
    }

    public static void insertionSort(int[] array, int length) {
        IntArrays.insertionSort(array, 0, length);
    }

    public static void insertionSort(int[] array, int from, int to) {
        for (int i = from + 1; i < to; ++i) {
            int current = array[i];
            int j = i - 1;
            while (j >= from && Integer.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static int[] selectionSort(int[] array, IntComparator comp) {
        IntArrays.selectionSort(array, 0, array.length, comp);
        return array;
    }

    public static void selectionSort(int[] array, int length, IntComparator comp) {
        IntArrays.selectionSort(array, 0, length, comp);
    }

    public static void selectionSort(int[] array, int from, int to, IntComparator comp) {
        for (int i = from; i < to; ++i) {
            int min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            int temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static int[] selectionSort(int[] array) {
        IntArrays.selectionSort(array, 0, array.length);
        return array;
    }

    public static void selectionSort(int[] array, int length) {
        IntArrays.selectionSort(array, 0, length);
    }

    public static void selectionSort(int[] array, int from, int to) {
        for (int i = from; i < to; ++i) {
            int min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (Integer.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            int temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static int[] mergeSort(int[] array, IntComparator comp) {
        IntArrays.mergeSort(array, null, 0, array.length, comp);
        return array;
    }

    public static void mergeSort(int[] array, int length, IntComparator comp) {
        IntArrays.mergeSort(array, null, 0, length, comp);
    }

    public static void mergeSort(int[] array, int[] supp, int from, int to, IntComparator comp) {
        if (to - from < 16) {
            IntArrays.insertionSort(array, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, array, from, mid, comp);
        IntArrays.mergeSort(supp, array, mid, to, comp);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && comp.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static int[] mergeSort(int[] array) {
        IntArrays.mergeSort(array, null, 0, array.length);
        return array;
    }

    public static void mergeSort(int[] array, int length) {
        IntArrays.mergeSort(array, null, 0, length);
    }

    public static void mergeSort(int[] array, int[] supp, int from, int to) {
        if (to - from < 16) {
            IntArrays.insertionSort(array, from, to);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, array, from, mid);
        IntArrays.mergeSort(supp, array, mid, to);
        if (Integer.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && Integer.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static void parallelMergeSort(int[] array, IntComparator comp) {
        IntArrays.parallelMergeSort(array, null, 0, array.length, comp);
    }

    public static void parallelMergeSort(int[] array, int length, IntComparator comp) {
        IntArrays.parallelMergeSort(array, null, 0, length, comp);
    }

    public static void parallelMergeSort(int[] array, int[] supp, int from, int to, IntComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortActionComp(array, supp, from, to, comp));
            return;
        }
        IntArrays.mergeSort(array, supp, from, to, comp);
    }

    public static void parallelMergeSort(int[] array) {
        IntArrays.parallelMergeSort(array, null, 0, array.length);
    }

    public static void parallelMergeSort(int[] array, int length) {
        IntArrays.parallelMergeSort(array, null, 0, length);
    }

    public static void parallelMergeSort(int[] array, int[] supp, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortAction(array, supp, from, to));
            return;
        }
        IntArrays.mergeSort(array, supp, from, to);
    }

    public static void memFreeMergeSort(int[] array, IntComparator comp) {
        IntArrays.memFreeMergeSort(array, 0, array.length, comp);
    }

    public static void memFreeMergeSort(int[] array, int length, IntComparator comp) {
        IntArrays.memFreeMergeSort(array, 0, length, comp);
    }

    public static void memFreeMergeSort(int[] array, int from, int to, IntComparator comp) {
        if (to - from < 16) {
            IntArrays.insertionSort(array, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        IntArrays.memFreeMergeSort(array, from, mid, comp);
        IntArrays.memFreeMergeSort(array, mid, to, comp);
        if (comp.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int compare = comp.compare(array[i], array[j]);
            if (compare < 0) {
                ++i;
                continue;
            }
            if (compare == 0) {
                IntArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && comp.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                IntArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                int value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            int[] data = new int[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static int[] memFreeMergeSort(int[] array) {
        IntArrays.memFreeMergeSort(array, 0, array.length);
        return array;
    }

    public static void memFreeMergeSort(int[] array, int length) {
        IntArrays.memFreeMergeSort(array, 0, length);
    }

    public static void memFreeMergeSort(int[] array, int from, int to) {
        if (to - from < 16) {
            IntArrays.insertionSort(array, from, to);
            return;
        }
        int mid = from + to >>> 1;
        IntArrays.memFreeMergeSort(array, from, mid);
        IntArrays.memFreeMergeSort(array, mid, to);
        if (Integer.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int comp = Integer.compare(array[i], array[j]);
            if (comp < 0) {
                ++i;
                continue;
            }
            if (comp == 0) {
                IntArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && Integer.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                IntArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                int value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            int[] data = new int[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static void parallelMemFreeMergeSort(int[] array, IntComparator comp) {
        IntArrays.parallelMemFreeMergeSort(array, 0, array.length, comp);
    }

    public static void parallelMemFreeMergeSort(int[] array, int length, IntComparator comp) {
        IntArrays.parallelMemFreeMergeSort(array, 0, length, comp);
    }

    public static void parallelMemFreeMergeSort(int[] array, int from, int to, IntComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortActionComp(array, from, to, comp));
            return;
        }
        IntArrays.memFreeMergeSort(array, from, to, comp);
    }

    public static void parallelMemFreeMergeSort(int[] array) {
        IntArrays.parallelMemFreeMergeSort(array, 0, array.length);
    }

    public static void parallelMemFreeMergeSort(int[] array, int length) {
        IntArrays.parallelMemFreeMergeSort(array, 0, length);
    }

    public static void parallelMemFreeMergeSort(int[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortAction(array, from, to));
            return;
        }
        IntArrays.memFreeMergeSort(array, from, to);
    }

    public static int[] quickSort(int[] array, IntComparator comp) {
        IntArrays.quickSort(array, 0, array.length, comp);
        return array;
    }

    public static void quickSort(int[] array, int length, IntComparator comp) {
        IntArrays.quickSort(array, 0, length, comp);
    }

    public static void quickSort(int[] array, int from, int to, IntComparator comp) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            IntArrays.selectionSort(array, from, to, comp);
            return;
        }
        int pivot = array[length > 128 ? IntArrays.subMedium(array, from, from + length / 2, to - 1, length / 8, comp) : IntArrays.medium(array, from, from + length / 2, to - 1, comp)];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int compare;
            if (b <= c && (compare = comp.compare(array[b], pivot)) <= 0) {
                if (compare == 0) {
                    IntArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (compare = comp.compare(array[c], pivot)) >= 0) {
                if (compare == 0) {
                    IntArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(array, b++, c--);
        }
        IntArrays.swap(array, from, b, Math.min(a - from, b - a));
        IntArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            IntArrays.quickSort(array, from, from + length, comp);
        }
        if ((length = d - c) > 1) {
            IntArrays.quickSort(array, to - length, to, comp);
        }
    }

    public static int[] quickSort(int[] array) {
        IntArrays.quickSort(array, 0, array.length);
        return array;
    }

    public static void quickSort(int[] array, int length) {
        IntArrays.quickSort(array, 0, length);
    }

    public static void quickSort(int[] array, int from, int to) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            IntArrays.selectionSort(array, from, to);
            return;
        }
        int pivot = array[length > 128 ? IntArrays.subMedium(array, from, from + length / 2, to - 1, length / 8) : IntArrays.medium(array, from, from + length / 2, to - 1)];
        int b = a = from;
        int d = c = to - 1;
        int comp = 0;
        while (true) {
            if (b <= c && (comp = Integer.compare(array[b], pivot)) <= 0) {
                if (comp == 0) {
                    IntArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Integer.compare(array[c], pivot)) >= 0) {
                if (comp == 0) {
                    IntArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(array, b++, c--);
        }
        IntArrays.swap(array, from, b, Math.min(a - from, b - a));
        IntArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            IntArrays.quickSort(array, from, from + length);
        }
        if ((length = d - c) > 1) {
            IntArrays.quickSort(array, to - length, to);
        }
    }

    public static void parallelQuickSort(int[] array, IntComparator comp) {
        IntArrays.parallelQuickSort(array, 0, array.length, comp);
    }

    public static void parallelQuickSort(int[] array, int length, IntComparator comp) {
        IntArrays.parallelQuickSort(array, 0, length, comp);
    }

    public static void parallelQuickSort(int[] array, int from, int to, IntComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortActionComp(array, from, to, comp));
            return;
        }
        IntArrays.quickSort(array, from, to, comp);
    }

    public static void parallelQuickSort(int[] array) {
        IntArrays.parallelQuickSort(array, 0, array.length);
    }

    public static void parallelQuickSort(int[] array, int length) {
        IntArrays.parallelQuickSort(array, 0, length);
    }

    public static void parallelQuickSort(int[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortAction(array, from, to));
            return;
        }
        IntArrays.quickSort(array, from, to);
    }

    static void swap(int[] a, int from, int to) {
        int t = a[from];
        a[from] = a[to];
        a[to] = t;
    }

    static void swap(int[] a, int from, int to, int length) {
        to -= length;
        for (int i = 0; i < length; ++i) {
            IntArrays.swap(a, from++, to++);
        }
    }

    static int subMedium(int[] data, int a, int b, int c, int length, IntComparator comp) {
        return IntArrays.medium(data, IntArrays.medium(data, a, a + length, a + length * 2, comp), IntArrays.medium(data, b - length, b, b + length, comp), IntArrays.medium(data, c - length * 2, c - length, c, comp), comp);
    }

    static int medium(int[] data, int a, int b, int c, IntComparator comp) {
        return comp.compare(data[a], data[b]) < 0 ? (comp.compare(data[b], data[c]) < 0 ? b : (comp.compare(data[a], data[c]) < 0 ? c : a)) : (comp.compare(data[b], data[c]) > 0 ? b : (comp.compare(data[a], data[c]) > 0 ? c : a));
    }

    static int subMedium(int[] data, int a, int b, int c, int length) {
        return IntArrays.medium(data, IntArrays.medium(data, a, a + length, a + length * 2), IntArrays.medium(data, b - length, b, b + length), IntArrays.medium(data, c - length * 2, c - length, c));
    }

    static int medium(int[] data, int a, int b, int c) {
        return Integer.compare(data[a], data[b]) < 0 ? (Integer.compare(data[b], data[c]) < 0 ? b : (Integer.compare(data[a], data[c]) < 0 ? c : a)) : (Integer.compare(data[b], data[c]) > 0 ? b : (Integer.compare(data[a], data[c]) > 0 ? c : a));
    }

    static class MemFreeMergeSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        int[] array;
        int from;
        int to;
        IntComparator comp;

        MemFreeMergeSortActionComp(int[] array, int from, int to, IntComparator comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                IntArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortActionComp.invokeAll(new MemFreeMergeSortActionComp(this.array, this.from, mid, this.comp), new MemFreeMergeSortActionComp(this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int compare = this.comp.compare(this.array[i], this.array[j]);
                if (compare < 0) {
                    ++i;
                    continue;
                }
                if (compare == 0) {
                    IntArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && this.comp.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    IntArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    int value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                int[] data = new int[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MemFreeMergeSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        int[] array;
        int from;
        int to;

        MemFreeMergeSortAction(int[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                IntArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortAction.invokeAll(new MemFreeMergeSortAction(this.array, this.from, mid), new MemFreeMergeSortAction(this.array, mid, this.to));
            if (Integer.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int comp = Integer.compare(this.array[i], this.array[j]);
                if (comp < 0) {
                    ++i;
                    continue;
                }
                if (comp == 0) {
                    IntArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && Integer.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    IntArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    int value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                int[] data = new int[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MergeSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        int[] array;
        int[] supp;
        int from;
        int to;
        IntComparator comp;

        MergeSortActionComp(int[] array, int[] supp, int from, int to, IntComparator comp) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                IntArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortActionComp.invokeAll(new MergeSortActionComp(this.supp, this.array, this.from, mid, this.comp), new MergeSortActionComp(this.supp, this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && this.comp.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class MergeSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        int[] array;
        int[] supp;
        int from;
        int to;

        MergeSortAction(int[] array, int[] supp, int from, int to) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                IntArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortAction.invokeAll(new MergeSortAction(this.supp, this.array, this.from, mid), new MergeSortAction(this.supp, this.array, mid, this.to));
            if (Integer.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && Integer.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class QuickSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        int[] array;
        int from;
        int to;
        IntComparator comp;

        QuickSortActionComp(int[] array, int from, int to, IntComparator comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                IntArrays.selectionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            int pivot = this.array[length > 128 ? IntArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8, this.comp) : IntArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1, this.comp)];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int compare;
                if (b <= c && (compare = this.comp.compare(this.array[b], pivot)) <= 0) {
                    if (compare == 0) {
                        IntArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (compare = this.comp.compare(this.array[c], pivot)) >= 0) {
                    if (compare == 0) {
                        IntArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                IntArrays.swap(this.array, b++, c--);
            }
            IntArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            IntArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortActionComp.invokeAll(new QuickSortActionComp(this.array, this.from, this.from + (b - a), this.comp), new QuickSortActionComp(this.array, this.to - (d - c), this.to, this.comp));
            } else if (b - a > 1) {
                new QuickSortActionComp(this.array, this.from, this.from + (b - a), this.comp).invoke();
            } else if (d - c > 1) {
                new QuickSortActionComp(this.array, this.to - (d - c), this.to, this.comp).invoke();
            }
        }
    }

    static class QuickSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        int[] array;
        int from;
        int to;

        QuickSortAction(int[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                IntArrays.selectionSort(this.array, this.from, this.to);
                return;
            }
            int pivot = this.array[length > 128 ? IntArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8) : IntArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1)];
            int b = a = this.from;
            int d = c = this.to - 1;
            int comp = 0;
            while (true) {
                if (b <= c && (comp = Integer.compare(this.array[b], pivot)) <= 0) {
                    if (comp == 0) {
                        IntArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comp = Integer.compare(this.array[c], pivot)) >= 0) {
                    if (comp == 0) {
                        IntArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                IntArrays.swap(this.array, b++, c--);
            }
            IntArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            IntArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortAction.invokeAll(new QuickSortAction(this.array, this.from, this.from + (b - a)), new QuickSortAction(this.array, this.to - (d - c), this.to));
            } else if (b - a > 1) {
                new QuickSortAction(this.array, this.from, this.from + (b - a)).invoke();
            } else if (d - c > 1) {
                new QuickSortAction(this.array, this.to - (d - c), this.to).invoke();
            }
        }
    }
}

