/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.maps.impl.misc;

import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import speiger.src.collections.ints.collections.IntBidirectionalIterator;
import speiger.src.collections.ints.functions.IntConsumer;
import speiger.src.collections.ints.functions.consumer.IntIntConsumer;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.ints.functions.function.IntFunction;
import speiger.src.collections.ints.functions.function.IntIntUnaryOperator;
import speiger.src.collections.ints.functions.function.IntObjectUnaryOperator;
import speiger.src.collections.ints.lists.IntListIterator;
import speiger.src.collections.ints.maps.abstracts.AbstractInt2ObjectMap;
import speiger.src.collections.ints.maps.interfaces.Int2ObjectMap;
import speiger.src.collections.ints.maps.interfaces.Int2ObjectOrderedMap;
import speiger.src.collections.ints.sets.AbstractIntSet;
import speiger.src.collections.ints.sets.IntOrderedSet;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectIntConsumer;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectOrderedSet;

public class Int2ObjectArrayMap<V>
extends AbstractInt2ObjectMap<V>
implements Int2ObjectOrderedMap<V> {
    protected transient int[] keys;
    protected transient V[] values;
    protected int size = 0;
    protected IntOrderedSet keySet;
    protected ObjectCollection<V> valuesC;
    protected Int2ObjectOrderedMap.FastOrderedSet<V> entrySet;

    public Int2ObjectArrayMap() {
        this(16);
    }

    public Int2ObjectArrayMap(int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
        }
        this.keys = new int[minCapacity];
        this.values = new Object[minCapacity];
    }

    public Int2ObjectArrayMap(Integer[] keys, V[] values) {
        this(keys, values, keys.length);
    }

    public Int2ObjectArrayMap(Integer[] keys, V[] values, int length) {
        this(length);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        this.putAll(keys, values, 0, length);
    }

    public Int2ObjectArrayMap(int[] keys, V[] values) {
        this(keys, values, keys.length);
    }

    public Int2ObjectArrayMap(int[] keys, V[] values, int length) {
        this(length);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        this.putAll(keys, values, 0, length);
    }

    public Int2ObjectArrayMap(Map<? extends Integer, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    public Int2ObjectArrayMap(Int2ObjectMap<V> map) {
        this(map.size());
        ObjectIterator<Int2ObjectMap.Entry<V>> iter = this.getFastIterator(map);
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            this.keys[this.size] = entry.getIntKey();
            this.values[this.size] = entry.getValue();
            ++this.size;
        }
    }

    @Override
    public V put(int key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            this.insertIndex(this.size++, key, value);
            return this.getDefaultReturnValue();
        }
        V oldValue = this.values[index];
        this.values[index] = value;
        return oldValue;
    }

    @Override
    public V putIfAbsent(int key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            this.insertIndex(this.size++, key, value);
            return this.getDefaultReturnValue();
        }
        if (Objects.equals(this.values[index], this.getDefaultReturnValue())) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        return this.values[index];
    }

    @Override
    public V putAndMoveToFirst(int key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            this.insertIndex(0, key, value);
            ++this.size;
            return this.getDefaultReturnValue();
        }
        V lastValue = this.values[index];
        this.values[index] = value;
        this.moveIndexToFirst(index);
        return lastValue;
    }

    @Override
    public V putAndMoveToLast(int key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            this.insertIndex(this.size++, key, value);
            return this.getDefaultReturnValue();
        }
        V lastValue = this.values[index];
        this.values[index] = value;
        this.moveIndexToLast(index);
        return lastValue;
    }

    @Override
    public boolean moveToFirst(int key) {
        int index = this.findIndex(key);
        if (index > 0) {
            this.moveIndexToFirst(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToLast(int key) {
        int index = this.findIndex(key);
        if (index >= 0 && index < this.size - 1) {
            this.moveIndexToLast(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        return this.findIndex(key) >= 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.findValue(value) >= 0;
    }

    @Override
    public V get(int key) {
        int index = this.findIndex(key);
        return index < 0 ? this.getDefaultReturnValue() : this.values[index];
    }

    @Override
    public V getOrDefault(int key, V defaultValue) {
        int index = this.findIndex(key);
        return index < 0 ? defaultValue : this.values[index];
    }

    @Override
    public V getAndMoveToFirst(int key) {
        int index = this.findIndex(key);
        if (index >= 0) {
            V value = this.values[index];
            this.moveIndexToFirst(index);
            return value;
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public V getAndMoveToLast(int key) {
        int index = this.findIndex(key);
        if (index >= 0) {
            V value = this.values[index];
            this.moveIndexToLast(index);
            return value;
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public int firstIntKey() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return this.keys[0];
    }

    @Override
    public int lastIntKey() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return this.keys[this.size - 1];
    }

    @Override
    public V firstValue() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return this.values[0];
    }

    @Override
    public V lastValue() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return this.values[this.size - 1];
    }

    @Override
    public int pollFirstIntKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int result = this.keys[0];
        this.removeIndex(0);
        return result;
    }

    @Override
    public int pollLastIntKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int result = this.keys[this.size - 1];
        this.removeIndex(this.size - 1);
        return result;
    }

    @Override
    public V remove(int key) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        V value = this.values[index];
        this.removeIndex(index);
        return value;
    }

    @Override
    public V removeOrDefault(int key, V defaultValue) {
        int index = this.findIndex(key);
        if (index < 0) {
            return defaultValue;
        }
        V value = this.values[index];
        this.removeIndex(index);
        return value;
    }

    @Override
    public boolean remove(int key, V value) {
        int index = this.findIndex(key, value);
        if (index < 0) {
            return false;
        }
        this.removeIndex(index);
        return true;
    }

    @Override
    public V remove(Object key) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        V value = this.values[index];
        this.removeIndex(index);
        return value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        int index = this.findIndex(key, value);
        if (index < 0) {
            return false;
        }
        this.removeIndex(index);
        return true;
    }

    @Override
    public void forEach(IntObjectConsumer<V> action) {
        if (this.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.keys[i], this.values[i]);
        }
    }

    @Override
    public IntOrderedSet keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.valuesC == null) {
            this.valuesC = new Values();
        }
        return this.valuesC;
    }

    @Override
    public ObjectOrderedSet<Int2ObjectMap.Entry<V>> int2ObjectEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new MapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public boolean replace(int key, V oldValue, V newValue) {
        int index = this.findIndex(key);
        if (index < 0 || this.values[index] != oldValue) {
            return false;
        }
        this.values[index] = newValue;
        return true;
    }

    @Override
    public V replace(int key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        V oldValue = this.values[index];
        this.values[index] = value;
        return oldValue;
    }

    @Override
    public V compute(int key, IntObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index == -1) {
            V newValue = mappingFunction.apply(key, (V)this.getDefaultReturnValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insertIndex(this.size++, key, newValue);
            return newValue;
        }
        V newValue = mappingFunction.apply(key, this.values[index]);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.removeIndex(index);
            return newValue;
        }
        this.values[index] = newValue;
        return newValue;
    }

    @Override
    public V computeIfAbsent(int key, IntFunction<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index == -1) {
            V newValue = mappingFunction.apply(key);
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insertIndex(this.size++, key, newValue);
            return newValue;
        }
        V newValue = this.values[index];
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            newValue = mappingFunction.apply(key);
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public V supplyIfAbsent(int key, ObjectSupplier<V> valueProvider) {
        Objects.requireNonNull(valueProvider);
        int index = this.findIndex(key);
        if (index == -1) {
            V newValue = valueProvider.get();
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insertIndex(this.size++, key, newValue);
            return newValue;
        }
        V newValue = this.values[index];
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            newValue = valueProvider.get();
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public V computeIfPresent(int key, IntObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index == -1 || Objects.equals(this.values[index], this.getDefaultReturnValue())) {
            return this.getDefaultReturnValue();
        }
        V newValue = mappingFunction.apply(key, this.values[index]);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.removeIndex(index);
            return newValue;
        }
        this.values[index] = newValue;
        return newValue;
    }

    @Override
    public V merge(int key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(value);
        int index = this.findIndex(key);
        Object object = newValue = index == -1 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? value : mappingFunction.apply(this.values[index], value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            if (index >= 0) {
                this.removeIndex(index);
            }
        } else if (index == -1) {
            this.insertIndex(this.size++, key, newValue);
        } else {
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public void mergeAll(Int2ObjectMap<V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        for (Int2ObjectMap.Entry entry : this.getFastIterable(m)) {
            Object newValue;
            int key = entry.getIntKey();
            int index = this.findIndex(key);
            Object object = newValue = index == -1 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? entry.getValue() : mappingFunction.apply(this.values[index], entry.getValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                if (index < 0) continue;
                this.removeIndex(index);
                continue;
            }
            if (index == -1) {
                this.insertIndex(this.size++, key, newValue);
                continue;
            }
            this.values[index] = newValue;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0, this.size, 0);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public Int2ObjectArrayMap<V> copy() {
        Int2ObjectArrayMap<V> map = new Int2ObjectArrayMap<V>();
        map.size = this.size;
        map.keys = Arrays.copyOf(this.keys, this.keys.length);
        map.values = Arrays.copyOf(this.values, this.keys.length);
        return map;
    }

    protected void moveIndexToFirst(int index) {
        if (index == 0) {
            return;
        }
        int key = this.keys[index];
        V value = this.values[index];
        System.arraycopy(this.keys, 0, this.keys, 1, index);
        System.arraycopy(this.values, 0, this.values, 1, index);
        this.keys[0] = key;
        this.values[0] = value;
    }

    protected void moveIndexToLast(int index) {
        if (index == this.size - 1) {
            return;
        }
        int key = this.keys[index];
        V value = this.values[index];
        System.arraycopy(this.keys, index + 1, this.keys, index, this.size - index - 1);
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        this.keys[this.size - 1] = key;
        this.values[this.size - 1] = value;
    }

    protected void grow(int newSize) {
        if (newSize < this.keys.length) {
            return;
        }
        newSize = Math.max(newSize, this.keys.length == 0 ? 2 : this.keys.length * 2);
        this.keys = Arrays.copyOf(this.keys, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
    }

    protected void insertIndex(int index, int key, V value) {
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.keys, index, this.keys, index + 1, this.size - index);
            System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        }
        this.keys[index] = key;
        this.values[index] = value;
    }

    protected void removeRange(int from, int to) {
        if (from < 0 || from >= this.size) {
            throw new IllegalStateException("From Element ");
        }
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (to != this.size) {
            System.arraycopy(this.keys, to, this.keys, from, this.size - to);
            System.arraycopy(this.values, to, this.values, from, this.size - to);
        }
        for (int i = 0; i < length; ++i) {
            this.keys[i + to] = 0;
            this.values[i + to] = null;
        }
        this.size -= length;
    }

    protected void removeIndex(int index) {
        if (index == this.size - 1) {
            --this.size;
            this.keys[this.size] = 0;
            this.values[this.size] = null;
            return;
        }
        System.arraycopy(this.keys, index + 1, this.keys, index, this.size - index - 1);
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        --this.size;
        this.keys[this.size] = 0;
        this.values[this.size] = null;
    }

    protected int findIndex(int key, V value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] != key || !Objects.equals(this.values[i], value)) continue;
            return i;
        }
        return -1;
    }

    protected int findIndex(int key) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    protected int findIndex(Object key, Object value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Objects.equals(key, this.keys[i]) || !Objects.equals(value, this.values[i])) continue;
            return i;
        }
        return -1;
    }

    protected int findIndex(Object key) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    protected int findValue(Object value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Objects.equals(value, this.values[i])) continue;
            return i;
        }
        return -1;
    }

    private class MapEntry
    implements Int2ObjectMap.Entry<V>,
    Map.Entry<Integer, V> {
        int index = -1;

        public MapEntry() {
        }

        public MapEntry(int index) {
            this.index = index;
        }

        @Override
        public int getIntKey() {
            return Int2ObjectArrayMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return Int2ObjectArrayMap.this.values[this.index];
        }

        @Override
        public V setValue(V value) {
            Object oldValue = Int2ObjectArrayMap.this.values[this.index];
            Int2ObjectArrayMap.this.values[this.index] = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Int2ObjectMap.Entry) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)obj;
                    return Int2ObjectArrayMap.this.keys[this.index] == entry.getIntKey() && Objects.equals(Int2ObjectArrayMap.this.values[this.index], entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return key instanceof Integer && Int2ObjectArrayMap.this.keys[this.index] == (Integer)key && Objects.equals(Int2ObjectArrayMap.this.values[this.index], value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(Int2ObjectArrayMap.this.keys[this.index]) ^ Objects.hashCode(Int2ObjectArrayMap.this.values[this.index]);
        }

        public String toString() {
            return Integer.toString(Int2ObjectArrayMap.this.keys[this.index]) + "=" + Objects.toString(Int2ObjectArrayMap.this.values[this.index]);
        }
    }

    private class MapIterator {
        int index;
        int lastReturned = -1;

        private MapIterator() {
        }

        public boolean hasNext() {
            return this.index < Int2ObjectArrayMap.this.size;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            Int2ObjectArrayMap.this.removeIndex(this.lastReturned);
            if (this.lastReturned < this.index) {
                --this.index;
            }
            this.lastReturned = -1;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.index;
            this.lastReturned = this.index;
            return this.lastReturned;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.index;
            return this.index++;
        }

        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int steps = Math.min(amount, Int2ObjectArrayMap.this.size() - this.index);
            this.index += steps;
            if (steps > 0) {
                this.lastReturned = Math.min(this.index - 1, Int2ObjectArrayMap.this.size() - 1);
            }
            return steps;
        }

        public int back(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int steps = Math.min(amount, this.index);
            this.index -= steps;
            if (steps > 0) {
                this.lastReturned = Math.min(this.index, Int2ObjectArrayMap.this.size() - 1);
            }
            return steps;
        }
    }

    private class ValueIterator
    extends MapIterator
    implements ObjectListIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V previous() {
            return Int2ObjectArrayMap.this.values[this.previousEntry()];
        }

        @Override
        public V next() {
            return Int2ObjectArrayMap.this.values[this.nextEntry()];
        }

        @Override
        public void set(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(V e) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeyIterator
    extends MapIterator
    implements IntListIterator {
        public KeyIterator() {
        }

        public KeyIterator(int element) {
            this.index = Int2ObjectArrayMap.this.findIndex(element);
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousInt() {
            return Int2ObjectArrayMap.this.keys[this.previousEntry()];
        }

        @Override
        public int nextInt() {
            return Int2ObjectArrayMap.this.keys[this.nextEntry()];
        }

        @Override
        public void set(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int e) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Int2ObjectMap.Entry<V>> {
        MapEntry entry = null;

        public EntryIterator() {
        }

        public EntryIterator(int from) {
            this.index = Int2ObjectArrayMap.this.findIndex(from);
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public Int2ObjectMap.Entry<V> next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public Int2ObjectMap.Entry<V> previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            if (this.entry != null && this.entry.index != -1) {
                this.entry.index = -1;
            }
        }

        @Override
        public void set(Int2ObjectMap.Entry<V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Int2ObjectMap.Entry<V> e) {
            throw new UnsupportedOperationException();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Int2ObjectMap.Entry<V>> {
        MapEntry entry;

        public FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public FastEntryIterator(int from) {
            this.entry = new MapEntry();
            this.index = Int2ObjectArrayMap.this.findIndex(from);
        }

        @Override
        public Int2ObjectMap.Entry<V> next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        @Override
        public Int2ObjectMap.Entry<V> previous() {
            this.entry.index = this.previousEntry();
            return this.entry;
        }

        @Override
        public void set(Int2ObjectMap.Entry<V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Int2ObjectMap.Entry<V> e) {
            throw new UnsupportedOperationException();
        }
    }

    private class Values
    extends AbstractObjectCollection<V> {
        private Values() {
        }

        @Override
        public boolean contains(Object e) {
            return Int2ObjectArrayMap.this.containsValue(e);
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return Int2ObjectArrayMap.this.size();
        }

        @Override
        public void clear() {
            Int2ObjectArrayMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            Objects.requireNonNull(action);
            int i = 0;
            while (i < Int2ObjectArrayMap.this.size) {
                action.accept(Int2ObjectArrayMap.this.values[i++]);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<V> action) {
            Objects.requireNonNull(action);
            int i = 0;
            while (i < Int2ObjectArrayMap.this.size) {
                action.accept(i, Int2ObjectArrayMap.this.values[i++]);
            }
        }

        @Override
        public boolean matchesAny(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.values[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.values[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (filter.test(Int2ObjectArrayMap.this.values[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, V, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                state = operator.apply(state, Int2ObjectArrayMap.this.values[i]);
            }
            return state;
        }

        @Override
        public V reduce(ObjectObjectUnaryOperator<V, V> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (empty) {
                    empty = false;
                    state = Int2ObjectArrayMap.this.values[i];
                    continue;
                }
                state = operator.apply(state, Int2ObjectArrayMap.this.values[i]);
            }
            return state;
        }

        @Override
        public V findFirst(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.values[i])) continue;
                return Int2ObjectArrayMap.this.values[i];
            }
            return null;
        }

        @Override
        public int count(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            int result = 0;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.values[i])) continue;
                ++result;
            }
            return result;
        }
    }

    private class KeySet
    extends AbstractIntSet
    implements IntOrderedSet {
        private KeySet() {
        }

        @Override
        public boolean contains(int e) {
            return Int2ObjectArrayMap.this.containsKey(e);
        }

        @Override
        public boolean remove(int o) {
            int oldSize = Int2ObjectArrayMap.this.size;
            Int2ObjectArrayMap.this.remove(o);
            return Int2ObjectArrayMap.this.size != oldSize;
        }

        @Override
        public boolean add(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToFirst(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(int o) {
            return Int2ObjectArrayMap.this.moveToFirst(o);
        }

        @Override
        public boolean moveToLast(int o) {
            return Int2ObjectArrayMap.this.moveToLast(o);
        }

        @Override
        public IntListIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int fromElement) {
            return new KeyIterator(fromElement);
        }

        @Override
        public int size() {
            return Int2ObjectArrayMap.this.size();
        }

        @Override
        public void clear() {
            Int2ObjectArrayMap.this.clear();
        }

        @Override
        public int firstInt() {
            return Int2ObjectArrayMap.this.firstIntKey();
        }

        @Override
        public int pollFirstInt() {
            return Int2ObjectArrayMap.this.pollFirstIntKey();
        }

        @Override
        public int lastInt() {
            return Int2ObjectArrayMap.this.lastIntKey();
        }

        @Override
        public int pollLastInt() {
            return Int2ObjectArrayMap.this.pollLastIntKey();
        }

        @Override
        public KeySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            int i = 0;
            while (i < Int2ObjectArrayMap.this.size) {
                action.accept(Int2ObjectArrayMap.this.keys[i++]);
            }
        }

        @Override
        public void forEachIndexed(IntIntConsumer action) {
            Objects.requireNonNull(action);
            int i = 0;
            while (i < Int2ObjectArrayMap.this.size) {
                action.accept(i, Int2ObjectArrayMap.this.keys[i++]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectIntConsumer<E> action) {
            Objects.requireNonNull(action);
            int i = 0;
            while (i < Int2ObjectArrayMap.this.size) {
                action.accept(input, Int2ObjectArrayMap.this.keys[i++]);
            }
        }

        @Override
        public boolean matchesAny(IntPredicate filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.keys[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(IntPredicate filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(IntPredicate filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (filter.test(Int2ObjectArrayMap.this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int reduce(int identity, IntIntUnaryOperator operator) {
            Objects.requireNonNull(operator);
            int state = identity;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                state = operator.applyAsInt(state, Int2ObjectArrayMap.this.keys[i]);
            }
            return state;
        }

        @Override
        public int reduce(IntIntUnaryOperator operator) {
            Objects.requireNonNull(operator);
            int state = 0;
            boolean empty = true;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (empty) {
                    empty = false;
                    state = Int2ObjectArrayMap.this.keys[i];
                    continue;
                }
                state = operator.applyAsInt(state, Int2ObjectArrayMap.this.keys[i]);
            }
            return state;
        }

        @Override
        public int findFirst(IntPredicate filter) {
            Objects.requireNonNull(filter);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.keys[i])) continue;
                return Int2ObjectArrayMap.this.keys[i];
            }
            return 0;
        }

        @Override
        public int count(IntPredicate filter) {
            Objects.requireNonNull(filter);
            int result = 0;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (!filter.test(Int2ObjectArrayMap.this.keys[i])) continue;
                ++result;
            }
            return result;
        }
    }

    private class MapEntrySet
    extends AbstractObjectSet<Int2ObjectMap.Entry<V>>
    implements Int2ObjectOrderedMap.FastOrderedSet<V> {
        private MapEntrySet() {
        }

        @Override
        public boolean addAndMoveToFirst(Int2ObjectMap.Entry<V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(Int2ObjectMap.Entry<V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(Int2ObjectMap.Entry<V> o) {
            return Int2ObjectArrayMap.this.moveToFirst(o.getIntKey());
        }

        @Override
        public boolean moveToLast(Int2ObjectMap.Entry<V> o) {
            return Int2ObjectArrayMap.this.moveToLast(o.getIntKey());
        }

        @Override
        public Int2ObjectMap.Entry<V> first() {
            return new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.firstIntKey(), Int2ObjectArrayMap.this.firstValue());
        }

        @Override
        public Int2ObjectMap.Entry<V> last() {
            return new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.lastIntKey(), Int2ObjectArrayMap.this.lastValue());
        }

        @Override
        public Int2ObjectMap.Entry<V> pollFirst() {
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.firstIntKey(), Int2ObjectArrayMap.this.firstValue());
            Int2ObjectArrayMap.this.pollFirstIntKey();
            return entry;
        }

        @Override
        public Int2ObjectMap.Entry<V> pollLast() {
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.lastIntKey(), Int2ObjectArrayMap.this.lastValue());
            Int2ObjectArrayMap.this.pollLastIntKey();
            return entry;
        }

        @Override
        public ObjectBidirectionalIterator<Int2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Int2ObjectMap.Entry<V>> iterator(Int2ObjectMap.Entry<V> fromElement) {
            return new EntryIterator(fromElement.getIntKey());
        }

        @Override
        public ObjectBidirectionalIterator<Int2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Int2ObjectMap.Entry<V>> fastIterator(int fromElement) {
            return new FastEntryIterator(fromElement);
        }

        @Override
        public MapEntrySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Int2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                action.accept(new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Int2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry();
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                entry.set(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                action.accept(entry);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<Int2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                action.accept(i, new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]));
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, Int2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                action.accept(input, new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]));
            }
        }

        @Override
        public boolean matchesAny(Predicate<Int2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry();
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                entry.set(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                if (!filter.test(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<Int2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry();
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                entry.set(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                if (!filter.test(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<Int2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry();
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                entry.set(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                if (filter.test(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, Int2ObjectMap.Entry<V>, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                state = operator.apply(state, new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]));
            }
            return state;
        }

        @Override
        public Int2ObjectMap.Entry<V> reduce(ObjectObjectUnaryOperator<Int2ObjectMap.Entry<V>, Int2ObjectMap.Entry<V>> operator) {
            Objects.requireNonNull(operator);
            Int2ObjectMap.Entry state = null;
            boolean empty = true;
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                if (empty) {
                    empty = false;
                    state = new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                    continue;
                }
                state = (Int2ObjectMap.Entry)operator.apply(state, new AbstractInt2ObjectMap.BasicEntry(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]));
            }
            return state;
        }

        @Override
        public Int2ObjectMap.Entry<V> findFirst(Predicate<Int2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry();
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                entry.set(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                if (!filter.test(entry)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public int count(Predicate<Int2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            AbstractInt2ObjectMap.BasicEntry entry = new AbstractInt2ObjectMap.BasicEntry();
            for (int i = 0; i < Int2ObjectArrayMap.this.size; ++i) {
                entry.set(Int2ObjectArrayMap.this.keys[i], Int2ObjectArrayMap.this.values[i]);
                if (!filter.test(entry)) continue;
                ++result;
            }
            return result;
        }

        @Override
        @Deprecated
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Int2ObjectMap.Entry) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)o;
                    int index = Int2ObjectArrayMap.this.findIndex(entry.getIntKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Int2ObjectArrayMap.this.values[index]);
                    }
                } else {
                    Map.Entry entry = (Map.Entry)o;
                    int index = Int2ObjectArrayMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Int2ObjectArrayMap.this.values[index]);
                    }
                }
            }
            return false;
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Int2ObjectMap.Entry) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)o;
                    return Int2ObjectArrayMap.this.remove(entry.getIntKey(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)o;
                return Int2ObjectArrayMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public int size() {
            return Int2ObjectArrayMap.this.size();
        }

        @Override
        public void clear() {
            Int2ObjectArrayMap.this.clear();
        }
    }
}

