/*
 * Decompiled with CFR 0.152.
 */
package mantle.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import java.util.List;
import java.util.Map;
import mantle.lib.CoreRepo;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public abstract class Migration {
    Map<String, Item> remapItem = Maps.newHashMap();
    Map<String, Block> remapBlock = Maps.newHashMap();
    List<String> ignore = Lists.newArrayList();
    private ModContainer mod;
    private String modID;

    public Migration(ModContainer m) {
        this.mod = m;
        this.modID = m.getModId();
    }

    public void addMigration(String old, Item newItem) {
        this.remapItem.put(this.modID + ":" + old, newItem);
    }

    public void addMigration(String old, Block newBlock) {
        this.remapBlock.put(this.modID + ":" + old, newBlock);
    }

    public void addRemoval(String id) {
        this.ignore.add(this.modID + ":" + id);
    }

    public void processMigrationEvent(FMLMissingMappingsEvent event) {
        if (!this.remapBlock.isEmpty() || !this.remapItem.isEmpty()) {
            event.applyModContainer(this.mod);
            List l = event.get();
            if (l != null) {
                for (FMLMissingMappingsEvent.MissingMapping miss : event.get()) {
                    if (this.remapItem.containsKey(miss.name)) {
                        miss.remap(this.remapItem.get(miss.name));
                        continue;
                    }
                    if (this.remapBlock.containsKey(miss.name)) {
                        miss.remap(this.remapBlock.get(miss.name));
                        continue;
                    }
                    if (!this.ignore.contains(miss.name)) continue;
                    miss.ignore();
                }
            } else {
                CoreRepo.logger.error("migration list from FML empty for mod " + this.modID);
            }
        }
    }
}

