/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import codechicken.nei.util.NBTJson;
import java.util.ArrayDeque;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import net.minecraft.nbt.NBTTagCompound;

public class NBTTagCompoundConcurrentModificationException
extends ConcurrentModificationException {
    private final Deque<String> keyChain = new ArrayDeque<String>();
    private final String source;
    private Object fullTag;

    public NBTTagCompoundConcurrentModificationException(ConcurrentModificationException cause, Object source) {
        super(cause);
        this.source = NBTTagCompoundConcurrentModificationException.toString(source);
        this.fullTag = source;
    }

    public void addKeyPath(String key) {
        this.keyChain.addFirst(key);
    }

    public void setFullTag(Object fullTag) {
        this.fullTag = fullTag;
    }

    @Override
    public String getMessage() {
        return String.format("Keys: %s. Source tag: %s. Full tag: %s", String.join((CharSequence)"...", this.keyChain), this.source, NBTTagCompoundConcurrentModificationException.toString(this.fullTag));
    }

    private static String toString(Object source) {
        if (source == null) {
            return "null";
        }
        for (int i = 0; i < 10; ++i) {
            try {
                return source instanceof NBTTagCompound ? NBTJson.toJson((NBTTagCompound)((NBTTagCompound)source)) : source.toString();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        return "~~failed to serialize~~";
    }
}

