/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import appeng.api.config.TunnelType;
import appeng.core.Api;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ProcessingWire
implements IOreRecipeRegistrator {
    private final Materials[] dielectrics = new Materials[]{Materials.PolyvinylChloride, Materials.Polydimethylsiloxane};
    private final Materials[] syntheticRubbers = new Materials[]{Materials.StyreneButadieneRubber, Materials.Silicone};
    private static Object tt;

    public ProcessingWire() {
        OrePrefixes.wireGt01.add(this);
        OrePrefixes.wireGt02.add(this);
        OrePrefixes.wireGt04.add(this);
        OrePrefixes.wireGt08.add(this);
        OrePrefixes.wireGt12.add(this);
        OrePrefixes.wireGt16.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        OrePrefixes correspondingCable;
        int cableWidth;
        if (tt == TunnelType.ME) {
            try {
                tt = TunnelType.valueOf((String)"GT_POWER");
            }
            catch (IllegalArgumentException ignored) {
                tt = TunnelType.IC2_POWER;
            }
        }
        switch (aPrefix) {
            case wireGt01: {
                cableWidth = 1;
                correspondingCable = OrePrefixes.cableGt01;
                if (!aMaterial.contains(SubTag.NO_SMASHING)) {
                    if (GT_OreDictUnificator.get(OrePrefixes.springSmall, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.springSmall, aMaterial, 2L)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.benderRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 4L)).duration(200).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.wiremillRecipes);
                    }
                }
                if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_WORKING) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"Xx", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
                }
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireGt02, aMaterial, 1L)).duration(150).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4, aStack), GT_Utility.getIntegratedCircuit(4)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireGt04, aMaterial, 1L)).duration(200).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(8, aStack), GT_Utility.getIntegratedCircuit(8)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireGt08, aMaterial, 1L)).duration(300).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(12, aStack), GT_Utility.getIntegratedCircuit(12)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireGt12, aMaterial, 1L)).duration(400).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(16, aStack), GT_Utility.getIntegratedCircuit(16)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireGt16, aMaterial, 1L)).duration(500).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case wireGt02: {
                cableWidth = 2;
                correspondingCable = OrePrefixes.cableGt02;
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 2L), new Object[]{aOreDictName});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial)});
                break;
            }
            case wireGt04: {
                cableWidth = 4;
                correspondingCable = OrePrefixes.cableGt04;
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 4L), new Object[]{aOreDictName});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial)});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt02.get(aMaterial), OrePrefixes.wireGt02.get(aMaterial)});
                break;
            }
            case wireGt08: {
                cableWidth = 8;
                correspondingCable = OrePrefixes.cableGt08;
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 8L), new Object[]{aOreDictName});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial), OrePrefixes.wireGt01.get(aMaterial)});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt04.get(aMaterial), OrePrefixes.wireGt04.get(aMaterial)});
                break;
            }
            case wireGt12: {
                cableWidth = 12;
                correspondingCable = OrePrefixes.cableGt12;
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 12L), new Object[]{aOreDictName});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt08.get(aMaterial), OrePrefixes.wireGt04.get(aMaterial)});
                break;
            }
            case wireGt16: {
                cableWidth = 16;
                correspondingCable = OrePrefixes.cableGt16;
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 16L), new Object[]{aOreDictName});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt08.get(aMaterial), OrePrefixes.wireGt08.get(aMaterial)});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), new Object[]{OrePrefixes.wireGt12.get(aMaterial), OrePrefixes.wireGt04.get(aMaterial)});
                this.AE2addNewAttunement(aStack);
                break;
            }
            default: {
                GT_Log.err.println("OrePrefix " + aPrefix.name() + " cannot be registered as a cable for Material " + aMaterial.mName);
                return;
            }
        }
        int costMultiplier = cableWidth / 4 + 1;
        switch (aMaterial.mName) {
            case "RedAlloy": 
            case "Cobalt": 
            case "Lead": 
            case "Tin": 
            case "Zinc": 
            case "SolderingAlloy": {
                ArrayList<Object> craftingListRubber = new ArrayList<Object>();
                craftingListRubber.add(aOreDictName);
                for (int i = 0; i < costMultiplier; ++i) {
                    craftingListRubber.add(OrePrefixes.plate.get(Materials.Rubber));
                }
                if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) != null) {
                    GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L), craftingListRubber.toArray());
                }
                if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), GT_OreDictUnificator.get(OrePrefixes.plate.get(Materials.Rubber), costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).duration(100).eut(8).addTo(RecipeMaps.packagerRecipes);
                }
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Rubber, 2L), GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.cableGt01, aMaterial, 1L)).duration(100).eut(8).addTo(RecipeMaps.alloySmelterRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Rubber, 2L), GT_OreDictUnificator.get(OrePrefixes.wireGt02, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.cableGt02, aMaterial, 1L)).duration(200).eut(16).addTo(RecipeMaps.alloySmelterRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Rubber, 4L), GT_OreDictUnificator.get(OrePrefixes.wireGt04, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.cableGt04, aMaterial, 1L)).duration(300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.alloySmelterRecipes);
                if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.Rubber.getMolten(144L * (long)costMultiplier)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.StyreneButadieneRubber.getMolten(108L * (long)costMultiplier)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.Silicone.getMolten(72L * (long)costMultiplier)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                for (Materials dielectric : this.dielectrics) {
                    for (Materials syntheticRubber : this.syntheticRubbers) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4, aStack), dielectric.getDust(costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 4L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 144L)).duration(400).eut(8).addTo(RecipeMaps.assemblerRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(aStack, dielectric.getDustSmall(costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 36L)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                    }
                }
                break;
            }
            case "Iron": 
            case "Nickel": 
            case "Cupronickel": 
            case "Copper": 
            case "AnnealedCopper": 
            case "Kanthal": 
            case "Gold": 
            case "Electrum": 
            case "Silver": 
            case "Nichrome": 
            case "Steel": 
            case "BlackSteel": 
            case "Titanium": 
            case "Aluminium": 
            case "BlueAlloy": 
            case "NetherStar": 
            case "RedstoneAlloy": {
                if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.Rubber.getMolten(144 * costMultiplier)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.StyreneButadieneRubber.getMolten(108 * costMultiplier)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.Silicone.getMolten(72 * costMultiplier)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                for (Materials dielectric : this.dielectrics) {
                    for (Materials syntheticRubber : this.syntheticRubbers) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4, aStack), dielectric.getDust(costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 4L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 144L)).duration(400).eut(8).addTo(RecipeMaps.assemblerRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(aStack, dielectric.getDustSmall(costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 36L)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
                    }
                }
                break;
            }
            default: {
                if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, (long)costMultiplier), GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.Silicone.getMolten(costMultiplier * 72)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(aStack, GT_OreDictUnificator.get(OrePrefixes.foil, Materials.PolyphenyleneSulfide, (long)costMultiplier), GT_Utility.getIntegratedCircuit(24)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(Materials.Silicone.getMolten(costMultiplier * 72)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                for (Materials dielectric : this.dielectrics) {
                    for (Materials syntheticRubber : this.syntheticRubbers) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4, aStack), dielectric.getDust(costMultiplier), GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, (long)costMultiplier * 4L)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 4L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 144L)).duration(400).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4, aStack), dielectric.getDust(costMultiplier), GT_OreDictUnificator.get(OrePrefixes.foil, Materials.PolyphenyleneSulfide, (long)costMultiplier * 4L)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 4L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 144L)).duration(400).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(aStack, dielectric.getDustSmall(costMultiplier), GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, (long)costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 36L)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(aStack, dielectric.getDustSmall(costMultiplier), GT_OreDictUnificator.get(OrePrefixes.foil, Materials.PolyphenyleneSulfide, (long)costMultiplier)).itemOutputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).fluidInputs(syntheticRubber.getMolten((long)costMultiplier * 36L)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                    }
                }
            }
        }
        if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) != null) {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L)).itemOutputs(GT_Utility.copyAmount(1, aStack)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.unpackagerRecipes);
        }
        if (GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L) != null) {
            this.AE2AddNetAttunementCable(aStack, correspondingCable, aMaterial);
        }
    }

    private static void setAE2Field() {
        tt = TunnelType.ME;
    }

    private void AE2addNewAttunement(ItemStack aStack) {
        Api.INSTANCE.registries().p2pTunnel().addNewAttunement(aStack, (TunnelType)tt);
    }

    private void AE2AddNetAttunementCable(ItemStack aStack, OrePrefixes correspondingCable, Materials aMaterial) {
        Api.INSTANCE.registries().p2pTunnel().addNewAttunement(aStack, (TunnelType)tt);
        Api.INSTANCE.registries().p2pTunnel().addNewAttunement(GT_OreDictUnificator.get(correspondingCable, aMaterial, 1L), (TunnelType)tt);
    }

    static {
        ProcessingWire.setAE2Field();
    }
}

