/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine_Steam;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_HPSteam
extends GT_MetaTileEntity_LargeTurbine {
    public boolean achievement = false;
    private boolean looseFit = false;

    public GT_MetaTileEntity_LargeTurbine_HPSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_HPSteam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[0][59];
        return iTextureArray;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Steam Turbine").addInfo("Controller block for the Large High Pressure Steam Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Outputs Steam as well as producing power").addInfo("Power output depends on turbine and fitting").addInfo("Use screwdriver to adjust fitting of turbine").addSeparator().beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Titanium Turbine Casing", 8, 31, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Superheated Steam, Side centered", 2).addOutputHatch("Steam, Side centered", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_HPSteam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 11;
    }

    @Override
    public int getCasingTextureIndex() {
        return 59;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff, int overflowEfficiency, float[] flowMultipliers) {
        if (this.looseFit) {
            float[] calculatedFlow = GT_MetaTileEntity_LargeTurbine_Steam.calculateLooseFlow(aOptFlow, aBaseEff);
            aOptFlow = GT_Utility.safeInt((long)calculatedFlow[0]);
            aBaseEff = GT_Utility.safeInt((long)calculatedFlow[1]);
        }
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        this.realOptFlow = (float)aOptFlow * flowMultipliers[0];
        int remainingFlow = GT_Utility.safeInt((long)(this.realOptFlow * ((double)(0.5f * (float)this.overflowMultiplier) + 1.5)));
        this.storedFluid = 0;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            FluidStack aFluidStack = aFluids.get(i);
            if (GT_ModHandler.isSuperHeatedSteam(aFluidStack)) {
                flow = Math.min(aFluidStack.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluidStack, flow));
                this.storedFluid += aFluidStack.amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                try {
                    GT_Mod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "efficientsteam");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.achievement = true;
                continue;
            }
            if (!GT_ModHandler.isAnySteam(aFluidStack)) continue;
            this.depleteInput(new FluidStack(aFluidStack, aFluidStack.amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        this.addOutput(GT_ModHandler.getSteam(totalFlow));
        if (totalFlow == GT_Utility.safeInt((long)this.realOptFlow)) {
            tEU = GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L);
        } else {
            float efficiency = this.getOverflowEfficiency(totalFlow, GT_Utility.safeInt((long)this.realOptFlow), this.overflowMultiplier);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L));
        }
        if ((long)tEU > this.getMaximumOutput()) {
            tEU = GT_Utility.safeInt(this.getMaximumOutput());
        }
        return tEU;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier + 2)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GT_Utility.sendChatToPlayer(aPlayer, this.looseFit ? GT_Utility.trans("500", "Fitting: Loose - More Flow") : GT_Utility.trans("501", "Fitting: Tight - More Efficiency"));
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && XSTR.XSTR_INSTANCE.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public String[] getInfoData() {
        ((GT_MetaTileEntity_LargeTurbine)this).looseFit = this.looseFit;
        return super.getInfoData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }
}

