/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.task.tasks;

import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.logic.interfaces.ProcessingLogicHost;
import gregtech.api.task.TaskHost;
import gregtech.api.task.TickableTask;
import javax.annotation.Nonnull;

public class ProcessingTask<T extends TaskHost & ProcessingLogicHost<P>, P extends MuTEProcessingLogic<P>>
extends TickableTask<T> {
    private static final String NAME = "processing";

    public ProcessingTask(@Nonnull T taskHost) {
        super(taskHost);
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    public void update(long tick, boolean isServerSide) {
        if (!isServerSide) {
            return;
        }
        if (!((IMachineProgress)((Object)this.taskHost)).isAllowedToWork()) {
            return;
        }
        Object logic = ((ProcessingLogicHost)((Object)this.taskHost)).getProcessingLogic();
        if (((ProcessingLogicHost)((Object)this.taskHost)).needsUpdate()) {
            ((ProcessingLogicHost)((Object)this.taskHost)).updateProcessingLogic(logic);
            ((ProcessingLogicHost)((Object)this.taskHost)).setProcessingUpdate(false);
        }
        if (((MuTEProcessingLogic)logic).canWork() && tick % 100L == 0L) {
            ((ProcessingLogicHost)((Object)this.taskHost)).setProcessingLogicPower(logic);
            ((MuTEProcessingLogic)logic).startCheck();
            if (((MuTEProcessingLogic)logic).getResult().wasSuccessful()) {
                ((IMachineProgress)((Object)this.taskHost)).setActive(true);
            }
        }
        if (((IMachineProgress)((Object)this.taskHost)).hasThingsToDo()) {
            ((MuTEProcessingLogic)logic).progress();
        } else {
            ((IMachineProgress)((Object)this.taskHost)).setActive(false);
        }
    }
}

