/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.net.data.CasingData;
import gregtech.api.net.data.CommonData;
import gregtech.api.net.data.CoordinateData;
import gregtech.api.net.data.MultiTileEntityData;
import gregtech.api.net.data.MultiTileEntityProcess;
import gregtech.api.net.data.PacketData;
import io.netty.buffer.ByteBuf;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.IBlockAccess;

public class GT_Packet_MultiTileEntity
extends GT_Packet_New {
    private final Set<PacketData<MultiTileEntityProcess>> data = new HashSet<PacketData<MultiTileEntityProcess>>();
    public static final int COVERS = GT_Values.B[0];
    public static final int REDSTONE = GT_Values.B[1];
    public static final int MODES = GT_Values.B[2];
    public static final int CONTROLLER = GT_Values.B[3];
    public static final int INVENTORY_INDEX = GT_Values.B[4];
    public static final int INVENTORY_NAME_ID = GT_Values.B[5];
    public static final int BOOLEANS = GT_Values.B[6];
    public static final int SOUND = GT_Values.B[7];

    public GT_Packet_MultiTileEntity(boolean reference) {
        super(reference);
    }

    @Override
    public void encode(ByteBuf aOut) {
        Set set = this.data.stream().sorted().collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        this.clearData();
        this.data.addAll(set);
        int features = 0;
        for (PacketData<MultiTileEntityProcess> data : this.data) {
            features |= 1 << data.getId();
        }
        aOut.writeInt(features);
        for (PacketData<MultiTileEntityProcess> data : this.data) {
            data.encode(aOut);
        }
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput in) {
        Objects.requireNonNull(in);
        int packetFeatures = in.readInt();
        GT_Packet_MultiTileEntity packet = new GT_Packet_MultiTileEntity(false);
        if (GT_Packet_MultiTileEntity.containsBit(packetFeatures, 0)) {
            packet.addData(new CoordinateData());
        }
        if (GT_Packet_MultiTileEntity.containsBit(packetFeatures, 1)) {
            packet.addData(new MultiTileEntityData());
        }
        if (GT_Packet_MultiTileEntity.containsBit(packetFeatures, 2)) {
            packet.addData(new CommonData());
        }
        if (GT_Packet_MultiTileEntity.containsBit(packetFeatures, 4)) {
            packet.addData(new CasingData());
        }
        Set set = packet.data.stream().sorted().collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        packet.clearData();
        packet.data.addAll(set);
        for (PacketData<MultiTileEntityProcess> data : packet.data) {
            data.decode(in);
        }
        return packet;
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld == null) {
            return;
        }
        MultiTileEntityProcess process = new MultiTileEntityProcess(aWorld);
        for (PacketData<MultiTileEntityProcess> data : this.data) {
            data.process(process);
        }
        process.process();
    }

    @Override
    public byte getPacketID() {
        return 18;
    }

    public void clearData() {
        this.data.clear();
    }

    public void addData(PacketData<MultiTileEntityProcess> data) {
        this.data.add(data);
    }

    private static boolean containsBit(int toCheck, int bit) {
        return (toCheck & 1 << bit) > 0;
    }
}

