/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.logic.AbstractProcessingLogic;
import gregtech.api.logic.ComplexParallelProcessingLogic;
import gregtech.api.multitileentity.multiblock.base.Controller;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class ComplexParallelController<C extends ComplexParallelController<C, P>, P extends ComplexParallelProcessingLogic<P>>
extends Controller<C, P> {
    protected int maxComplexParallels = 0;
    protected int currentComplexParallels = 0;

    public ComplexParallelController() {
        this.isSimpleMachine = false;
    }

    protected void setMaxComplexParallels(int parallel, boolean stopMachine) {
        if (parallel != this.maxComplexParallels && this.maxComplexParallels != 0 && stopMachine) {
            this.stopMachine(false);
        }
        this.maxComplexParallels = parallel;
        this.setProcessingUpdate(true);
    }

    @Override
    protected void stopMachine(boolean powerShutDown) {
        super.stopMachine(powerShutDown);
    }

    protected boolean hasPerfectOverclock() {
        return false;
    }

    @Override
    protected void addProgressStringToScanner(EntityPlayer player, int logLevel, ArrayList<String> list) {
        ComplexParallelProcessingLogic processing = (ComplexParallelProcessingLogic)this.getProcessingLogic();
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + " " + (i + 1) + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(processing.getProgress(i) > 20 ? (long)(processing.getProgress(i) / 20) : (long)processing.getProgress(i)) + EnumChatFormatting.RESET + (processing.getProgress(i) > 20 ? " s / " : " ticks / ") + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(processing.getDuration(i) > 20 ? (long)(processing.getDuration(i) / 20) : (long)processing.getDuration(i)) + EnumChatFormatting.RESET + (processing.getDuration(i) > 20 ? " s" : " ticks"));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        ComplexParallelProcessingLogic processing = (ComplexParallelProcessingLogic)this.getProcessingLogic();
        tag.func_74768_a("maxComplexParallels", this.maxComplexParallels);
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            tag.func_74768_a("maxProgress" + i, processing.getDuration(i));
            tag.func_74768_a("progress" + i, processing.getProgress(i));
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        this.maxComplexParallels = tag.func_74762_e("maxComplexParallels");
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            long maxProgress = tag.func_74762_e("maxProgress" + i);
            long progress = tag.func_74762_e("progress" + i);
            currentTip.add("Process " + (i + 1) + ": " + GT_Waila.getMachineProgressString(maxProgress > 0L && maxProgress >= progress, maxProgress, progress));
        }
    }

    @Override
    public void setProcessingLogicPower(@Nonnull P processingLogic) {
        ((AbstractProcessingLogic)processingLogic).setAmperageOC(true);
        ((AbstractProcessingLogic)processingLogic).setAvailableAmperage(this.getPowerLogic().getMaxAmperage() / (long)this.maxComplexParallels);
        ((AbstractProcessingLogic)processingLogic).setAvailableVoltage(this.getPowerLogic().getVoltage() / (long)this.maxComplexParallels);
    }

    @Override
    public void updateProcessingLogic(@Nonnull P processingLogic) {
        ((ComplexParallelProcessingLogic)processingLogic).setMaxComplexParallel(this.maxComplexParallels);
    }
}

