/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IFluidLockable;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.widget.FluidLockWidget;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Hatch_Output
extends GT_MetaTileEntity_Hatch
implements IFluidStore,
IFluidLockable,
IAddUIWidgets {
    private String lockedFluidName = null;
    private WeakReference<EntityPlayer> playerThatLockedfluid = null;
    public byte mMode = 0;

    public GT_MetaTileEntity_Hatch_Output(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, new String[]{"Fluid Output for Multiblocks", "Capacity: " + GT_Utility.formatNumbers(8000L * (1L << aTier)) + "L", "Right click with screwdriver to restrict output", "Can be restricted to put out Items and/or Steam/No Steam/1 specific Fluid", "Restricted Output Hatches are given priority for Multiblock Fluid output"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Output(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Output(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Output(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, int inventorySize) {
        super(aID, aName, aNameRegional, aTier, inventorySize, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Output(String name, int tier, int slots, String[] description, ITexture[][][] textures) {
        super(name, tier, slots, description, textures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        }
        return iTextureArray;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Output(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IFluidHandler tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && this.mFluid != null && (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            GT_Utility.moveFluid(aBaseMetaTileEntity, tTileEntity, aBaseMetaTileEntity.getFrontFacing(), Math.max(1, this.mFluid.amount), null);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mMode", this.mMode);
        if (this.isFluidLocked() && this.lockedFluidName != null && this.lockedFluidName.length() != 0) {
            aNBT.func_74778_a("lockedFluidName", this.lockedFluidName);
        } else {
            aNBT.func_82580_o("lockedFluidName");
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mMode = aNBT.func_74771_c("mMode");
        if (this.isFluidLocked()) {
            this.lockedFluidName = aNBT.func_74779_i("lockedFluidName");
        }
        this.lockedFluidName = GT_Utility.isStringInvalid(this.lockedFluidName) ? null : this.lockedFluidName;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    public int getLockedDisplaySlot() {
        return 3;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex != this.getStackDisplaySlot() && aIndex != this.getLockedDisplaySlot();
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0;
    }

    @Override
    public int getCapacity() {
        return 8000 * (1 << this.mTier);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverInfoAtSide(side).isGUIClickable()) {
            return;
        }
        this.mMode = aPlayer.func_70093_af() ? (byte)((this.mMode + 9) % 10) : (byte)((this.mMode + 1) % 10);
        switch (this.mMode) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("108", "Outputs misc. Fluids, Steam and Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("109", "Outputs Steam and Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("110", "Outputs Steam and misc. Fluids"));
                this.setLockedFluidName(null);
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("111", "Outputs Steam"));
                this.setLockedFluidName(null);
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("112", "Outputs misc. Fluids and Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("113", "Outputs only Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("114", "Outputs only misc. Fluids"));
                this.setLockedFluidName(null);
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("115", "Outputs nothing"));
                this.setLockedFluidName(null);
                break;
            }
            case 8: {
                String inBrackets;
                this.playerThatLockedfluid = new WeakReference<EntityPlayer>(aPlayer);
                if (this.mFluid == null) {
                    this.setLockedFluidName(null);
                    inBrackets = GT_Utility.trans("115.3", "currently none, will be locked to the next that is put in (or use fluid cell to lock)");
                } else {
                    this.setLockedFluidName(this.getDrainableStack().getFluid().getName());
                    inBrackets = this.getDrainableStack().getLocalizedName();
                }
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", GT_Utility.trans("151.1", "Outputs items and 1 specific Fluid"), inBrackets));
                break;
            }
            case 9: {
                String inBrackets;
                this.playerThatLockedfluid = new WeakReference<EntityPlayer>(aPlayer);
                if (this.mFluid == null) {
                    this.setLockedFluidName(null);
                    inBrackets = GT_Utility.trans("115.3", "currently none, will be locked to the next that is put in (or use fluid cell to lock)");
                } else {
                    this.setLockedFluidName(this.getDrainableStack().getFluid().getName());
                    inBrackets = this.getDrainableStack().getLocalizedName();
                }
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", GT_Utility.trans("151.2", "Outputs 1 specific Fluid"), inBrackets));
            }
        }
    }

    private boolean tryToLockHatch(EntityPlayer aPlayer, ForgeDirection side) {
        if (!this.getBaseMetaTileEntity().getCoverInfoAtSide(side).isGUIClickable()) {
            return false;
        }
        if (!this.isFluidLocked()) {
            return false;
        }
        ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
        if (tCurrentItem == null) {
            return false;
        }
        FluidStack tFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)tCurrentItem);
        if (tFluid == null && tCurrentItem.func_77973_b() instanceof IFluidContainerItem) {
            tFluid = ((IFluidContainerItem)tCurrentItem.func_77973_b()).getFluid(tCurrentItem);
        }
        if (tFluid != null) {
            if (this.getLockedFluidName() != null && !this.getLockedFluidName().equals(tFluid.getFluid().getName())) {
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s %s", GT_Utility.trans("151.3", "Hatch is locked to a different fluid. To change the locking, empty it and made it locked to the next fluid with a screwdriver. Currently locked to"), StatCollector.func_74838_a((String)this.getLockedFluidName())));
            } else {
                this.setLockedFluidName(tFluid.getFluid().getName());
                if (this.mMode == 8) {
                    GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", GT_Utility.trans("151.1", "Outputs items and 1 specific Fluid"), tFluid.getLocalizedName()));
                } else {
                    GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", GT_Utility.trans("151.2", "Outputs 1 specific Fluid"), tFluid.getLocalizedName()));
                }
            }
            return true;
        }
        return false;
    }

    public byte getMode() {
        return this.mMode;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.tryToLockHatch(aPlayer, side)) {
            return true;
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
    }

    public boolean outputsSteam() {
        return this.mMode < 4;
    }

    public boolean outputsLiquids() {
        return this.mMode % 2 == 0 || this.mMode == 9;
    }

    public boolean outputsItems() {
        return this.mMode % 4 < 2 && this.mMode != 9;
    }

    @Override
    public String getLockedFluidName() {
        return this.lockedFluidName;
    }

    @Override
    public void setLockedFluidName(String lockedFluidName) {
        this.lockedFluidName = lockedFluidName;
        this.func_70296_d();
    }

    @Override
    public void lockFluid(boolean lock) {
        if (lock) {
            if (!this.isFluidLocked()) {
                this.mMode = (byte)9;
                this.func_70296_d();
            }
        } else {
            this.mMode = 0;
            this.setLockedFluidName(null);
            this.func_70296_d();
        }
    }

    @Override
    public boolean isFluidLocked() {
        return this.mMode == 8 || this.mMode == 9;
    }

    @Override
    public boolean acceptsFluidLock(String name) {
        return true;
    }

    @Override
    public boolean isEmptyAndAcceptsAnyFluid() {
        return this.mMode == 0 && this.getFluidAmount() == 0;
    }

    @Override
    public boolean canStoreFluid(@Nonnull FluidStack fluidStack) {
        if (this.mFluid != null && !GT_Utility.areFluidsEqual(this.mFluid, fluidStack)) {
            return false;
        }
        if (this.isFluidLocked()) {
            if (this.lockedFluidName == null) {
                return true;
            }
            return this.lockedFluidName.equals(fluidStack.getFluid().getName());
        }
        if (GT_ModHandler.isSteam(fluidStack)) {
            return this.outputsSteam();
        }
        return this.outputsLiquids();
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    protected void onEmptyingContainerWhenEmpty() {
        if (this.lockedFluidName == null && this.mFluid != null && this.isFluidLocked()) {
            EntityPlayer player;
            this.setLockedFluidName(this.mFluid.getFluid().getName());
            if (this.playerThatLockedfluid == null || (player = (EntityPlayer)this.playerThatLockedfluid.get()) == null) {
                return;
            }
            GT_Utility.sendChatToPlayer(player, String.format(GT_Utility.trans("151.4", "Successfully locked Fluid to %s"), this.mFluid.getLocalizedName()));
            this.playerThatLockedfluid = null;
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + "Output Hatch" + EnumChatFormatting.RESET, "Stored Fluid:", EnumChatFormatting.GOLD + (this.mFluid == null ? "No Fluid" : this.mFluid.getLocalizedName()) + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mFluid == null ? 0L : (long)this.mFluid.amount) + " L" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getCapacity()) + " L" + EnumChatFormatting.RESET, !this.isFluidLocked() || this.lockedFluidName == null ? "Not Locked" : "Locked to " + StatCollector.func_74838_a((String)FluidRegistry.getFluidStack((String)this.lockedFluidName, (int)1).getUnlocalizedName())};
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(98, 16).setSize(71, 45))).widget(new FluidLockWidget(this).setPos(149, 41))).widget(new TextWidget("Locked Fluid").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(101, 20))).widget(TextWidget.dynamicString(() -> {
            FluidStack fluidStack = FluidRegistry.getFluidStack((String)this.lockedFluidName, (int)1);
            return fluidStack != null ? fluidStack.getLocalizedName() : "None";
        }).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setMaxWidth(65).setPos(101, 30))).widget((Widget)new FakeSyncWidget.ByteSyncer(() -> this.mMode, val -> {
            this.mMode = val;
        }));
    }
}

