/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TooltipMultiBlockBase;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_EnhancedMultiBlockBase<T extends GT_MetaTileEntity_EnhancedMultiBlockBase<T>>
extends GT_MetaTileEntity_TooltipMultiBlockBase
implements IAlignment,
IConstructable {
    private ExtendedFacing mExtendedFacing = ExtendedFacing.DEFAULT;
    private IAlignmentLimits mLimits = this.getInitialAlignmentLimits();

    protected GT_MetaTileEntity_EnhancedMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected GT_MetaTileEntity_EnhancedMultiBlockBase(String aName) {
        super(aName);
    }

    public ExtendedFacing getExtendedFacing() {
        return this.mExtendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        if (this.mExtendedFacing != newExtendedFacing) {
            if (this.mMachine) {
                this.stopMachine(ShutDownReasonRegistry.STRUCTURE_INCOMPLETE);
            }
            this.mExtendedFacing = newExtendedFacing;
            IGregTechTileEntity base = this.getBaseMetaTileEntity();
            this.mMachine = false;
            this.mUpdated = false;
            this.mUpdate = 100;
            if (this.getBaseMetaTileEntity().isServerSide() && !GregTech_API.isDummyWorld(this.getBaseMetaTileEntity().getWorld())) {
                StructureLibAPI.sendAlignment((IAlignmentProvider)((IAlignmentProvider)base), (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(base.getWorld().field_73011_w.field_76574_g, (double)base.getXCoord(), (double)base.getYCoord(), (double)base.getZCoord(), 512.0));
            } else {
                base.issueTextureUpdate();
            }
        }
    }

    @Override
    public final boolean isFacingValid(ForgeDirection facing) {
        return this.canSetToDirectionAny(facing);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (wrenchingSide != this.getBaseMetaTileEntity().getFrontFacing()) {
            return super.onWrenchRightClick(side, wrenchingSide, entityPlayer, aX, aY, aZ);
        }
        if (entityPlayer.func_70093_af()) {
            if (!this.isFlipChangeAllowed()) return false;
            this.toolSetFlip(this.getFlip().isHorizontallyFlipped() ? Flip.NONE : Flip.HORIZONTAL);
            return true;
        } else {
            if (!this.isRotationChangeAllowed()) return false;
            this.toolSetRotation(null);
        }
        return true;
    }

    @Override
    public void onFacingChange() {
        this.toolSetDirection(this.getBaseMetaTileEntity().getFrontFacing());
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.mLimits;
    }

    protected void setAlignmentLimits(IAlignmentLimits mLimits) {
        this.mLimits = mLimits;
    }

    public abstract IStructureDefinition<T> getStructureDefinition();

    @Override
    protected abstract GT_Multiblock_Tooltip_Builder createTooltip();

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("eRotation", (byte)this.mExtendedFacing.getRotation().getIndex());
        aNBT.func_74774_a("eFlip", (byte)this.mExtendedFacing.getFlip().getIndex());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mExtendedFacing = ExtendedFacing.of((ForgeDirection)this.getBaseMetaTileEntity().getFrontFacing(), (Rotation)Rotation.byIndex((int)aNBT.func_74771_c("eRotation")), (Flip)Flip.byIndex((int)aNBT.func_74771_c("eFlip")));
        if (!this.getAlignmentLimits().isNewExtendedFacingValid(this.mExtendedFacing)) {
            this.mExtendedFacing = this.getCorrectedAlignment(this.mExtendedFacing);
        }
    }

    protected ExtendedFacing getCorrectedAlignment(ExtendedFacing aOldFacing) {
        if (this.isNewExtendedFacingValid(ExtendedFacing.DEFAULT)) {
            return ExtendedFacing.DEFAULT;
        }
        for (ExtendedFacing facing : ExtendedFacing.VALUES) {
            if (facing.getFlip().isVerticallyFliped() || !this.isNewExtendedFacingValid(facing)) continue;
            return facing;
        }
        throw new AssertionError((Object)"No ExtendedFacing can pass the test of isNewExtendedFacingValid");
    }

    private IStructureDefinition<GT_MetaTileEntity_EnhancedMultiBlockBase<T>> getCastedStructureDefinition() {
        return this.getStructureDefinition();
    }

    protected final boolean checkPiece(String piece, int horizontalOffset, int verticalOffset, int depthOffset) {
        IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
        return this.getCastedStructureDefinition().check((Object)this, piece, tTile.getWorld(), this.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), horizontalOffset, verticalOffset, depthOffset, !this.mMachine);
    }

    protected final boolean buildPiece(String piece, ItemStack trigger, boolean hintOnly, int horizontalOffset, int verticalOffset, int depthOffset) {
        IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
        return this.getCastedStructureDefinition().buildOrHints((Object)this, trigger, piece, tTile.getWorld(), this.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), horizontalOffset, verticalOffset, depthOffset, hintOnly);
    }

    @Deprecated
    protected final int survivialBuildPiece(String piece, ItemStack trigger, int horizontalOffset, int verticalOffset, int depthOffset, int elementsBudget, IItemSource source, EntityPlayerMP actor, boolean check) {
        IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
        return this.getCastedStructureDefinition().survivalBuild((Object)this, trigger, piece, tTile.getWorld(), this.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), horizontalOffset, verticalOffset, depthOffset, elementsBudget, source, actor, check);
    }

    protected final int survivialBuildPiece(String piece, ItemStack trigger, int horizontalOffset, int verticalOffset, int depthOffset, int elementsBudget, ISurvivalBuildEnvironment env, boolean check) {
        IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
        return this.getCastedStructureDefinition().survivalBuild((Object)this, trigger, piece, tTile.getWorld(), this.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), horizontalOffset, verticalOffset, depthOffset, elementsBudget, env, check);
    }

    @Deprecated
    protected final int survivialBuildPiece(String piece, ItemStack trigger, int horizontalOffset, int verticalOffset, int depthOffset, int elementsBudget, IItemSource source, EntityPlayerMP actor, boolean check, boolean checkIfPlaced) {
        int built = this.survivialBuildPiece(piece, trigger, horizontalOffset, verticalOffset, depthOffset, elementsBudget, source, actor, check);
        if (checkIfPlaced && built > 0) {
            this.checkStructure(true, this.getBaseMetaTileEntity());
        }
        return built;
    }

    protected final int survivialBuildPiece(String piece, ItemStack trigger, int horizontalOffset, int verticalOffset, int depthOffset, int elementsBudget, ISurvivalBuildEnvironment env, boolean check, boolean checkIfPlaced) {
        int built = this.survivialBuildPiece(piece, trigger, horizontalOffset, verticalOffset, depthOffset, elementsBudget, env, check);
        if (checkIfPlaced && built > 0) {
            this.checkStructure(true, this.getBaseMetaTileEntity());
        }
        return built;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isClientSide()) {
            StructureLibAPI.queryAlignment((IAlignmentProvider)((IAlignmentProvider)aBaseMetaTileEntity));
        }
    }
}

