/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IDigitalChest;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.tesseract.TesseractHelper;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.GT_MetaTileEntity_TesseractTerminal;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.ArrayUtils;

public class GT_MetaTileEntity_TesseractGenerator
extends GT_MetaTileEntity_BasicTank {
    public static int TESSERACT_ENERGY_COST_DIMENSIONAL = 512;
    public static int TESSERACT_ENERGY_COST = 128;
    public byte isWorking = 0;
    public int oFrequency = 0;
    public int mNeededEnergy = 0;
    public int mFrequency = 0;
    public UUID mOwner;

    public GT_MetaTileEntity_TesseractGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "", new ITexture[0]);
    }

    public GT_MetaTileEntity_TesseractGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TesseractGenerator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean isTransformerUpgradable() {
        return true;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public long getMinimumStoredEU() {
        return this.getBaseMetaTileEntity().getEUCapacity() / 2L;
    }

    public long maxEUInput() {
        return 512L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxEUStore() {
        return 16384L;
    }

    public long maxSteamStore() {
        return this.maxEUStore();
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean ownerControl() {
        return true;
    }

    public int getProgresstime() {
        return TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency) == this && this.isWorking >= 20 ? 999 : 0;
    }

    public int maxProgresstime() {
        return 1000;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFrequency", this.mFrequency);
        if (this.mOwner != null) {
            aNBT.func_74778_a("mOwner", this.mOwner.toString());
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFrequency = aNBT.func_74762_e("mFrequency");
        try {
            this.mOwner = UUID.fromString(aNBT.func_74779_i("mOnwer"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void onConfigLoad(GT_Config aConfig) {
        int J = 4;
        TESSERACT_ENERGY_COST = 128 * J;
        TESSERACT_ENERGY_COST_DIMENSIONAL = 512 * J;
    }

    public void onServerStart() {
        CORE.sTesseractGeneratorOwnershipMap.clear();
        CORE.sTesseractTerminalOwnershipMap.clear();
    }

    public void onServerStop() {
        CORE.sTesseractGeneratorOwnershipMap.clear();
        CORE.sTesseractTerminalOwnershipMap.clear();
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.mOwner == null && this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().equals("") && this.getBaseMetaTileEntity().getOwnerName().toLowerCase().equals(aPlayer.getDisplayName().toLowerCase())) {
            this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
        }
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
                float[] tCoords = GT_Utility.getClickedFacingCoords((ForgeDirection)side, (float)aX, (float)aY, (float)aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        Logger.WARNING("Freq. -1 | " + this.mFrequency);
                        try {
                            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        --this.mFrequency;
                        break;
                    }
                    case 1: {
                        Logger.WARNING("Freq. +1 | " + this.mFrequency);
                        try {
                            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.mFrequency;
                    }
                }
                if (this.getGeneratorEntity(this.mFrequency) != null && this.getGeneratorEntity(this.mFrequency) != this) {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Frequency: " + this.mFrequency + EnumChatFormatting.RED + " (Occupied)"));
                } else {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Frequency: " + this.mFrequency));
                }
            } else if (aPlayer.func_110124_au().compareTo(this.mOwner) != 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"This is not your Tesseract Generator to configure.");
            }
        }
        return true;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
            if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
                float[] tCoords = GT_Utility.getClickedFacingCoords((ForgeDirection)side, (float)aX, (float)aY, (float)aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        try {
                            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 64;
                        break;
                    }
                    case 1: {
                        try {
                            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 64;
                        break;
                    }
                    case 2: {
                        try {
                            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 512;
                        break;
                    }
                    case 3: {
                        try {
                            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 512;
                    }
                }
                if (this.getGeneratorEntity(this.mFrequency) != null && this.getGeneratorEntity(this.mFrequency) != this) {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Frequency: " + this.mFrequency + EnumChatFormatting.RED + " (Occupied)"));
                } else {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Frequency: " + this.mFrequency));
                }
            }
        } else {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"This is not your Tesseract Generator to configure.");
        }
    }

    public boolean allowCoverOnSide(ForgeDirection side, int aCoverID) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public String[] getInfoData() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IGregTechDeviceInformation && ((IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
            return ((IGregTechDeviceInformation)tTileEntity).getInfoData();
        }
        return new String[]{"Tesseract Generator", "Freqency:", "" + this.mFrequency, this.getGeneratorEntity() == this && this.isWorking >= 20 ? "Active" : "Inactive"};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean isSendingInformation() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IGregTechDeviceInformation) {
            return ((IGregTechDeviceInformation)tTileEntity).isGivingInformation();
        }
        return false;
    }

    public boolean isDigitalChest() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            return ((IDigitalChest)tTileEntity).isDigitalChest();
        }
        return false;
    }

    public ItemStack[] getStoredItemData() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            return ((IDigitalChest)tTileEntity).getStoredItemData();
        }
        return new ItemStack[0];
    }

    public void setItemCount(int aCount) {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            ((IDigitalChest)tTileEntity).setItemCount(aCount);
        }
    }

    public int getMaxItemCount() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            return ((IDigitalChest)tTileEntity).getMaxItemCount();
        }
        return 0;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int ordinalSide) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return new int[0];
        }
        if (tTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)tTileEntity).func_94128_d(ordinalSide);
        }
        int[] rArray = new int[this.func_70302_i_()];
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            rArray[i] = i;
        }
        return rArray;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        if (tTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)tTileEntity).func_102007_a(aIndex, aStack, ordinalSide);
        }
        return true;
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        if (tTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)tTileEntity).func_102008_b(aIndex, aStack, ordinalSide);
        }
        return true;
    }

    public int func_70302_i_() {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70302_i_();
    }

    public ItemStack func_70301_a(int aIndex) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70301_a(aIndex);
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return;
        }
        tTileEntity.func_70299_a(aIndex, aStack);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70298_a(aIndex, aAmount);
    }

    public String func_145825_b() {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return "";
        }
        return tTileEntity.func_145825_b();
    }

    public int func_70297_j_() {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70297_j_();
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canFill(aSide, aFluid);
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canDrain(aSide, aFluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return new FluidTankInfo[0];
        }
        return tTileEntity.getTankInfo(aSide);
    }

    public int fill_default(ForgeDirection aDirection, FluidStack aFluid, boolean doFill) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.fill(aDirection, aFluid, doFill);
    }

    public FluidStack drain(ForgeDirection aDirection, int maxDrain, boolean doDrain) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aDirection, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aSide, aFluid, doDrain);
    }

    public boolean addEnergyConsumption(GT_MetaTileEntity_TesseractTerminal aTerminal) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        int J = aTerminal.getBaseMetaTileEntity().getWorld() == this.getBaseMetaTileEntity().getWorld() ? TESSERACT_ENERGY_COST : TESSERACT_ENERGY_COST_DIMENSIONAL;
        this.mNeededEnergy += (J *= 4);
        return true;
    }

    public boolean isValidTesseractGenerator(String aOwnerName, boolean aWorkIrrelevant) {
        return !(this.getBaseMetaTileEntity() == null || this.getBaseMetaTileEntity().isInvalidTileEntity() || !this.getBaseMetaTileEntity().isAllowedToWork() || aOwnerName != null && !this.getBaseMetaTileEntity().getOwnerName().equals(aOwnerName) || !aWorkIrrelevant && this.isWorking < 20);
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName()) != null && this.mOwner == null) {
                Logger.WARNING("Setting Generators Owner. 1");
                this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
            }
            if (this.mFrequency != this.oFrequency) {
                Logger.WARNING("mFreq != oFreq");
                if (this.getGeneratorEntity() == this) {
                    this.getGeneratorEntity(this.oFrequency);
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                    Logger.WARNING("this Gen == oFreq on map - do block update");
                }
                Logger.WARNING("mFreq will be set to oFreq");
                this.oFrequency = this.mFrequency;
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)this.mNeededEnergy, false)) {
                if (this.getGeneratorEntity(this.mFrequency) == null || !this.getGeneratorEntity(this.mFrequency).isValidTesseractGenerator(null, true)) {
                    TesseractHelper.setGeneratorOwnershipByPlayer(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency, this);
                }
            } else {
                if (this.getGeneratorEntity(this.mFrequency) == this) {
                    Logger.WARNING("this gen == mFreq on map - do block update");
                    TesseractHelper.removeGenerator(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency);
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                }
                this.isWorking = 0;
            }
            if (this.getGeneratorEntity(this.mFrequency) == this) {
                if (this.isWorking < 20) {
                    this.isWorking = (byte)(this.isWorking + 1);
                }
                if (this.isWorking == 20) {
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                    this.isWorking = (byte)(this.isWorking + 1);
                }
            } else {
                this.isWorking = 0;
            }
            this.mNeededEnergy = 0;
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Generates a Tesseract for the attached Inventory", "Connect with pipes to insert items", "Consumes " + TESSERACT_ENERGY_COST + "EU/t for same dimension transfers", "Consumes " + TESSERACT_ENERGY_COST_DIMENSIONAL + "EU/t for cross dimensional transfers", CORE.GT_Tooltip.get()});
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (side == facing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Screen_Frequency);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.VOID);
        }
        return iTextureArray;
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return false;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    private GT_MetaTileEntity_TesseractGenerator getGeneratorEntity() {
        GT_MetaTileEntity_TesseractGenerator thisGenerator = TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency);
        if (thisGenerator != null) {
            return thisGenerator;
        }
        return null;
    }

    private GT_MetaTileEntity_TesseractGenerator getGeneratorEntity(int frequency) {
        GT_MetaTileEntity_TesseractGenerator thisGenerator = TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), frequency);
        if (thisGenerator != null) {
            return thisGenerator;
        }
        return null;
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().equals("")) {
            this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
            Logger.WARNING("Setting Generators Owner. 2");
        }
        super.onCreated(aStack, aWorld, aPlayer);
    }

    public void onRemoval() {
        try {
            CORE.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onRemoval();
    }
}

