/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.objects;

import gregtech.api.objects.GT_ArrayList;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.objects.GregtechMaterialStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class GregtechItemData {
    private static final GregtechMaterialStack[] EMPTY_GT_MaterialStack_ARRAY = new GregtechMaterialStack[0];
    public final List<Object> mExtraData = new GT_ArrayList(false, 1);
    public final GregtechOrePrefixes mPrefix;
    public final GregtechMaterialStack mMaterial;
    public final GregtechMaterialStack[] mByProducts;
    public boolean mBlackListed = false;
    public ItemStack mUnificationTarget = null;

    public GregtechItemData(GregtechOrePrefixes aPrefix, GregtechOrePrefixes.GT_Materials aMaterial, boolean aBlackListed) {
        GregtechMaterialStack[] gregtechMaterialStackArray;
        this.mPrefix = aPrefix;
        this.mMaterial = aMaterial == null ? null : new GregtechMaterialStack(aMaterial, aPrefix.mMaterialAmount);
        this.mBlackListed = aBlackListed;
        if (aPrefix.mSecondaryMaterial == null || aPrefix.mSecondaryMaterial.mMaterial == null) {
            gregtechMaterialStackArray = EMPTY_GT_MaterialStack_ARRAY;
        } else {
            GregtechMaterialStack[] gregtechMaterialStackArray2 = new GregtechMaterialStack[1];
            gregtechMaterialStackArray = gregtechMaterialStackArray2;
            gregtechMaterialStackArray2[0] = aPrefix.mSecondaryMaterial.clone();
        }
        this.mByProducts = gregtechMaterialStackArray;
    }

    public GregtechItemData(GregtechOrePrefixes aPrefix, GregtechOrePrefixes.GT_Materials aMaterial) {
        this(aPrefix, aMaterial, false);
    }

    public GregtechItemData(GregtechMaterialStack aMaterial, GregtechMaterialStack ... aByProducts) {
        this.mPrefix = null;
        this.mMaterial = aMaterial.mMaterial == null ? null : aMaterial.clone();
        this.mBlackListed = true;
        if (aByProducts == null) {
            this.mByProducts = EMPTY_GT_MaterialStack_ARRAY;
        } else {
            GregtechMaterialStack[] tByProducts = aByProducts.length < 1 ? EMPTY_GT_MaterialStack_ARRAY : new GregtechMaterialStack[aByProducts.length];
            int j = 0;
            for (GregtechMaterialStack aByProduct : aByProducts) {
                if (aByProduct == null || aByProduct.mMaterial == null) continue;
                tByProducts[j++] = aByProduct.clone();
            }
            this.mByProducts = j > 0 ? new GregtechMaterialStack[j] : EMPTY_GT_MaterialStack_ARRAY;
            for (int i = 0; i < this.mByProducts.length; ++i) {
                this.mByProducts[i] = tByProducts[i];
            }
        }
    }

    public GregtechItemData(GregtechOrePrefixes.GT_Materials aMaterial, long aAmount, GregtechMaterialStack ... aByProducts) {
        this(new GregtechMaterialStack(aMaterial, aAmount), aByProducts);
    }

    public GregtechItemData(GregtechOrePrefixes.GT_Materials aMaterial, long aAmount, GregtechOrePrefixes.GT_Materials aByProduct, long aByProductAmount) {
        this(new GregtechMaterialStack(aMaterial, aAmount), new GregtechMaterialStack(aByProduct, aByProductAmount));
    }

    public GregtechItemData(GregtechItemData ... aData) {
        this.mPrefix = null;
        this.mBlackListed = true;
        ArrayList<GregtechMaterialStack> aList = new ArrayList<GregtechMaterialStack>();
        ArrayList<GregtechMaterialStack> rList = new ArrayList<GregtechMaterialStack>();
        for (GregtechItemData tData : aData) {
            if (tData == null) continue;
            if (tData.hasValidMaterialData() && tData.mMaterial.mAmount > 0L) {
                aList.add(tData.mMaterial.clone());
            }
            for (GregtechMaterialStack tMaterial : tData.mByProducts) {
                if (tMaterial.mAmount <= 0L) continue;
                aList.add(tMaterial.clone());
            }
        }
        for (GregtechMaterialStack aMaterial : aList) {
            boolean temp = true;
            for (GregtechMaterialStack tMaterial : rList) {
                if (aMaterial.mMaterial != tMaterial.mMaterial) continue;
                tMaterial.mAmount += aMaterial.mAmount;
                temp = false;
                break;
            }
            if (!temp) continue;
            rList.add(aMaterial.clone());
        }
        rList.sort((a, b) -> Long.compare(b.mAmount, a.mAmount));
        if (rList.isEmpty()) {
            this.mMaterial = null;
        } else {
            this.mMaterial = (GregtechMaterialStack)rList.get(0);
            rList.remove(0);
        }
        this.mByProducts = rList.toArray(new GregtechMaterialStack[0]);
    }

    public boolean hasValidPrefixMaterialData() {
        return this.mPrefix != null && this.mMaterial != null && this.mMaterial.mMaterial != null;
    }

    public boolean hasValidPrefixData() {
        return this.mPrefix != null;
    }

    public boolean hasValidMaterialData() {
        return this.mMaterial != null && this.mMaterial.mMaterial != null;
    }

    public ArrayList<GregtechMaterialStack> getAllGT_MaterialStacks() {
        ArrayList<GregtechMaterialStack> rList = new ArrayList<GregtechMaterialStack>();
        if (this.hasValidMaterialData()) {
            rList.add(this.mMaterial);
        }
        rList.addAll(Arrays.asList(this.mByProducts));
        return rList;
    }

    public GregtechMaterialStack getByProduct(int aIndex) {
        return aIndex >= 0 && aIndex < this.mByProducts.length ? this.mByProducts[aIndex] : null;
    }

    public String toString() {
        if (this.mPrefix == null || this.mMaterial == null || this.mMaterial.mMaterial == null) {
            return "";
        }
        return this.mPrefix.name() + this.mMaterial.mMaterial.name();
    }
}

